/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.themes.ICategorizedThemeElementDefinition;
import org.eclipse.ui.internal.themes.IHierarchalThemeElementDefinition;

public class FontDefinition
implements IHierarchalThemeElementDefinition,
ICategorizedThemeElementDefinition {
    private static FontPreferenceListener fontPreferenceUpdateListener;
    private String label;
    private String id;
    private String defaultsTo;
    private String categoryId;
    private String description;
    private String value;
    private boolean isEditable;

    public static IPropertyChangeListener getPreferenceListener() {
        if (fontPreferenceUpdateListener == null) {
            fontPreferenceUpdateListener = new FontPreferenceListener();
        }
        return fontPreferenceUpdateListener;
    }

    public FontDefinition(String fontName, String uniqueId, String defaultsId, String value, String categoryId, boolean isEditable, String fontDescription) {
        this.label = fontName;
        this.id = uniqueId;
        this.defaultsTo = defaultsId;
        this.value = value;
        this.categoryId = categoryId;
        this.description = fontDescription;
        this.isEditable = isEditable;
    }

    public String getDefaultsTo() {
        return this.defaultsTo;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabel() {
        return this.label;
    }

    public String getId() {
        return this.id;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public String getValue() {
        return this.value;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public static class FontPreferenceListener
    implements IPropertyChangeListener {
        private Set defaultCheckNames;
        private Set fontNames;

        public void propertyChange(PropertyChangeEvent event) {
            String propertyName = event.getProperty();
            if (this.defaultCheckNames == null) {
                this.initializeFontNames();
            }
            if (this.defaultCheckNames.contains(propertyName)) {
                this.processDefaultsTo(propertyName);
            }
            if (this.fontNames.contains(propertyName)) {
                Object newValue = event.getNewValue();
                if (newValue == null) {
                    return;
                }
                FontData[] newSetting = newValue instanceof String ? PreferenceConverter.readFontData((String)((String)newValue)) : (FontData[])newValue;
                JFaceResources.getFontRegistry().put(propertyName, newSetting);
            }
        }

        private void processDefaultsTo(String propertyName) {
            FontDefinition[] defs = WorkbenchPlugin.getDefault().getThemeRegistry().getFonts();
            IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
            int i = 0;
            while (i < defs.length) {
                String defaultsTo = defs[i].getDefaultsTo();
                if (defaultsTo != null && defaultsTo.equals(propertyName) && store.isDefault(defs[i].getId())) {
                    FontData[] data = PreferenceConverter.getFontDataArray((IPreferenceStore)store, (String)defaultsTo);
                    JFaceResources.getFontRegistry().put(defs[i].getId(), data);
                }
                ++i;
            }
        }

        private void initializeFontNames() {
            this.defaultCheckNames = new HashSet();
            this.fontNames = new HashSet();
            FontDefinition[] defs = WorkbenchPlugin.getDefault().getThemeRegistry().getFonts();
            int i = 0;
            while (i < defs.length) {
                this.fontNames.add(defs[i].getId());
                String defaultsTo = defs[i].getDefaultsTo();
                if (defaultsTo != null) {
                    this.defaultCheckNames.add(defaultsTo);
                }
                ++i;
            }
        }

        public void clearCache() {
            this.defaultCheckNames = null;
        }
    }
}

