/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.progress.AwaitingFeedbackInfo;
import org.eclipse.ui.internal.progress.ProgressFeedbackDialog;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.progress.UIJob;

public class ProgressFeedbackManager {
    private ProgressFeedbackDialog dialog;
    List pendingInfos = new ArrayList();
    private UIJob openProgressJob = new UIJob(ProgressMessages.getString("ProgressFeedbackManager.OpenFeedbackJob")){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            ProgressFeedbackManager.this.openProgressRequestDialog();
            return Status.OK_STATUS;
        }
    };
    IStructuredContentProvider contentProvider = this.getContentProvider();

    ProgressFeedbackManager() {
    }

    IStatus requestInUI(UIJob job, String message) {
        if (Thread.currentThread() == Display.getDefault().getThread()) {
            throw new IllegalThreadStateException(ProgressMessages.getString("ProgressFeedbackManager.invalidThreadMessage"));
        }
        final IStatus[] statuses = new IStatus[1];
        final AwaitingFeedbackInfo info = new AwaitingFeedbackInfo(message, job);
        this.pendingInfos.add(info);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!PlatformUI.isWorkbenchRunning()) {
                    return;
                }
                statuses[0] = event.getResult();
                ProgressFeedbackManager.this.pendingInfos.remove(info);
                ProgressFeedbackManager.this.refreshDialog();
            }
        });
        this.openProgressJob.schedule();
        try {
            job.join();
        }
        catch (InterruptedException exception) {
            return ProgressManagerUtil.exceptionStatus(exception);
        }
        return statuses[0];
    }

    void openProgressRequestDialog() {
        if (this.dialog == null) {
            this.dialog = new ProgressFeedbackDialog(this.contentProvider);
            this.dialog.create();
            this.dialog.getShell().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent arg0) {
                    ProgressFeedbackManager.this.clearDialog();
                }
            });
            this.dialog.open();
        } else {
            this.refreshDialog();
            this.dialog.getShell().forceFocus();
        }
    }

    void clearDialog() {
        this.dialog = null;
    }

    void refreshDialog() {
        this.dialog.refreshViewer();
    }

    private IStructuredContentProvider getContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ProgressFeedbackManager.this.pendingInfos.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                viewer.refresh();
            }
        };
    }
}

