/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.presentations.LayoutCache;

public class TabFolderLayout {
    private CTabFolder tabFolder;
    private Control[] topControls;
    private LayoutCache cache;
    private Rectangle centerArea = new Rectangle(0, 0, 0, 0);
    private int trimStart;
    private boolean trimOnTop = false;
    private int leftAligned = 0;

    public TabFolderLayout(CTabFolder folder) {
        this.tabFolder = folder;
        this.setTopRight(new Control[0]);
    }

    public void dispose() {
    }

    public Control[] getTopRight() {
        return this.topControls;
    }

    public Rectangle getClientBounds() {
        return this.centerArea;
    }

    public int getTrimStart() {
        return this.trimStart;
    }

    public void setNumLeftAligned(int leftAligned) {
        this.leftAligned = leftAligned;
    }

    public boolean isTrimOnTop() {
        return this.trimOnTop;
    }

    public void setTopRight(Control[] upperRight) {
        this.topControls = upperRight;
        this.cache = new LayoutCache(upperRight);
    }

    public void layout() {
        this.cache.flush();
        Rectangle bounds = this.tabFolder.getBounds();
        this.trimStart = bounds.width;
        Rectangle clientBounds = TabFolderLayout.calculatePageBounds(this.tabFolder);
        Rectangle trimRegion = this.getTitleTrimRegion();
        Point trimSize = this.computeTrimSize(this.leftAligned, this.topControls.length - this.leftAligned);
        this.trimOnTop = trimSize.x <= trimRegion.width && trimSize.y <= trimRegion.height;
        int idx = 0;
        int lastBottomControl = this.topControls.length;
        if (this.trimOnTop) {
            this.trimStart = this.align(this.leftAligned, this.topControls.length - this.leftAligned, trimRegion, true) - bounds.x;
            this.centerArea = clientBounds;
            lastBottomControl = this.leftAligned;
        }
        int leftMargin = 2;
        Rectangle currentRect = new Rectangle(clientBounds.x + leftMargin, clientBounds.y, clientBounds.width - leftMargin, 0);
        while (idx < lastBottomControl) {
            currentRect.height = 0;
            int rowWidth = 0;
            int rowCount = 0;
            while (idx + rowCount < lastBottomControl) {
                Point nextSize = this.cache.computeSize(idx + rowCount, -1, -1);
                if ((rowWidth += nextSize.x) > clientBounds.width) break;
                currentRect.height = Math.max(currentRect.height, nextSize.y);
                ++rowCount;
            }
            if (rowCount > 0) {
                this.align(idx, rowCount, currentRect, false);
                idx += rowCount;
            } else {
                Point size = this.cache.computeSize(idx, clientBounds.width, -1);
                currentRect.height = size.y;
                this.topControls[idx].setBounds(currentRect);
                ++idx;
            }
            currentRect.y += currentRect.height;
        }
        this.centerArea = new Rectangle(clientBounds.x, currentRect.y, clientBounds.width, clientBounds.height + clientBounds.y - currentRect.y);
    }

    private int align(int firstControl, int numControls, Rectangle region, boolean centerAlign) {
        int lastLeftAligned = Math.max(firstControl, Math.min(firstControl + numControls, this.leftAligned));
        Point leftSize = this.computeTrimSize(firstControl, lastLeftAligned - firstControl);
        Point rightSize = this.computeTrimSize(lastLeftAligned, numControls + firstControl - lastLeftAligned);
        int currentPos = region.x;
        Rectangle bounds = this.tabFolder.getBounds();
        currentPos = region.x;
        if (centerAlign) {
            int minimum = bounds.x + (bounds.width - leftSize.x) / 2;
            int maximum = region.x + region.width - rightSize.x - leftSize.x;
            currentPos = Math.min(Math.max(minimum, region.x), maximum);
        }
        int start = firstControl < lastLeftAligned ? currentPos : region.x + region.width - rightSize.x;
        int leftAligned = firstControl;
        while (leftAligned < lastLeftAligned) {
            Point size = this.cache.computeSize(leftAligned, -1, -1);
            this.topControls[leftAligned].setBounds(currentPos, region.y + (region.height - size.y) / 2, size.x, size.y);
            currentPos += size.x;
            ++leftAligned;
        }
        currentPos = region.x + region.width;
        int idx = firstControl + numControls - 1;
        while (idx >= leftAligned) {
            Point size = this.cache.computeSize(idx, -1, -1);
            this.topControls[idx].setBounds(currentPos - size.x, region.y + (region.height - size.y) / 2, size.x, size.y);
            currentPos -= size.x;
            --idx;
        }
        return start;
    }

    protected Rectangle getTitleTrimRegion() {
        Rectangle result = new Rectangle(0, 0, 0, 0);
        int itemCount = this.tabFolder.getItemCount();
        if (itemCount > 0) {
            CTabItem item = this.tabFolder.getItem(itemCount - 1);
            Rectangle itemBounds = item.getBounds();
            result.x = itemBounds.x + itemBounds.width;
            result.height = itemBounds.height;
            result.y = itemBounds.y;
            result.width = TabFolderLayout.getAvailableSpace(this.tabFolder);
        }
        Rectangle bounds = this.tabFolder.getBounds();
        result.x += bounds.x;
        result.y += bounds.y;
        int borderSize = 1;
        result.y += borderSize;
        result.height = this.tabFolder.getTabHeight() - this.differenceBetweenTabHeightAndTrimRegion();
        int xShift = 5;
        result.x += xShift;
        result.width -= xShift;
        return result;
    }

    public int differenceBetweenTabHeightAndTrimRegion() {
        return 2;
    }

    protected static int getAvailableSpace(CTabFolder folder) {
        int available = folder.getBounds().width;
        available -= 2 * folder.getBorderWidth();
        available -= folder.getChevronBounds().width;
        available -= folder.getMaximizeBounds().width;
        available -= folder.getMinimizeBounds().width;
        available -= 10;
        CTabItem[] tabs = folder.getItems();
        int idx = 0;
        while (idx < tabs.length) {
            CTabItem item = tabs[idx];
            if (!item.isShowing()) {
                return 0;
            }
            available -= item.getBounds().width;
            ++idx;
        }
        return Math.max(0, available);
    }

    protected Point computeTrimSize(int start, int length) {
        int width = 0;
        int height = 0;
        int last = start + length;
        int idx = start;
        while (idx < last) {
            Point next = this.cache.computeSize(idx, -1, -1);
            width += next.x;
            height = Math.max(height, next.y);
            ++idx;
        }
        return new Point(width, height);
    }

    private static Rectangle calculatePageBounds(CTabFolder folder) {
        if (folder == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle bounds = folder.getBounds();
        Rectangle offset = folder.getClientArea();
        bounds.x += offset.x;
        bounds.y += offset.y;
        bounds.width = offset.width;
        bounds.height = offset.height;
        return bounds;
    }
}

