/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.preferences;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.SafeFileInputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

public class InstancePreferences
extends EclipsePreferences {
    private static final String DEFAULT_PREFERENCES_FILENAME = "prefs.ini";
    private static final String OLD_EXTENSION = ".old";
    private String qualifier;
    private int segmentCount;
    private EclipsePreferences loadLevel;
    private IPath location;
    private static Set loadedNodes = new HashSet();

    public InstancePreferences() {
        this(null, null);
    }

    private InstancePreferences(IEclipsePreferences parent, String name) {
        super(parent, name);
        this.initialize();
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences node) {
        return loadedNodes.contains(node.name());
    }

    protected void loaded() {
        loadedNodes.add(this.name());
    }

    public void sync() throws BackingStoreException {
        if (this.location == null) {
            if (InternalPlatform.DEBUG_PREFERENCES) {
                System.out.println("Unable to determine location of preference file for node: " + this.absolutePath());
            }
            return;
        }
        IEclipsePreferences node = this.getLoadLevel();
        if (node == null) {
            if (InternalPlatform.DEBUG_PREFERENCES) {
                System.out.println("Preference node is not a load root: " + this.absolutePath());
            }
            return;
        }
        if (node instanceof EclipsePreferences) {
            ((EclipsePreferences)node).load(this.location);
            node.flush();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadLegacy() {
        block17: {
            path = new Path(this.absolutePath());
            if (path.segmentCount() != 2) {
                return;
            }
            bundleName = path.segment(1);
            prefFile = InternalPlatform.getDefault().getMetaArea().getPreferenceLocation(bundleName, false).toFile();
            if (!prefFile.exists()) {
                if (InternalPlatform.DEBUG_PREFERENCES == false) return;
                System.out.println("Legacy plug-in preference file not found: " + prefFile);
                return;
            }
            if (InternalPlatform.DEBUG_PREFERENCES) {
                System.out.println("Loading legacy preferences from " + prefFile);
            }
            input = null;
            values = new Properties();
            try {
                try {
                    input = new SafeFileInputStream(prefFile);
                    values.load(input);
                }
                catch (IOException e) {
                    if (InternalPlatform.DEBUG_PREFERENCES) {
                        message = "IOException encountered loading legacy preference file " + prefFile;
                        status = new Status(4, "org.eclipse.core.runtime", 4, message, e);
                        this.log(status);
                    }
                    var9_12 = null;
                    if (input == null) return;
                    try {
                        input.close();
                        return;
                    }
                    catch (IOException e) {
                        if (InternalPlatform.DEBUG_PREFERENCES == false) return;
                        System.out.println("IOException encountered closing legacy preference file " + prefFile);
                        e.printStackTrace();
                    }
                    return;
                }
            }
            catch (Throwable var10_18) {
                var9_13 = null;
                if (input == null) throw var10_18;
                ** try [egrp 2[TRYBLOCK] [3 : 212->220)] { 
lbl40:
                // 1 sources

                input.close();
                throw var10_18;
lbl42:
                // 1 sources

                catch (IOException e) {
                    if (InternalPlatform.DEBUG_PREFERENCES == false) throw var10_18;
                    System.out.println("IOException encountered closing legacy preference file " + prefFile);
                    e.printStackTrace();
                }
                throw var10_18;
            }
            {
                var9_14 = null;
                if (input == null) break block17;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 212->220)] { 
lbl50:
            // 1 sources

            input.close();
            break block17;
lbl52:
            // 1 sources

            catch (IOException e) {
                if (!InternalPlatform.DEBUG_PREFERENCES) break block17;
                System.out.println("IOException encountered closing legacy preference file " + prefFile);
                e.printStackTrace();
            }
        }
        if (this.properties == null) {
            this.properties = new Properties();
        }
        i = values.keySet().iterator();
        while (true) {
            if (!i.hasNext()) {
                destFile = new File(String.valueOf(prefFile.getAbsolutePath()) + ".old" + '.' + System.currentTimeMillis());
                if (prefFile.renameTo(destFile) != false) return;
                if (InternalPlatform.DEBUG_PREFERENCES == false) return;
                System.out.println("Unable to rename legacy preferences file: " + prefFile + " -> " + destFile);
                return;
            }
            key = (String)i.next();
            value = values.getProperty(key);
            if (value == null) continue;
            if (InternalPlatform.DEBUG_PREFERENCES) {
                System.out.println("Loaded legacy preference: " + key + " -> " + value);
            }
            this.properties.put(key, value);
            this.makeDirty();
        }
    }

    protected IPath getLocation() {
        return this.location;
    }

    private void initialize() {
        Path path = new Path(this.absolutePath());
        this.segmentCount = path.segmentCount();
        if (this.segmentCount < 2) {
            return;
        }
        String scope = path.segment(0);
        if ("instance".equals(scope)) {
            this.qualifier = path.segment(1);
        }
        if (this.qualifier == null) {
            return;
        }
        this.location = InternalPlatform.getDefault().getMetaArea().getStateLocation(this.qualifier).append(DEFAULT_PREFERENCES_FILENAME);
    }

    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.qualifier == null) {
                return null;
            }
            EclipsePreferences node = this;
            int i = 2;
            while (i < this.segmentCount) {
                node = (EclipsePreferences)node.parent();
                ++i;
            }
            this.loadLevel = node;
        }
        return this.loadLevel;
    }

    protected EclipsePreferences internalCreate(IEclipsePreferences nodeParent, String nodeName) {
        return new InstancePreferences(nodeParent, nodeName);
    }
}

