/* ------------------------------------------------------------------------ */
/*                                                                          */
/* [prs_io.h]       LALR(1) Parser/Generator: parse table input/output      */
/*                                                                          */
/* Copyright (c) 1993 by D\olle, Manns                                      */
/* ------------------------------------------------------------------------ */

/* File generated by 'ctoh'. Don't change manually. */

#ifndef prs_io_INCL
#define prs_io_INCL


#include "prs_dfn.h"
#include "binimg.h"


#ifdef __cplusplus
extern "C" {
#endif


/*  
   This module provides functions that
   1) generate a C module for a given parse table
   2) unload a parse table to a binary image file
   3) load a parse table from a binary image file.
*/

/* ------------------------------ C-Module ---------------------------------- */

void PLR_CTab_Source(FILE* fp, c_string fid, PLR_Tab PTab)
/* writes source for parse table 'PTab' to file 'fp';
   produces a source header if filename 'fid' is not empty
*/
;

void PLR_CTab_Modul(c_string Environ, PLR_Tab PTab, c_bool shortform)
#define PLR_printCTab PLR_CTab_Modul
/* creates source [$'Environ'/]<Language>_pim.c for parse table 'PTab' */
;

void PLR_Src_Source(FILE* fp, c_string fid, PLR_Tab PTab)
/* writes source for parse table 'PTab' to file 'fp';
   produces a source header if filename 'fid' is not empty
*/
;

void PLR_Src_Modul(c_string Environ, PLR_Tab PTab)
#define PLR_printCTab PLR_CTab_Modul
/* creates source [$'Environ'/]<Language>.ptbl for parse table 'PTab' */
;


/* ---------------------------- Binary Image -------------------------------- */

void PLR_fputTab_bin(BinImg_T img, PLR_Tab PTab)
/* unloads parse table 'PTab'
   to binary image 'img' (reentrant)
*/
;

void PLR_putTab_bin(PLR_Tab PTab)
/* unloads parse table 'PTab'
   to the current ( previously opened ) image
*/
;

void PLR_putTab(c_string Environ, PLR_Tab PTab)
/* unloads parse table 'PTab' to image [$'Environ'/]<Language>.pim */
;

PLR_Tab PLR_fgetTab_bin(BinImg_T img)
/* loads a parse table
   from binary image 'img' (reentrant)
*/
;

PLR_Tab PLR_getTab_bin(void)
/* loads a parse table
   from the current ( previously opened ) image
*/
;

PLR_Tab PLR_getTab(c_string Language)
/* loads a parse table named 'Language'
   from image [$PATH/]<Language>.pim
*/
;

PLR_Tab PLR_getTab_env(c_string Environ, c_string Language)
/* loads a parse table named 'Language'
   from image [$'Environ'/]<Language>.pim
*/
;

PLR_Tab PLR_getETab(Any_T Environ, c_string Language)
/* like PLR_getTab / PLR_getTab_env;
   can be used as embedded language parser contructor
   ( see function 'PT_setEParser' )
*/
;



#ifdef __cplusplus
}
#endif

#endif
