/*
 * SpanDSP - a series of DSP components for telephony
 *
 * v17rx.c - ITU V.17 modem receive part
 *
 * Written by Steve Underwood <steveu@coppice.org>
 *
 * Copyright (C) 2004 Steve Underwood
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: v17rx.c,v 1.13 2004/12/14 14:03:58 steveu Exp $
 */

/*! \file */

/* THIS IS A WORK IN PROGRESS - KIND OF FUNCTIONAL, BUT NOT ROBUST! */

#include <stdint.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "spandsp/telephony.h"
#include "spandsp/power_meter.h"
#include "spandsp/arctan2.h"
#include "spandsp/complex.h"
#include "spandsp/dds.h"
#include "spandsp/complex_filters.h"

#include "spandsp/v29rx.h"
#include "spandsp/v17rx.h"

/* Segments of the training sequence */
#define V17_TRAINING_SEG_1_LEN          256
#define V17_TRAINING_SEG_2_LEN          2976
#define V17_TRAINING_SHORT_SEG_2_LEN    38
#define V17_TRAINING_SEG_3_LEN          64
#define V17_TRAINING_SEG_4A_LEN         15
#define V17_TRAINING_SEG_4_LEN          48

#define V17_BRIDGE_WORD             0x8880

enum
{
    TRAINING_STAGE_NORMAL_OPERATION = 0,
    TRAINING_STAGE_SYMBOL_ACQUISITION,
    TRAINING_STAGE_LOG_PHASE,
    TRAINING_STAGE_SHORT_WAIT_FOR_CDBA,
    TRAINING_STAGE_WAIT_FOR_CDBA,
    TRAINING_STAGE_TRAIN_ON_CDBA,
    TRAINING_STAGE_SHORT_TRAIN_ON_CDBA_AND_TEST,
    TRAINING_STAGE_TRAIN_ON_CDBA_AND_TEST,
    TRAINING_STAGE_BRIDGE,
    TRAINING_STAGE_TCM_WINDUP,
    TRAINING_STAGE_TEST_ONES,
    TRAINING_STAGE_PARKED
};

/* The following are not an issue for multi-threading, as this is a global table
   of constants. The first thread generates it. A second thread, starting around
   the same time as the first, might duplicate the work. The outcome will still be
   the same. */
static uint8_t space_map_14400[90][90][8];
static uint8_t space_map_12000[90][90][8];
static uint8_t space_map_9600[90][90][8];
static uint8_t space_map_7200[90][90][8];
static int inited = FALSE;

/* Raised root cosine pulse shaping; Beta = 0.5; 4 symbols either
   side of the centre. We cannot simplify this by using only half
   the filter, as they 3 variants are each skewed by a 1/3 of a
   sample. Only the middle one is symmetric. */
#define PULSESHAPER_GAIN   10.00736638
#if 0
static const float pulseshaper[48][V17RX_FILTER_STEPS] =
{
    {
        -0.0077172773,    /* Filter 0 */
        -0.0038694321,
         0.0112115904,
         0.0124836134,
        -0.0082281633,
        -0.0167092864,
         0.0146132015,
         0.0413429837,
        -0.0147924454,
        -0.1313410544,
        -0.1320188601,
         0.1554566471,
         0.6664080627,
         1.0773601675,
         1.0773601675,
         0.6664080627,
         0.1554566471,
        -0.1320188601,
        -0.1313410544,
        -0.0147924454,
         0.0413429837,
         0.0146132015,
        -0.0167092864,
        -0.0082281633,
         0.0124836134,
         0.0112115904,
        -0.0038694321
    },
    {
        -0.0041244119,    /* Filter 1 */
        -0.0036083922,
         0.0114733973,
         0.0122241026,
        -0.0086953937,
        -0.0164559194,
         0.0155079202,
         0.0412120072,
        -0.0169863104,
        -0.1333196873,
        -0.1292784439,
         0.1646043954,
         0.6773475777,
         1.0822215889,
         1.0723073790,
         0.6554248879,
         0.1464170119,
        -0.1346244304,
        -0.1293125105,
        -0.0126316456,
         0.0414339250,
         0.0137183623,
        -0.0169421543,
        -0.0077555379,
         0.0127315677,
         0.0109431119,
        -0.0041244119
    },
    {
        -0.0043731652,    /* Filter 2 */
        -0.0033414650,
         0.0117282579,
         0.0119531772,
        -0.0091567523,
        -0.0161820543,
         0.0164017016,
         0.0410404216,
        -0.0192122152,
        -0.1352462396,
        -0.1264022918,
         0.1738581306,
         0.6882397074,
         1.0868898157,
         1.0670651207,
         0.6444017799,
         0.1374875558,
        -0.1370960973,
        -0.1272362227,
        -0.0105048989,
         0.0414854268,
         0.0128242090,
        -0.0171545394,
        -0.0072779944,
         0.0129678349,
         0.0106682397,
        -0.0043731652
    },
    {
        -0.0046155325,    /* Filter 3 */
        -0.0030688299,
         0.0119759017,
         0.0116709905,
        -0.0096117632,
        -0.0158877103,
         0.0172937187,
         0.0408276754,
        -0.0214690972,
        -0.1371185400,
        -0.1233895677,
         0.1832156667,
         0.6990807290,
         1.0913630919,
         1.0616353597,
         0.6333424645,
         0.1286702834,
        -0.1394348551,
        -0.1251143537,
        -0.0084131553,
         0.0414981056,
         0.0119315364,
        -0.0173464758,
        -0.0067960093,
         0.0131922955,
         0.0103872554,
        -0.0046155325
    },
    {
        -0.0048513612,    /* Filter 4 */
        -0.0027906730,
         0.0122160622,
         0.0113777066,
        -0.0100599512,
        -0.0155729245,
         0.0181831345,
         0.0405732405,
        -0.0237558566,
        -0.1389344167,
        -0.1202394894,
         0.1926747584,
         0.7098669242,
         1.0956397332,
         1.0560201310,
         0.6222506654,
         0.1199671379,
        -0.1416417489,
        -0.1229490616,
        -0.0063573274,
         0.0414725987,
         0.0110411278,
        -0.0175180145,
        -0.0063100588,
         0.0134048412,
         0.0101004434,
        -0.0048513612
    },
    {
        -0.0050805055,    /* Filter 5 */
        -0.0025071863,
         0.0124484774,
         0.0110735009,
        -0.0105008428,
        -0.0152377524,
         0.0190691031,
         0.0402766124,
        -0.0260713566,
        -0.1406916989,
        -0.1169513302,
         0.2022331022,
         0.7205945806,
         1.0997181284,
         1.0502215375,
         0.6111301022,
         0.1113800000,
        -0.1437178738,
        -0.1207424980,
        -0.0043382895,
         0.0414095629,
         0.0101537543,
        -0.0176692240,
        -0.0058206179,
         0.0136053750,
         0.0098080911,
        -0.0050805055
    },
    {
        -0.0053028267,    /* Filter 6 */
        -0.0022185685,
         0.0126728899,
         0.0107585598,
        -0.0109339660,
        -0.0148822675,
         0.0199507698,
         0.0399373110,
        -0.0284144241,
        -0.1423882175,
        -0.1135244193,
         0.2118883368,
         0.7312599938,
         1.1035967397,
         1.0442417482,
         0.5999844889,
         0.1029106879,
        -0.1456643740,
        -0.1184968073,
        -0.0023568781,
         0.0413096740,
         0.0092701743,
        -0.0178001892,
        -0.0053281603,
         0.0137938111,
         0.0095104884,
        -0.0053028267
    },
    {
        -0.0055181930,    /* Filter 7 */
        -0.0019250239,
         0.0128890474,
         0.0104330806,
        -0.0113588515,
        -0.0145065623,
         0.0208272719,
         0.0395548815,
        -0.0307838494,
        -0.1440218066,
        -0.1099581426,
         0.2216380443,
         0.7418594687,
         1.1072741035,
         1.0380829975,
         0.5888175322,
         0.0945609563,
        -0.1474824414,
        -0.1162141254,
        -0.0004138916,
         0.0411736260,
         0.0083911333,
        -0.0179110118,
        -0.0048331579,
         0.0139700749,
         0.0092079274,
        -0.0055181930
    },
    {
        -0.0057264799,    /* Filter 8 */
        -0.0016267630,
         0.0130967024,
         0.0100972717,
        -0.0117750324,
        -0.0141107475,
         0.0216977392,
         0.0391288948,
        -0.0331783869,
        -0.1455903047,
        -0.1062519435,
         0.2314797506,
         0.7523893215,
         1.1107488316,
         1.0317475841,
         0.5776329299,
         0.0863324965,
        -0.1491733154,
        -0.1138965787,
         0.0014899097,
         0.0410021305,
         0.0075173632,
        -0.0180018097,
        -0.0043360803,
         0.0141341030,
         0.0089007023,
        -0.0057264799
    },
    {
        -0.0059275699,    /* Filter 9 */
        -0.0013240021,
         0.0132956134,
         0.0097513521,
        -0.0121820448,
        -0.0136949529,
         0.0225612946,
         0.0386589480,
        -0.0355967552,
        -0.1470915558,
        -0.1024053236,
         0.2414109265,
         0.7628458810,
         1.1140196110,
         1.0252378699,
         0.5664343693,
         0.0782269355,
        -0.1507382808,
        -0.1115462830,
         0.0033538037,
         0.0407959159,
         0.0066495821,
        -0.0180727168,
        -0.0038373950,
         0.0142858431,
         0.0085891090,
        -0.0059275699
    },
    {
        -0.0061213530,    /* Filter 10 */
        -0.0010169632,
         0.0134855441,
         0.0093955517,
        -0.0125794285,
        -0.0132593270,
         0.0234170544,
         0.0381446654,
        -0.0380376377,
        -0.1485234109,
        -0.0984178433,
         0.2514289886,
         0.7732254908,
         1.1170852055,
         1.0185562789,
         0.5552255254,
         0.0702458358,
        -0.1521786680,
        -0.1091653424,
         0.0051771063,
         0.0405557266,
         0.0057884938,
        -0.0181238828,
        -0.0033375660,
         0.0144252539,
         0.0082734449,
        -0.0061213530
    },
    {
        -0.0063077263,    /* Filter 11 */
        -0.0007058736,
         0.0136662644,
         0.0090301109,
        -0.0129667273,
        -0.0128040373,
         0.0242641295,
         0.0375856989,
        -0.0404996829,
        -0.1498837288,
        -0.0942891228,
         0.2615313001,
         0.7835245105,
         1.1199444556,
         1.0117052957,
         0.5440100595,
         0.0623906951,
        -0.1534958509,
        -0.1067558483,
         0.0069591716,
         0.0402823226,
         0.0049347874,
        -0.0181554728,
        -0.0028370545,
         0.0145523054,
         0.0079540084,
        -0.0063077263
    },
    {
        -0.0064865941,    /* Filter 12 */
        -0.0003909662,
         0.0138375505,
         0.0086552808,
        -0.0133434892,
        -0.0123292702,
         0.0251016255,
         0.0369817283,
        -0.0429815045,
        -0.1511703778,
        -0.0900188421,
         0.2717151717,
         0.7937393177,
         1.1225962793,
         1.0046874648,
         0.5327916175,
         0.0546629459,
        -0.1546912466,
        -0.1043198784,
         0.0086993916,
         0.0399764783,
         0.0040891370,
        -0.0181676672,
        -0.0023363179,
         0.0146669781,
         0.0076310991,
        -0.0064865941
    },
    {
        -0.0066578683,    /* Filter 13 */
        -0.0000724789,
         0.0139991847,
         0.0082713225,
        -0.0137092670,
        -0.0118352313,
         0.0259286435,
         0.0363324626,
        -0.0454816823,
        -0.1523812363,
        -0.0856067424,
         0.2819778628,
         0.8038663095,
         1.1250396727,
         0.9975053893,
         0.5215738282,
         0.0470639554,
        -0.1557663137,
        -0.1018594956,
         0.0103971963,
         0.0396389819,
         0.0032522013,
        -0.0181606611,
        -0.0018358095,
         0.0147692639,
         0.0073050171,
        -0.0066578683
    },
    {
        -0.0068214680,    /* Filter 14 */
         0.0002493454,
         0.0141509564,
         0.0078785078,
        -0.0140636189,
        -0.0113221454,
         0.0267442806,
         0.0356376397,
        -0.0479987626,
        -0.1535141950,
        -0.0810526259,
         0.2923165823,
         0.8139019043,
         1.1272737104,
         0.9901617293,
         0.5103603020,
         0.0395950250,
        -0.1567225517,
        -0.0993767470,
         0.0120520536,
         0.0392706350,
         0.0024246234,
        -0.0181346643,
        -0.0013359786,
         0.0148591651,
         0.0069760629,
        -0.0068214680
    },
    {
        -0.0069773197,    /* Filter 15 */
         0.0005742587,
         0.0142926615,
         0.0074771184,
        -0.0144061086,
        -0.0107902564,
         0.0275476309,
         0.0348970277,
        -0.0505312582,
        -0.1545671571,
        -0.0763563569,
         0.3027284900,
         0.8238425431,
         1.1292975460,
         0.9826592009,
         0.4991546291,
         0.0322573902,
        -0.1575614998,
        -0.0968736629,
         0.0136634691,
         0.0388722515,
         0.0016070303,
        -0.0180899006,
        -0.0008372696,
         0.0149366950,
         0.0066445373,
        -0.0069773197
    },
    {
        -0.0071253572,    /* Filter 16 */
         0.0009020085,
         0.0144241033,
         0.0070674458,
        -0.0147363057,
        -0.0102398272,
         0.0283377856,
         0.0341104250,
        -0.0530776494,
        -0.1555380404,
        -0.0715178621,
         0.3132106970,
         0.8336846919,
         1.1311104123,
         0.9750005749,
         0.4879603781,
         0.0250522204,
        -0.1582847354,
        -0.0943522562,
         0.0152309858,
         0.0384446569,
         0.0008000327,
        -0.0180266078,
        -0.0003401218,
         0.0150018773,
         0.0063107407,
        -0.0071253572
    },
    {
        -0.0072655220,    /* Filter 17 */
         0.0012323380,
         0.0145450926,
         0.0066497916,
        -0.0150537867,
        -0.0096711403,
         0.0291138344,
         0.0332776610,
        -0.0556363845,
        -0.1564247779,
        -0.0665371312,
         0.3237602674,
         0.8434248424,
         1.1327116219,
         0.9671886754,
         0.4767810943,
         0.0179806190,
        -0.1588938735,
        -0.0918145207,
         0.0167541843,
         0.0379886875,
         0.0000042245,
        -0.0179450374,
         0.0001550306,
         0.0150547463,
         0.0059749734,
        -0.0072655220
    },
    {
        -0.0073977626,    /* Filter 18 */
         0.0015649858,
         0.0146554474,
         0.0062244669,
        -0.0153581346,
        -0.0090844968,
         0.0298748652,
         0.0323985964,
        -0.0582058801,
        -0.1572253195,
        -0.0614142172,
         0.3343742193,
         0.8530595144,
         1.1341005677,
         0.9592263784,
         0.4656202984,
         0.0110436227,
        -0.1593905652,
        -0.0892624310,
         0.0182326825,
         0.0375051901,
        -0.0007798170,
        -0.0178454537,
         0.0006477590,
         0.0150953467,
         0.0056375349,
        -0.0073977626
    },
    {
        -0.0075220352,    /* Filter 19 */
         0.0018996866,
         0.0147549939,
         0.0057917921,
        -0.0156489401,
        -0.0084802176,
         0.0306199657,
         0.0314731241,
        -0.0607845218,
        -0.1579376330,
        -0.0561492367,
         0.3450495257,
         0.8625852570,
         1.1352767227,
         0.9511166107,
         0.4544814848,
         0.0042422023,
        -0.1597764966,
        -0.0866979409,
         0.0196661350,
         0.0369950206,
        -0.0015515318,
        -0.0177281343,
         0.0011376411,
         0.0151237335,
         0.0052987238,
        -0.0075220352
    },
    {
        -0.0076383031,    /* Filter 20 */
         0.0022361711,
         0.0148435662,
         0.0053520969,
        -0.0159258012,
        -0.0078586421,
         0.0313482235,
         0.0305011692,
        -0.0633706649,
        -0.1585597055,
        -0.0507423709,
         0.3557831160,
         0.8719986504,
         1.1362396407,
         0.9428623482,
         0.4433681204,
        -0.0024227381,
        -0.1600533878,
        -0.0841229830,
         0.0210542334,
         0.0364590439,
        -0.0023103774,
        -0.0175933690,
         0.0016242604,
         0.0151399716,
         0.0049588376,
        -0.0076383031
    },
    {
        -0.0077465371,    /* Filter 21 */
         0.0025741665,
         0.0149210065,
         0.0049057203,
        -0.0161883245,
        -0.0072201291,
         0.0320587270,
         0.0294826899,
        -0.0659626349,
        -0.1590895446,
        -0.0451938654,
         0.3665718769,
         0.8812963074,
         1.1369889562,
         0.9344666146,
         0.4322836427,
        -0.0089503609,
        -0.1602229915,
        -0.0815394677,
         0.0223967058,
         0.0358981326,
        -0.0030558287,
        -0.0174414598,
         0.0021072073,
         0.0151441363,
         0.0046181723,
        -0.0077465371
    },
    {
        -0.0078467154,    /* Filter 22 */
         0.0029133963,
         0.0149871656,
         0.0044530098,
        -0.0164361249,
        -0.0065650562,
         0.0327505660,
         0.0284176775,
        -0.0685587283,
        -0.1595251795,
        -0.0395040305,
         0.3774126540,
         0.8904748751,
         1.1375243848,
         0.9259324800,
         0.4212314588,
        -0.0153398946,
        -0.1602870918,
        -0.0789492822,
         0.0236933163,
         0.0353131667,
        -0.0037873786,
        -0.0172727204,
         0.0025860790,
         0.0151363124,
         0.0042770226,
        -0.0078467154
    },
    {
        -0.0079388232,    /* Filter 23 */
         0.0032535809,
         0.0150419030,
         0.0039943217,
        -0.0166688264,
        -0.0058938201,
         0.0334228328,
         0.0273061573,
        -0.0711572128,
        -0.1598646624,
        -0.0336732419,
         0.3883022526,
         0.8995310364,
         1.1378457233,
         0.9172630595,
         0.4102149439,
        -0.0215906342,
        -0.1602475034,
        -0.0763542897,
         0.0249438653,
         0.0347050324,
        -0.0045045381,
        -0.0170874759,
         0.0030604795,
         0.0151165945,
         0.0039356808,
        -0.0079388232
    },
    {
        -0.0080228532,    /* Filter 24 */
         0.0035944376,
         0.0150850869,
         0.0035300207,
        -0.0168860623,
        -0.0052068361,
         0.0340746221,
         0.0261481886,
        -0.0737563289,
        -0.1601060697,
        -0.0277019409,
         0.3992374395,
         0.9084615115,
         1.1379528497,
         0.9084615115,
         0.3992374395,
        -0.0277019409,
        -0.1601060697,
        -0.0737563289,
         0.0261481886,
         0.0340746221,
        -0.0052068361,
        -0.0168860623,
         0.0035300207,
         0.0150850869,
         0.0035944376,
        -0.0080228532
    },
    {
        -0.0080988052,    /* Filter 25 */
         0.0039356808,
         0.0151165945,
         0.0030604795,
        -0.0170874759,
        -0.0045045381,
         0.0347050324,
         0.0249438653,
        -0.0763542897,
        -0.1602475034,
        -0.0215906342,
         0.4102149439,
         0.9172630595,
         1.1378457233,
         0.8995310364,
         0.3883022526,
        -0.0336732419,
        -0.1598646624,
        -0.0711572128,
         0.0273061573,
         0.0334228328,
        -0.0058938201,
        -0.0166688264,
         0.0039943217,
         0.0150419030,
         0.0032535809,
        -0.0080988052
    },
    {
        -0.0081666861,    /* Filter 26 */
         0.0042770226,
         0.0151363124,
         0.0025860790,
        -0.0172727204,
        -0.0037873786,
         0.0353131667,
         0.0236933163,
        -0.0789492822,
        -0.1602870918,
        -0.0153398946,
         0.4212314588,
         0.9259324800,
         1.1375243848,
         0.8904748751,
         0.3774126540,
        -0.0395040305,
        -0.1595251795,
        -0.0685587283,
         0.0284176775,
         0.0327505660,
        -0.0065650562,
        -0.0164361249,
         0.0044530098,
         0.0149871656,
         0.0029133963,
        -0.0081666861
    },
    {
        -0.0082265098,    /* Filter 27 */
         0.0046181723,
         0.0151441363,
         0.0021072073,
        -0.0174414598,
        -0.0030558287,
         0.0358981326,
         0.0223967058,
        -0.0815394677,
        -0.1602229915,
        -0.0089503609,
         0.4322836427,
         0.9344666146,
         1.1369889562,
         0.8812963074,
         0.3665718769,
        -0.0451938654,
        -0.1590895446,
        -0.0659626349,
         0.0294826899,
         0.0320587270,
        -0.0072201291,
        -0.0161883245,
         0.0049057203,
         0.0149210065,
         0.0025741665,
        -0.0082265098
    },
    {
        -0.0082782975,    /* Filter 28 */
         0.0049588376,
         0.0151399716,
         0.0016242604,
        -0.0175933690,
        -0.0023103774,
         0.0364590439,
         0.0210542334,
        -0.0841229830,
        -0.1600533878,
        -0.0024227381,
         0.4433681204,
         0.9428623482,
         1.1362396407,
         0.8719986504,
         0.3557831160,
        -0.0507423709,
        -0.1585597055,
        -0.0633706649,
         0.0305011692,
         0.0313482235,
        -0.0078586421,
        -0.0159258012,
         0.0053520969,
         0.0148435662,
         0.0022361711,
        -0.0082782975
    },
    {
        -0.0083220771,    /* Filter 29 */
         0.0052987238,
         0.0151237335,
         0.0011376411,
        -0.0177281343,
        -0.0015515318,
         0.0369950206,
         0.0196661350,
        -0.0866979409,
        -0.1597764966,
         0.0042422023,
         0.4544814848,
         0.9511166107,
         1.1352767227,
         0.8625852570,
         0.3450495257,
        -0.0561492367,
        -0.1579376330,
        -0.0607845218,
         0.0314731241,
         0.0306199657,
        -0.0084802176,
        -0.0156489401,
         0.0057917921,
         0.0147549939,
         0.0018996866,
        -0.0083220771
    },
    {
        -0.0083578834,    /* Filter 30 */
         0.0056375349,
         0.0150953467,
         0.0006477590,
        -0.0178454537,
        -0.0007798170,
         0.0375051901,
         0.0182326825,
        -0.0892624310,
        -0.1593905652,
         0.0110436227,
         0.4656202984,
         0.9592263784,
         1.1341005677,
         0.8530595144,
         0.3343742193,
        -0.0614142172,
        -0.1572253195,
        -0.0582058801,
         0.0323985964,
         0.0298748652,
        -0.0090844968,
        -0.0153581346,
         0.0062244669,
         0.0146554474,
         0.0015649858,
        -0.0083578834
    },
    {
        -0.0083857580,    /* Filter 31 */
         0.0059749734,
         0.0150547463,
         0.0001550306,
        -0.0179450374,
         0.0000042245,
         0.0379886875,
         0.0167541843,
        -0.0918145207,
        -0.1588938735,
         0.0179806190,
         0.4767810943,
         0.9671886754,
         1.1327116219,
         0.8434248424,
         0.3237602674,
        -0.0665371312,
        -0.1564247779,
        -0.0556363845,
         0.0332776610,
         0.0291138344,
        -0.0096711403,
        -0.0150537867,
         0.0066497916,
         0.0145450926,
         0.0012323380,
        -0.0083857580
    },
    {
        -0.0084057493,    /* Filter 32 */
         0.0063107407,
         0.0150018773,
        -0.0003401218,
        -0.0180266078,
         0.0008000327,
         0.0384446569,
         0.0152309858,
        -0.0943522562,
        -0.1582847354,
         0.0250522204,
         0.4879603781,
         0.9750005749,
         1.1311104123,
         0.8336846919,
         0.3132106970,
        -0.0715178621,
        -0.1555380404,
        -0.0530776494,
         0.0341104250,
         0.0283377856,
        -0.0102398272,
        -0.0147363057,
         0.0070674458,
         0.0144241033,
         0.0009020085,
        -0.0084057493
    },
    {
        -0.0084179123,    /* Filter 33 */
         0.0066445373,
         0.0149366950,
        -0.0008372696,
        -0.0180899006,
         0.0016070303,
         0.0388722515,
         0.0136634691,
        -0.0968736629,
        -0.1575614998,
         0.0322573902,
         0.4991546291,
         0.9826592009,
         1.1292975460,
         0.8238425431,
         0.3027284900,
        -0.0763563569,
        -0.1545671571,
        -0.0505312582,
         0.0348970277,
         0.0275476309,
        -0.0107902564,
        -0.0144061086,
         0.0074771184,
         0.0142926615,
         0.0005742587,
        -0.0084179123
    },
    {
        -0.0084223083,    /* Filter 34 */
         0.0069760629,
         0.0148591651,
        -0.0013359786,
        -0.0181346643,
         0.0024246234,
         0.0392706350,
         0.0120520536,
        -0.0993767470,
        -0.1567225517,
         0.0395950250,
         0.5103603020,
         0.9901617293,
         1.1272737104,
         0.8139019043,
         0.2923165823,
        -0.0810526259,
        -0.1535141950,
        -0.0479987626,
         0.0356376397,
         0.0267442806,
        -0.0113221454,
        -0.0140636189,
         0.0078785078,
         0.0141509564,
         0.0002493454,
        -0.0084223083
    },
    {
        -0.0084190052,    /* Filter 35 */
         0.0073050171,
         0.0147692639,
        -0.0018358095,
        -0.0181606611,
         0.0032522013,
         0.0396389819,
         0.0103971963,
        -0.1018594956,
        -0.1557663137,
         0.0470639554,
         0.5215738282,
         0.9975053893,
         1.1250396727,
         0.8038663095,
         0.2819778628,
        -0.0856067424,
        -0.1523812363,
        -0.0454816823,
         0.0363324626,
         0.0259286435,
        -0.0118352313,
        -0.0137092670,
         0.0082713225,
         0.0139991847,
        -0.0000724789,
        -0.0084190052
    },
    {
        -0.0084080772,    /* Filter 36 */
         0.0076310991,
         0.0146669781,
        -0.0023363179,
        -0.0181676672,
         0.0040891370,
         0.0399764783,
         0.0086993916,
        -0.1043198784,
        -0.1546912466,
         0.0546629459,
         0.5327916175,
         1.0046874648,
         1.1225962793,
         0.7937393177,
         0.2717151717,
        -0.0900188421,
        -0.1511703778,
        -0.0429815045,
         0.0369817283,
         0.0251016255,
        -0.0123292702,
        -0.0133434892,
         0.0086552808,
         0.0138375505,
        -0.0003909662,
        -0.0084080772
    },
    {
        -0.0083896047,    /* Filter 37 */
         0.0079540084,
         0.0145523054,
        -0.0028370545,
        -0.0181554728,
         0.0049347874,
         0.0402823226,
         0.0069591716,
        -0.1067558483,
        -0.1534958509,
         0.0623906951,
         0.5440100595,
         1.0117052957,
         1.1199444556,
         0.7835245105,
         0.2615313001,
        -0.0942891228,
        -0.1498837288,
        -0.0404996829,
         0.0375856989,
         0.0242641295,
        -0.0128040373,
        -0.0129667273,
         0.0090301109,
         0.0136662644,
        -0.0007058736,
        -0.0083896047
    },
    {
        -0.0083636741,    /* Filter 38 */
         0.0082734449,
         0.0144252539,
        -0.0033375660,
        -0.0181238828,
         0.0057884938,
         0.0405557266,
         0.0051771063,
        -0.1091653424,
        -0.1521786680,
         0.0702458358,
         0.5552255254,
         1.0185562789,
         1.1170852055,
         0.7732254908,
         0.2514289886,
        -0.0984178433,
        -0.1485234109,
        -0.0380376377,
         0.0381446654,
         0.0234170544,
        -0.0132593270,
        -0.0125794285,
         0.0093955517,
         0.0134855441,
        -0.0010169632,
        -0.0083636741
    },
    {
        -0.0083303778,    /* Filter 39 */
         0.0085891090,
         0.0142858431,
        -0.0038373950,
        -0.0180727168,
         0.0066495821,
         0.0407959159,
         0.0033538037,
        -0.1115462830,
        -0.1507382808,
         0.0782269355,
         0.5664343693,
         1.0252378699,
         1.1140196110,
         0.7628458810,
         0.2414109265,
        -0.1024053236,
        -0.1470915558,
        -0.0355967552,
         0.0386589480,
         0.0225612946,
        -0.0136949529,
        -0.0121820448,
         0.0097513521,
         0.0132956134,
        -0.0013240021,
        -0.0083303778
    },
    {
        -0.0082898140,    /* Filter 40 */
         0.0089007023,
         0.0141341030,
        -0.0043360803,
        -0.0180018097,
         0.0075173632,
         0.0410021305,
         0.0014899097,
        -0.1138965787,
        -0.1491733154,
         0.0863324965,
         0.5776329299,
         1.0317475841,
         1.1107488316,
         0.7523893215,
         0.2314797506,
        -0.1062519435,
        -0.1455903047,
        -0.0331783869,
         0.0391288948,
         0.0216977392,
        -0.0141107475,
        -0.0117750324,
         0.0100972717,
         0.0130967024,
        -0.0016267630,
        -0.0082898140
    },
    {
        -0.0082420866,    /* Filter 41 */
         0.0092079274,
         0.0139700749,
        -0.0048331579,
        -0.0179110118,
         0.0083911333,
         0.0411736260,
        -0.0004138916,
        -0.1162141254,
        -0.1474824414,
         0.0945609563,
         0.5888175322,
         1.0380829975,
         1.1072741035,
         0.7418594687,
         0.2216380443,
        -0.1099581426,
        -0.1440218066,
        -0.0307838494,
         0.0395548815,
         0.0208272719,
        -0.0145065623,
        -0.0113588515,
         0.0104330806,
         0.0128890474,
        -0.0019250239,
        -0.0082420866
    },
    {
        -0.0081873051,    /* Filter 42 */
         0.0095104884,
         0.0137938111,
        -0.0053281603,
        -0.0178001892,
         0.0092701743,
         0.0413096740,
        -0.0023568781,
        -0.1184968073,
        -0.1456643740,
         0.1029106879,
         0.5999844889,
         1.0442417482,
         1.1035967397,
         0.7312599938,
         0.2118883368,
        -0.1135244193,
        -0.1423882175,
        -0.0284144241,
         0.0399373110,
         0.0199507698,
        -0.0148822675,
        -0.0109339660,
         0.0107585598,
         0.0126728899,
        -0.0022185685,
        -0.0081873051
    },
    {
        -0.0081255844,    /* Filter 43 */
         0.0098080911,
         0.0136053750,
        -0.0058206179,
        -0.0176692240,
         0.0101537543,
         0.0414095629,
        -0.0043382895,
        -0.1207424980,
        -0.1437178738,
         0.1113800000,
         0.6111301022,
         1.0502215375,
         1.0997181284,
         0.7205945806,
         0.2022331022,
        -0.1169513302,
        -0.1406916989,
        -0.0260713566,
         0.0402766124,
         0.0190691031,
        -0.0152377524,
        -0.0105008428,
         0.0110735009,
         0.0124484774,
        -0.0025071863,
        -0.0081255844
    },
    {
        -0.0080570447,    /* Filter 44 */
         0.0101004434,
         0.0134048412,
        -0.0063100588,
        -0.0175180145,
         0.0110411278,
         0.0414725987,
        -0.0063573274,
        -0.1229490616,
        -0.1416417489,
         0.1199671379,
         0.6222506654,
         1.0560201310,
         1.0956397332,
         0.7098669242,
         0.1926747584,
        -0.1202394894,
        -0.1389344167,
        -0.0237558566,
         0.0405732405,
         0.0181831345,
        -0.0155729245,
        -0.0100599512,
         0.0113777066,
         0.0122160622,
        -0.0027906730,
        -0.0080570447
    },
    {
        -0.0079818115,    /* Filter 45 */
         0.0103872554,
         0.0131922955,
        -0.0067960093,
        -0.0173464758,
         0.0119315364,
         0.0414981056,
        -0.0084131553,
        -0.1251143537,
        -0.1394348551,
         0.1286702834,
         0.6333424645,
         1.0616353597,
         1.0913630919,
         0.6990807290,
         0.1832156667,
        -0.1233895677,
        -0.1371185400,
        -0.0214690972,
         0.0408276754,
         0.0172937187,
        -0.0158877103,
        -0.0096117632,
         0.0116709905,
         0.0119759017,
        -0.0030688299,
        -0.0079818115
    },
    {
        -0.0079000149,    /* Filter 46 */
         0.0106682397,
         0.0129678349,
        -0.0072779944,
        -0.0171545394,
         0.0128242090,
         0.0414854268,
        -0.0105048989,
        -0.1272362227,
        -0.1370960973,
         0.1374875558,
         0.6444017799,
         1.0670651207,
         1.0868898157,
         0.6882397074,
         0.1738581306,
        -0.1264022918,
        -0.1352462396,
        -0.0192122152,
         0.0410404216,
         0.0164017016,
        -0.0161820543,
        -0.0091567523,
         0.0119531772,
         0.0117282579,
        -0.0033414650,
        -0.0079000149
    },
    {
        -0.0078117902,    /* Filter 47 */
         0.0109431119,
         0.0127315677,
        -0.0077555379,
        -0.0169421543,
         0.0137183623,
         0.0414339250,
        -0.0126316456,
        -0.1293125105,
        -0.1346244304,
         0.1464170119,
         0.6554248879,
         1.0723073790,
         1.0822215889,
         0.6773475777,
         0.1646043954,
        -0.1292784439,
        -0.1333196873,
        -0.0169863104,
         0.0412120072,
         0.0155079202,
        -0.0164559194,
        -0.0086953937,
         0.0122241026,
         0.0114733973,
        -0.0036083922,
        -0.0078117902
    },
};
#else
static const float pulseshaper[192][V17RX_FILTER_STEPS] =
{
    {
        -0.0077172773,      /* Filter 0 */
        -0.0038694321,
         0.0112115904,
         0.0124836134,
        -0.0082281633,
        -0.0167092864,
         0.0146132015,
         0.0413429837,
        -0.0147924454,
        -0.1313410544,
        -0.1320188601,
         0.1554566471,
         0.6664080627,
         1.0773601675,
         1.0773601675,
         0.6664080627,
         0.1554566471,
        -0.1320188601,
        -0.1313410544,
        -0.0147924454,
         0.0413429837,
         0.0146132015,
        -0.0167092864,
        -0.0082281633,
         0.0124836134,
         0.0112115904,
        -0.0038694321,
    },
    {
        -0.0068190610,      /* Filter 1 */
        -0.0038041721,
         0.0112770421,
         0.0124187357,
        -0.0083449709,
        -0.0166459447,
         0.0148368812,
         0.0413102396,
        -0.0153409117,
        -0.1318357126,
        -0.1313337561,
         0.1577435842,
         0.6691429414,
         1.0785755229,
         1.0760969704,
         0.6636622690,
         0.1531967383,
        -0.1326702527,
        -0.1308339184,
        -0.0142522454,
         0.0413657190,
         0.0143894917,
        -0.0167675034,
        -0.0081100070,
         0.0125456020,
         0.0111444708,
        -0.0039331771,
    },
    {
        -0.0059208446,      /* Filter 2 */
        -0.0037389121,
         0.0113424938,
         0.0123538580,
        -0.0084617785,
        -0.0165826029,
         0.0150605609,
         0.0412774954,
        -0.0158893779,
        -0.1323303708,
        -0.1306486520,
         0.1600305213,
         0.6718778202,
         1.0797908782,
         1.0748337732,
         0.6609164753,
         0.1509368295,
        -0.1333216453,
        -0.1303267825,
        -0.0137120455,
         0.0413884544,
         0.0141657819,
        -0.0168257204,
        -0.0079918506,
         0.0126075905,
         0.0110773512,
        -0.0039969220,
    },
    {
        -0.0050226282,      /* Filter 3 */
        -0.0036736522,
         0.0114079456,
         0.0122889803,
        -0.0085785861,
        -0.0165192611,
         0.0152842405,
         0.0412447513,
        -0.0164378441,
        -0.1328250291,
        -0.1299635480,
         0.1623174583,
         0.6746126989,
         1.0810062335,
         1.0735705761,
         0.6581706816,
         0.1486769207,
        -0.1339730378,
        -0.1298196465,
        -0.0131718456,
         0.0414111897,
         0.0139420721,
        -0.0168839373,
        -0.0078736943,
         0.0126695791,
         0.0110102315,
        -0.0040606669,
    },
    {
        -0.0041244119,      /* Filter 4 */
        -0.0036083922,
         0.0114733973,
         0.0122241026,
        -0.0086953937,
        -0.0164559194,
         0.0155079202,
         0.0412120072,
        -0.0169863104,
        -0.1333196873,
        -0.1292784439,
         0.1646043954,
         0.6773475777,
         1.0822215889,
         1.0723073790,
         0.6554248879,
         0.1464170119,
        -0.1346244304,
        -0.1293125105,
        -0.0126316456,
         0.0414339250,
         0.0137183623,
        -0.0169421543,
        -0.0077555379,
         0.0127315677,
         0.0109431119,
        -0.0041244119,
    },
    {
        -0.0041866002,      /* Filter 5 */
        -0.0035416604,
         0.0115371125,
         0.0121563712,
        -0.0088107333,
        -0.0163874531,
         0.0157313656,
         0.0411691108,
        -0.0175427866,
        -0.1338013254,
        -0.1285594059,
         0.1669178292,
         0.6800706101,
         1.0833886456,
         1.0709968144,
         0.6526691109,
         0.1441846479,
        -0.1352423471,
        -0.1287934386,
        -0.0120999589,
         0.0414468005,
         0.0134948240,
        -0.0169952506,
        -0.0076361520,
         0.0127906345,
         0.0108743939,
        -0.0041866002,
    },
    {
        -0.0042487886,      /* Filter 6 */
        -0.0034749286,
         0.0116008276,
         0.0120886399,
        -0.0089260730,
        -0.0163189869,
         0.0159548109,
         0.0411262144,
        -0.0180992628,
        -0.1342829635,
        -0.1278403679,
         0.1692312630,
         0.6827936425,
         1.0845557023,
         1.0696862498,
         0.6499133339,
         0.1419522838,
        -0.1358602638,
        -0.1282743666,
        -0.0115682723,
         0.0414596759,
         0.0132712856,
        -0.0170483468,
        -0.0075167661,
         0.0128497013,
         0.0108056758,
        -0.0042487886,
    },
    {
        -0.0043109769,      /* Filter 7 */
        -0.0034081968,
         0.0116645427,
         0.0120209086,
        -0.0090414127,
        -0.0162505206,
         0.0161782562,
         0.0410833180,
        -0.0186557390,
        -0.1347646015,
        -0.1271213298,
         0.1715446968,
         0.6855166750,
         1.0857227590,
         1.0683756853,
         0.6471575569,
         0.1397199198,
        -0.1364781806,
        -0.1277552947,
        -0.0110365856,
         0.0414725514,
         0.0130477473,
        -0.0171014431,
        -0.0073973803,
         0.0129087681,
         0.0107369577,
        -0.0043109769,
    },
    {
        -0.0043731652,      /* Filter 8 */
        -0.0033414650,
         0.0117282579,
         0.0119531772,
        -0.0091567523,
        -0.0161820543,
         0.0164017016,
         0.0410404216,
        -0.0192122152,
        -0.1352462396,
        -0.1264022918,
         0.1738581306,
         0.6882397074,
         1.0868898157,
         1.0670651207,
         0.6444017799,
         0.1374875558,
        -0.1370960973,
        -0.1272362227,
        -0.0105048989,
         0.0414854268,
         0.0128242090,
        -0.0171545394,
        -0.0072779944,
         0.0129678349,
         0.0106682397,
        -0.0043731652,
    },
    {
        -0.0044337570,      /* Filter 9 */
        -0.0032733062,
         0.0117901689,
         0.0118826305,
        -0.0092705050,
        -0.0161084683,
         0.0166247059,
         0.0409872351,
        -0.0197764357,
        -0.1357143147,
        -0.1256491108,
         0.1761975146,
         0.6909499628,
         1.0880081347,
         1.0657076804,
         0.6416369510,
         0.1352832377,
        -0.1376807868,
        -0.1267057555,
        -0.0099819630,
         0.0414885965,
         0.0126010409,
        -0.0172025235,
        -0.0071574981,
         0.0130239501,
         0.0105979936,
        -0.0044337570,
    },
    {
        -0.0044943488,          /* Filter 10 */
        -0.0032051475,
         0.0118520798,
         0.0118120839,
        -0.0093842577,
        -0.0160348823,
         0.0168477102,
         0.0409340485,
        -0.0203406562,
        -0.1361823898,
        -0.1248959297,
         0.1785368986,
         0.6936602182,
         1.0891264538,
         1.0643502402,
         0.6388721222,
         0.1330789196,
        -0.1382654762,
        -0.1261752882,
        -0.0094590271,
         0.0414917662,
         0.0123778727,
        -0.0172505076,
        -0.0070370019,
         0.0130800652,
         0.0105277476,
        -0.0044943488,
    },
    {
        -0.0045549407,          /* Filter 11 */
        -0.0031369887,
         0.0119139907,
         0.0117415372,
        -0.0094980105,
        -0.0159612963,
         0.0170707144,
         0.0408808619,
        -0.0209048767,
        -0.1366504649,
        -0.1241427487,
         0.1808762827,
         0.6963704736,
         1.0902447728,
         1.0629927999,
         0.6361072934,
         0.1308746015,
        -0.1388501656,
        -0.1256448209,
        -0.0089360912,
         0.0414949359,
         0.0121547045,
        -0.0172984917,
        -0.0069165056,
         0.0131361803,
         0.0104575015,
        -0.0045549407,
    },
    {
        -0.0046155325,          /* Filter 12 */
        -0.0030688299,
         0.0119759017,
         0.0116709905,
        -0.0096117632,
        -0.0158877103,
         0.0172937187,
         0.0408276754,
        -0.0214690972,
        -0.1371185400,
        -0.1233895677,
         0.1832156667,
         0.6990807290,
         1.0913630919,
         1.0616353597,
         0.6333424645,
         0.1286702834,
        -0.1394348551,
        -0.1251143537,
        -0.0084131553,
         0.0414981056,
         0.0119315364,
        -0.0173464758,
        -0.0067960093,
         0.0131922955,
         0.0103872554,
        -0.0046155325,
    },
    {
        -0.0046744897,          /* Filter 13 */
        -0.0029992907,
         0.0120359418,
         0.0115976695,
        -0.0097238102,
        -0.0158090139,
         0.0175160726,
         0.0407640667,
        -0.0220407870,
        -0.1375725092,
        -0.1226020481,
         0.1855804396,
         0.7017772778,
         1.0924322522,
         1.0602315525,
         0.6305695147,
         0.1264944970,
        -0.1399865786,
        -0.1245730307,
        -0.0078991983,
         0.0414917289,
         0.0117089343,
        -0.0173893605,
        -0.0066745217,
         0.0132454319,
         0.0103155524,
        -0.0046744897,
    },
    {
        -0.0047334468,          /* Filter 14 */
        -0.0029297514,
         0.0120959820,
         0.0115243486,
        -0.0098358572,
        -0.0157303174,
         0.0177384266,
         0.0407004580,
        -0.0226124769,
        -0.1380264784,
        -0.1218145285,
         0.1879452126,
         0.7044738266,
         1.0935014125,
         1.0588277453,
         0.6277965649,
         0.1243187106,
        -0.1405383020,
        -0.1240317076,
        -0.0073852414,
         0.0414853522,
         0.0114863321,
        -0.0174322452,
        -0.0065530340,
         0.0132985683,
         0.0102438494,
        -0.0047334468,
    },
    {
        -0.0047924040,          /* Filter 15 */
        -0.0028602122,
         0.0121560221,
         0.0114510276,
        -0.0099479042,
        -0.0156516210,
         0.0179607805,
         0.0406368492,
        -0.0231841667,
        -0.1384804475,
        -0.1210270090,
         0.1903099855,
         0.7071703754,
         1.0945705729,
         1.0574239382,
         0.6250236152,
         0.1221429243,
        -0.1410900254,
        -0.1234903846,
        -0.0068712844,
         0.0414789754,
         0.0112637299,
        -0.0174751298,
        -0.0064315464,
         0.0133517048,
         0.0101721464,
        -0.0047924040,
    },
    {
        -0.0048513612,          /* Filter 16 */
        -0.0027906730,
         0.0122160622,
         0.0113777066,
        -0.0100599512,
        -0.0155729245,
         0.0181831345,
         0.0405732405,
        -0.0237558566,
        -0.1389344167,
        -0.1202394894,
         0.1926747584,
         0.7098669242,
         1.0956397332,
         1.0560201310,
         0.6222506654,
         0.1199671379,
        -0.1416417489,
        -0.1229490616,
        -0.0063573274,
         0.0414725987,
         0.0110411278,
        -0.0175180145,
        -0.0063100588,
         0.0134048412,
         0.0101004434,
        -0.0048513612,
    },
    {
        -0.0049086473,          /* Filter 17 */
        -0.0027198013,
         0.0122741660,
         0.0113016552,
        -0.0101701741,
        -0.0154891315,
         0.0184046266,
         0.0404990835,
        -0.0243347316,
        -0.1393737373,
        -0.1194174496,
         0.1950643444,
         0.7125488383,
         1.0966593320,
         1.0545704826,
         0.6194705246,
         0.1178203534,
        -0.1421607801,
        -0.1223974207,
        -0.0058525679,
         0.0414568398,
         0.0108192844,
        -0.0175558169,
        -0.0061876986,
         0.0134549746,
         0.0100273553,
        -0.0049086473,
    },
    {
        -0.0049659333,          /* Filter 18 */
        -0.0026489296,
         0.0123322698,
         0.0112256038,
        -0.0102803970,
        -0.0154053385,
         0.0186261188,
         0.0404249265,
        -0.0249136066,
        -0.1398130578,
        -0.1185954098,
         0.1974539303,
         0.7152307524,
         1.0976789308,
         1.0531208343,
         0.6166903838,
         0.1156735689,
        -0.1426798114,
        -0.1218457798,
        -0.0053478084,
         0.0414410808,
         0.0105974410,
        -0.0175936193,
        -0.0060653383,
         0.0135051081,
         0.0099542672,
        -0.0049659333,
    },
    {
        -0.0050232194,          /* Filter 19 */
        -0.0025780580,
         0.0123903736,
         0.0111495523,
        -0.0103906199,
        -0.0153215454,
         0.0188476109,
         0.0403507694,
        -0.0254924816,
        -0.1402523783,
        -0.1177733700,
         0.1998435162,
         0.7179126665,
         1.0986985296,
         1.0516711859,
         0.6139102430,
         0.1135267845,
        -0.1431988426,
        -0.1212941389,
        -0.0048430490,
         0.0414253219,
         0.0103755977,
        -0.0176314216,
        -0.0059429781,
         0.0135552415,
         0.0098811792,
        -0.0050232194,
    },
    {
        -0.0050805055,          /* Filter 20 */
        -0.0025071863,
         0.0124484774,
         0.0110735009,
        -0.0105008428,
        -0.0152377524,
         0.0190691031,
         0.0402766124,
        -0.0260713566,
        -0.1406916989,
        -0.1169513302,
         0.2022331022,
         0.7205945806,
         1.0997181284,
         1.0502215375,
         0.6111301022,
         0.1113800000,
        -0.1437178738,
        -0.1207424980,
        -0.0043382895,
         0.0414095629,
         0.0101537543,
        -0.0176692240,
        -0.0058206179,
         0.0136053750,
         0.0098080911,
        -0.0050805055,
    },
    {
        -0.0051360858,          /* Filter 21 */
        -0.0024350318,
         0.0125045805,
         0.0109947656,
        -0.0106091236,
        -0.0151488812,
         0.0192895198,
         0.0401917871,
        -0.0266571235,
        -0.1411158285,
        -0.1160946025,
         0.2046469108,
         0.7232609339,
         1.1006877812,
         1.0487265902,
         0.6083436989,
         0.1092626720,
        -0.1442044989,
        -0.1201810753,
        -0.0038429366,
         0.0413845907,
         0.0099328593,
        -0.0177019653,
        -0.0056975035,
         0.0136524840,
         0.0097336904,
        -0.0051360858,
    },
    {
        -0.0051916661,          /* Filter 22 */
        -0.0023628774,
         0.0125606836,
         0.0109160303,
        -0.0107174044,
        -0.0150600100,
         0.0195099365,
         0.0401069617,
        -0.0272428903,
        -0.1415399582,
        -0.1152378747,
         0.2070607195,
         0.7259272872,
         1.1016574340,
         1.0472316428,
         0.6055572955,
         0.1071453439,
        -0.1446911239,
        -0.1196196527,
        -0.0033475838,
         0.0413596184,
         0.0097119643,
        -0.0177347066,
        -0.0055743891,
         0.0136995931,
         0.0096592897,
        -0.0051916661,
    },
    {
        -0.0052472464,          /* Filter 23 */
        -0.0022907229,
         0.0126167868,
         0.0108372951,
        -0.0108256852,
        -0.0149711387,
         0.0197303531,
         0.0400221364,
        -0.0278286572,
        -0.1419640879,
        -0.1143811470,
         0.2094745282,
         0.7285936405,
         1.1026270869,
         1.0457366955,
         0.6027708922,
         0.1050280159,
        -0.1451777490,
        -0.1190582300,
        -0.0028522309,
         0.0413346462,
         0.0094910693,
        -0.0177674479,
        -0.0054512747,
         0.0137467021,
         0.0095848891,
        -0.0052472464,
    },
    {
        -0.0053028267,          /* Filter 24 */
        -0.0022185685,
         0.0126728899,
         0.0107585598,
        -0.0109339660,
        -0.0148822675,
         0.0199507698,
         0.0399373110,
        -0.0284144241,
        -0.1423882175,
        -0.1135244193,
         0.2118883368,
         0.7312599938,
         1.1035967397,
         1.0442417482,
         0.5999844889,
         0.1029106879,
        -0.1456643740,
        -0.1184968073,
        -0.0023568781,
         0.0413096740,
         0.0092701743,
        -0.0178001892,
        -0.0053281603,
         0.0137938111,
         0.0095104884,
        -0.0053028267,
    },
    {
        -0.0053566683,          /* Filter 25 */
        -0.0021451824,
         0.0127269293,
         0.0106771900,
        -0.0110401874,
        -0.0147883412,
         0.0201698953,
         0.0398417036,
        -0.0290067804,
        -0.1427966148,
        -0.1126328501,
         0.2143257637,
         0.7339098625,
         1.1045160806,
         1.0427020605,
         0.5971927497,
         0.1008232550,
        -0.1461188909,
        -0.1179261368,
        -0.0018711315,
         0.0412756620,
         0.0090504141,
        -0.0178278949,
        -0.0052044097,
         0.0138378770,
         0.0094348481,
        -0.0053566683,
    },
    {
        -0.0054105099,          /* Filter 26 */
        -0.0020717962,
         0.0127809687,
         0.0105958202,
        -0.0111464087,
        -0.0146944149,
         0.0203890209,
         0.0397460963,
        -0.0295991367,
        -0.1432050120,
        -0.1117412809,
         0.2167631905,
         0.7365597312,
         1.1054354216,
         1.0411623729,
         0.5944010105,
         0.0987358221,
        -0.1465734077,
        -0.1173554664,
        -0.0013853848,
         0.0412416500,
         0.0088306538,
        -0.0178556005,
        -0.0050806591,
         0.0138819430,
         0.0093592079,
        -0.0054105099,
    },
    {
        -0.0054643514,          /* Filter 27 */
        -0.0019984100,
         0.0128350080,
         0.0105144504,
        -0.0112526301,
        -0.0146004886,
         0.0206081464,
         0.0396504889,
        -0.0301914931,
        -0.1436134093,
        -0.1108497118,
         0.2192006174,
         0.7392096000,
         1.1063547626,
         1.0396226852,
         0.5916092714,
         0.0966483892,
        -0.1470279245,
        -0.1167847959,
        -0.0008996382,
         0.0412076380,
         0.0086108936,
        -0.0178833062,
        -0.0049569085,
         0.0139260090,
         0.0092835676,
        -0.0054643514,
    },
    {
        -0.0055181930,          /* Filter 28 */
        -0.0019250239,
         0.0128890474,
         0.0104330806,
        -0.0113588515,
        -0.0145065623,
         0.0208272719,
         0.0395548815,
        -0.0307838494,
        -0.1440218066,
        -0.1099581426,
         0.2216380443,
         0.7418594687,
         1.1072741035,
         1.0380829975,
         0.5888175322,
         0.0945609563,
        -0.1474824414,
        -0.1162141254,
        -0.0004138916,
         0.0411736260,
         0.0083911333,
        -0.0179110118,
        -0.0048331579,
         0.0139700749,
         0.0092079274,
        -0.0055181930,
    },
    {
        -0.0055702647,          /* Filter 29 */
        -0.0018504587,
         0.0129409612,
         0.0103491284,
        -0.0114628967,
        -0.0144076086,
         0.0210448887,
         0.0394483848,
        -0.0313824838,
        -0.1444139311,
        -0.1090315928,
         0.2240984709,
         0.7444919319,
         1.1081427855,
         1.0364991441,
         0.5860213816,
         0.0925038414,
        -0.1479051599,
        -0.1156347387,
         0.0000620587,
         0.0411307521,
         0.0081726908,
        -0.0179337113,
        -0.0047088885,
         0.0140110819,
         0.0091311211,
        -0.0055702647,
    },
    {
        -0.0056223365,          /* Filter 30 */
        -0.0017758935,
         0.0129928749,
         0.0102651761,
        -0.0115669419,
        -0.0143086549,
         0.0212625055,
         0.0393418882,
        -0.0319811182,
        -0.1448060556,
        -0.1081050431,
         0.2265588975,
         0.7471243951,
         1.1090114676,
         1.0349152908,
         0.5832252311,
         0.0904467264,
        -0.1483278784,
        -0.1150553521,
         0.0005380091,
         0.0410878783,
         0.0079542483,
        -0.0179564107,
        -0.0045846191,
         0.0140520889,
         0.0090543149,
        -0.0056223365,
    },
    {
        -0.0056744082,          /* Filter 31 */
        -0.0017013282,
         0.0130447886,
         0.0101812239,
        -0.0116709872,
        -0.0142097012,
         0.0214801224,
         0.0392353915,
        -0.0325797525,
        -0.1451981802,
        -0.1071784933,
         0.2290193240,
         0.7497568583,
         1.1098801496,
         1.0333314375,
         0.5804290805,
         0.0883896114,
        -0.1487505969,
        -0.1144759654,
         0.0010139594,
         0.0410450044,
         0.0077358057,
        -0.0179791102,
        -0.0044603497,
         0.0140930960,
         0.0089775086,
        -0.0056744082,
    },
    {
        -0.0057264799,          /* Filter 32 */
        -0.0016267630,
         0.0130967024,
         0.0100972717,
        -0.0117750324,
        -0.0141107475,
         0.0216977392,
         0.0391288948,
        -0.0331783869,
        -0.1455903047,
        -0.1062519435,
         0.2314797506,
         0.7523893215,
         1.1107488316,
         1.0317475841,
         0.5776329299,
         0.0863324965,
        -0.1491733154,
        -0.1138965787,
         0.0014899097,
         0.0410021305,
         0.0075173632,
        -0.0180018097,
        -0.0043360803,
         0.0141341030,
         0.0089007023,
        -0.0057264799,
    },
    {
        -0.0057767524,          /* Filter 33 */
        -0.0015510728,
         0.0131464301,
         0.0100107918,
        -0.0118767855,
        -0.0140067989,
         0.0219136281,
         0.0390114081,
        -0.0337829790,
        -0.1459656175,
        -0.1052902885,
         0.2339625446,
         0.7550034614,
         1.1115665265,
         1.0301201555,
         0.5748332898,
         0.0843061062,
        -0.1495645568,
        -0.1133090048,
         0.0019558832,
         0.0409505768,
         0.0073004179,
        -0.0180195365,
        -0.0042114090,
         0.0141720380,
         0.0088228040,
        -0.0057767524,
    },
    {
        -0.0058270249,          /* Filter 34 */
        -0.0014753825,
         0.0131961579,
         0.0099243119,
        -0.0119785386,
        -0.0139028502,
         0.0221295169,
         0.0388939214,
        -0.0343875711,
        -0.1463409303,
        -0.1043286335,
         0.2364453385,
         0.7576176012,
         1.1123842213,
         1.0284927270,
         0.5720336496,
         0.0822797160,
        -0.1499557981,
        -0.1127214308,
         0.0024218567,
         0.0408990232,
         0.0070834727,
        -0.0180372632,
        -0.0040867377,
         0.0142099731,
         0.0087449056,
        -0.0058270249,
    },
    {
        -0.0058772974,          /* Filter 35 */
        -0.0013996923,
         0.0132458857,
         0.0098378320,
        -0.0120802917,
        -0.0137989015,
         0.0223454057,
         0.0387764347,
        -0.0349921631,
        -0.1467162430,
        -0.1033669786,
         0.2389281325,
         0.7602317411,
         1.1132019161,
         1.0268652984,
         0.5692340095,
         0.0802533257,
        -0.1503470394,
        -0.1121338569,
         0.0028878302,
         0.0408474696,
         0.0068665274,
        -0.0180549900,
        -0.0039620663,
         0.0142479081,
         0.0086670073,
        -0.0058772974,
    },
    {
        -0.0059275699,          /* Filter 36 */
        -0.0013240021,
         0.0132956134,
         0.0097513521,
        -0.0121820448,
        -0.0136949529,
         0.0225612946,
         0.0386589480,
        -0.0355967552,
        -0.1470915558,
        -0.1024053236,
         0.2414109265,
         0.7628458810,
         1.1140196110,
         1.0252378699,
         0.5664343693,
         0.0782269355,
        -0.1507382808,
        -0.1115462830,
         0.0033538037,
         0.0407959159,
         0.0066495821,
        -0.0180727168,
        -0.0038373950,
         0.0142858431,
         0.0085891090,
        -0.0059275699,
    },
    {
        -0.0059760157,          /* Filter 37 */
        -0.0012472424,
         0.0133430961,
         0.0096624020,
        -0.0122813907,
        -0.0135860464,
         0.0227752346,
         0.0385303773,
        -0.0362069758,
        -0.1474495196,
        -0.1014084535,
         0.2439154420,
         0.7654407834,
         1.1147860096,
         1.0235674721,
         0.5636321583,
         0.0762316606,
        -0.1510983776,
        -0.1109510478,
         0.0038096294,
         0.0407358686,
         0.0064343100,
        -0.0180855083,
        -0.0037124377,
         0.0143206958,
         0.0085101930,
        -0.0059760157,
    },
    {
        -0.0060244614,          /* Filter 38 */
        -0.0011704827,
         0.0133905787,
         0.0095734519,
        -0.0123807366,
        -0.0134771399,
         0.0229891745,
         0.0384018067,
        -0.0368171965,
        -0.1478074833,
        -0.1004115835,
         0.2464199576,
         0.7680356859,
         1.1155524083,
         1.0218970744,
         0.5608299474,
         0.0742363857,
        -0.1514584744,
        -0.1103558127,
         0.0042654550,
         0.0406758213,
         0.0062190379,
        -0.0180982998,
        -0.0035874805,
         0.0143555485,
         0.0084312770,
        -0.0060244614,
    },
    {
        -0.0060729072,          /* Filter 39 */
        -0.0010937229,
         0.0134380614,
         0.0094845018,
        -0.0124800826,
        -0.0133682335,
         0.0232031144,
         0.0382732360,
        -0.0374274171,
        -0.1481654471,
        -0.0994147134,
         0.2489244731,
         0.7706305883,
         1.1163188069,
         1.0202266767,
         0.5580277364,
         0.0722411107,
        -0.1518185712,
        -0.1097605776,
         0.0047212807,
         0.0406157739,
         0.0060037659,
        -0.0181110913,
        -0.0034625233,
         0.0143904012,
         0.0083523609,
        -0.0060729072,
    },
    {
        -0.0061213530,          /* Filter 40 */
        -0.0010169632,
         0.0134855441,
         0.0093955517,
        -0.0125794285,
        -0.0132593270,
         0.0234170544,
         0.0381446654,
        -0.0380376377,
        -0.1485234109,
        -0.0984178433,
         0.2514289886,
         0.7732254908,
         1.1170852055,
         1.0185562789,
         0.5552255254,
         0.0702458358,
        -0.1521786680,
        -0.1091653424,
         0.0051771063,
         0.0405557266,
         0.0057884938,
        -0.0181238828,
        -0.0033375660,
         0.0144252539,
         0.0082734449,
        -0.0061213530,
    },
    {
        -0.0061679463,          /* Filter 41 */
        -0.0009391908,
         0.0135307242,
         0.0093041915,
        -0.0126762532,
        -0.0131455046,
         0.0236288232,
         0.0380049238,
        -0.0386531490,
        -0.1488634904,
        -0.0973856632,
         0.2539545665,
         0.7758002457,
         1.1178000180,
         1.0168435331,
         0.5524216589,
         0.0682820506,
        -0.1525079637,
        -0.1085629689,
         0.0056226226,
         0.0404873756,
         0.0055750672,
        -0.0181317803,
        -0.0032124381,
         0.0144570168,
         0.0081935858,
        -0.0061679463,
    },
    {
        -0.0062145396,          /* Filter 42 */
        -0.0008614184,
         0.0135759042,
         0.0092128313,
        -0.0127730779,
        -0.0130316821,
         0.0238405920,
         0.0378651821,
        -0.0392686603,
        -0.1492035698,
        -0.0963534830,
         0.2564801443,
         0.7783750007,
         1.1185148306,
         1.0151307873,
         0.5496177925,
         0.0663182654,
        -0.1528372594,
        -0.1079605953,
         0.0060681390,
         0.0404190246,
         0.0053616406,
        -0.0181396778,
        -0.0030873103,
         0.0144887797,
         0.0081137266,
        -0.0062145396,
    },
    {
        -0.0062611330,          /* Filter 43 */
        -0.0007836460,
         0.0136210843,
         0.0091214711,
        -0.0128699026,
        -0.0129178597,
         0.0240523607,
         0.0377254405,
        -0.0398841716,
        -0.1495436493,
        -0.0953213029,
         0.2590057222,
         0.7809497556,
         1.1192296431,
         1.0134180415,
         0.5468139260,
         0.0643544803,
        -0.1531665552,
        -0.1073582218,
         0.0065136553,
         0.0403506736,
         0.0051482140,
        -0.0181475753,
        -0.0029621824,
         0.0145205425,
         0.0080338675,
        -0.0062611330,
    },
    {
        -0.0063077263,          /* Filter 44 */
        -0.0007058736,
         0.0136662644,
         0.0090301109,
        -0.0129667273,
        -0.0128040373,
         0.0242641295,
         0.0375856989,
        -0.0404996829,
        -0.1498837288,
        -0.0942891228,
         0.2615313001,
         0.7835245105,
         1.1199444556,
         1.0117052957,
         0.5440100595,
         0.0623906951,
        -0.1534958509,
        -0.1067558483,
         0.0069591716,
         0.0402823226,
         0.0049347874,
        -0.0181554728,
        -0.0028370545,
         0.0145523054,
         0.0079540084,
        -0.0063077263,
    },
    {
        -0.0063524433,          /* Filter 45 */
        -0.0006271468,
         0.0137090859,
         0.0089364034,
        -0.0130609178,
        -0.0126853455,
         0.0244735035,
         0.0374347062,
        -0.0411201383,
        -0.1502053910,
        -0.0932215526,
         0.2640772680,
         0.7860782123,
         1.1206074115,
         1.0099508380,
         0.5412054490,
         0.0604587578,
        -0.1537946998,
        -0.1061468558,
         0.0073942266,
         0.0402058615,
         0.0047233748,
        -0.0181585214,
        -0.0027118704,
         0.0145809736,
         0.0078732811,
        -0.0063524433,
    },
    {
        -0.0063971602,          /* Filter 46 */
        -0.0005484199,
         0.0137519074,
         0.0088426959,
        -0.0131551082,
        -0.0125666538,
         0.0246828775,
         0.0372837136,
        -0.0417405937,
        -0.1505270533,
        -0.0921539825,
         0.2666232359,
         0.7886319141,
         1.1212703674,
         1.0081963802,
         0.5384008385,
         0.0585268205,
        -0.1540935488,
        -0.1055378633,
         0.0078292816,
         0.0401294005,
         0.0045119622,
        -0.0181615700,
        -0.0025866862,
         0.0146096417,
         0.0077925538,
        -0.0063971602,
    },
    {
        -0.0064418771,          /* Filter 47 */
        -0.0004696930,
         0.0137947290,
         0.0087489883,
        -0.0132492987,
        -0.0124479620,
         0.0248922515,
         0.0371327210,
        -0.0423610491,
        -0.1508487156,
        -0.0910864123,
         0.2691692038,
         0.7911856159,
         1.1219333234,
         1.0064419225,
         0.5355962280,
         0.0565948832,
        -0.1543923977,
        -0.1049288709,
         0.0082643366,
         0.0400529394,
         0.0043005496,
        -0.0181646186,
        -0.0024615020,
         0.0146383099,
         0.0077118264,
        -0.0064418771,
    },
    {
        -0.0064865941,          /* Filter 48 */
        -0.0003909662,
         0.0138375505,
         0.0086552808,
        -0.0133434892,
        -0.0123292702,
         0.0251016255,
         0.0369817283,
        -0.0429815045,
        -0.1511703778,
        -0.0900188421,
         0.2717151717,
         0.7937393177,
         1.1225962793,
         1.0046874648,
         0.5327916175,
         0.0546629459,
        -0.1546912466,
        -0.1043198784,
         0.0086993916,
         0.0399764783,
         0.0040891370,
        -0.0181676672,
        -0.0023363179,
         0.0146669781,
         0.0076310991,
        -0.0064865941,
    },
    {
        -0.0065294127,          /* Filter 49 */
        -0.0003113444,
         0.0138779590,
         0.0085592912,
        -0.0134349336,
        -0.0122057605,
         0.0253083800,
         0.0368194119,
        -0.0436065490,
        -0.1514730924,
        -0.0889158172,
         0.2742808445,
         0.7962710656,
         1.1232071276,
         1.0028919459,
         0.5299871702,
         0.0527631983,
        -0.1549600134,
        -0.1037047827,
         0.0091238428,
         0.0398921042,
         0.0038799031,
        -0.0181659157,
        -0.0022111908,
         0.0146925495,
         0.0075495786,
        -0.0065294127,
    },
    {
        -0.0065722312,          /* Filter 50 */
        -0.0002317225,
         0.0139183676,
         0.0084633017,
        -0.0135263781,
        -0.0120822508,
         0.0255151345,
         0.0366570954,
        -0.0442315934,
        -0.1517758070,
        -0.0878127922,
         0.2768465172,
         0.7988028136,
         1.1238179760,
         1.0010964271,
         0.5271827229,
         0.0508634507,
        -0.1552287801,
        -0.1030896870,
         0.0095482939,
         0.0398077301,
         0.0036706691,
        -0.0181641642,
        -0.0020860637,
         0.0147181210,
         0.0074680581,
        -0.0065722312,
    },
    {
        -0.0066150497,          /* Filter 51 */
        -0.0001521007,
         0.0139587762,
         0.0083673121,
        -0.0136178226,
        -0.0119587410,
         0.0257218890,
         0.0364947790,
        -0.0448566378,
        -0.1520785217,
        -0.0867097673,
         0.2794121900,
         0.8013345616,
         1.1244288244,
         0.9993009082,
         0.5243782755,
         0.0489637030,
        -0.1554975469,
        -0.1024745913,
         0.0099727451,
         0.0397233560,
         0.0034614352,
        -0.0181624126,
        -0.0019609366,
         0.0147436925,
         0.0073865376,
        -0.0066150497,
    },
    {
        -0.0066578683,          /* Filter 52 */
        -0.0000724789,
         0.0139991847,
         0.0082713225,
        -0.0137092670,
        -0.0118352313,
         0.0259286435,
         0.0363324626,
        -0.0454816823,
        -0.1523812363,
        -0.0856067424,
         0.2819778628,
         0.8038663095,
         1.1250396727,
         0.9975053893,
         0.5215738282,
         0.0470639554,
        -0.1557663137,
        -0.1018594956,
         0.0103971963,
         0.0396389819,
         0.0032522013,
        -0.0181606611,
        -0.0018358095,
         0.0147692639,
         0.0073050171,
        -0.0066578683,
    },
    {
        -0.0066987682,          /* Filter 53 */
         0.0000079772,
         0.0140371276,
         0.0081731188,
        -0.0137978550,
        -0.0117069598,
         0.0261325528,
         0.0361587569,
        -0.0461109524,
        -0.1526644760,
        -0.0844682133,
         0.2845625427,
         0.8063752082,
         1.1255981821,
         0.9956694743,
         0.5187704467,
         0.0451967228,
        -0.1560053732,
        -0.1012388084,
         0.0108109106,
         0.0395468952,
         0.0030453068,
        -0.0181541619,
        -0.0017108518,
         0.0147917392,
         0.0072227785,
        -0.0066987682,
    },
    {
        -0.0067396681,          /* Filter 54 */
         0.0000884333,
         0.0140750705,
         0.0080749152,
        -0.0138864430,
        -0.0115786884,
         0.0263364621,
         0.0359850512,
        -0.0467402225,
        -0.1529477156,
        -0.0833296841,
         0.2871472226,
         0.8088841069,
         1.1261566915,
         0.9938335593,
         0.5159670651,
         0.0433294902,
        -0.1562444327,
        -0.1006181213,
         0.0112246249,
         0.0394548085,
         0.0028384123,
        -0.0181476627,
        -0.0015858941,
         0.0148142145,
         0.0071405400,
        -0.0067396681,
    },
    {
        -0.0067805681,          /* Filter 55 */
         0.0001688893,
         0.0141130135,
         0.0079767115,
        -0.0139750309,
        -0.0114504169,
         0.0265403713,
         0.0358113454,
        -0.0473694925,
        -0.1532309553,
        -0.0821911550,
         0.2897319024,
         0.8113930056,
         1.1267152010,
         0.9919976443,
         0.5131636835,
         0.0414622576,
        -0.1564834922,
        -0.0999974342,
         0.0116383393,
         0.0393627217,
         0.0026315179,
        -0.0181411635,
        -0.0014609363,
         0.0148366898,
         0.0070583015,
        -0.0067805681,
    },
    {
        -0.0068214680,          /* Filter 56 */
         0.0002493454,
         0.0141509564,
         0.0078785078,
        -0.0140636189,
        -0.0113221454,
         0.0267442806,
         0.0356376397,
        -0.0479987626,
        -0.1535141950,
        -0.0810526259,
         0.2923165823,
         0.8139019043,
         1.1272737104,
         0.9901617293,
         0.5103603020,
         0.0395950250,
        -0.1567225517,
        -0.0993767470,
         0.0120520536,
         0.0392706350,
         0.0024246234,
        -0.0181346643,
        -0.0013359786,
         0.0148591651,
         0.0069760629,
        -0.0068214680,
    },
    {
        -0.0068604309,          /* Filter 57 */
         0.0003305737,
         0.0141863827,
         0.0077781605,
        -0.0141492413,
        -0.0111891732,
         0.0269451182,
         0.0354524867,
        -0.0486318865,
        -0.1537774355,
        -0.0798785587,
         0.2949195592,
         0.8163870640,
         1.1277796693,
         0.9882860972,
         0.5075588838,
         0.0377606163,
        -0.1569322887,
        -0.0987509760,
         0.0124549075,
         0.0391710391,
         0.0022202251,
        -0.0181234734,
        -0.0012113014,
         0.0148785476,
         0.0068931815,
        -0.0068604309,
    },
    {
        -0.0068993938,          /* Filter 58 */
         0.0004118021,
         0.0142218089,
         0.0076778131,
        -0.0142348637,
        -0.0110562009,
         0.0271459557,
         0.0352673337,
        -0.0492650104,
        -0.1540406760,
        -0.0787044914,
         0.2975225362,
         0.8188722237,
         1.1282856282,
         0.9864104651,
         0.5047574656,
         0.0359262076,
        -0.1571420257,
        -0.0981252050,
         0.0128577614,
         0.0390714433,
         0.0020158269,
        -0.0181122824,
        -0.0010866241,
         0.0148979301,
         0.0068103001,
        -0.0068993938,
    },
    {
        -0.0069383568,          /* Filter 59 */
         0.0004930304,
         0.0142572352,
         0.0075774657,
        -0.0143204862,
        -0.0109232287,
         0.0273467933,
         0.0350821807,
        -0.0498981343,
        -0.1543039166,
        -0.0775304241,
         0.3001255131,
         0.8213573834,
         1.1287915871,
         0.9845348330,
         0.5019560473,
         0.0340917989,
        -0.1573517628,
        -0.0974994339,
         0.0132606152,
         0.0389718474,
         0.0018114286,
        -0.0181010915,
        -0.0009619468,
         0.0149173125,
         0.0067274187,
        -0.0069383568,
    },
    {
        -0.0069773197,          /* Filter 60 */
         0.0005742587,
         0.0142926615,
         0.0074771184,
        -0.0144061086,
        -0.0107902564,
         0.0275476309,
         0.0348970277,
        -0.0505312582,
        -0.1545671571,
        -0.0763563569,
         0.3027284900,
         0.8238425431,
         1.1292975460,
         0.9826592009,
         0.4991546291,
         0.0322573902,
        -0.1575614998,
        -0.0968736629,
         0.0136634691,
         0.0388722515,
         0.0016070303,
        -0.0180899006,
        -0.0008372696,
         0.0149366950,
         0.0066445373,
        -0.0069773197,
    },
    {
        -0.0070143291,          /* Filter 61 */
         0.0006561962,
         0.0143255219,
         0.0073747002,
        -0.0144886579,
        -0.0106526491,
         0.0277451696,
         0.0347003770,
        -0.0511678560,
        -0.1548098779,
        -0.0751467332,
         0.3053490417,
         0.8263030803,
         1.1297507626,
         0.9807445444,
         0.4963560664,
         0.0304560978,
        -0.1577423087,
        -0.0962433112,
         0.0140553483,
         0.0387653529,
         0.0014052809,
        -0.0180740774,
        -0.0007129826,
         0.0149529906,
         0.0065610881,
        -0.0070143291,
    },
    {
        -0.0070513384,          /* Filter 62 */
         0.0007381336,
         0.0143583824,
         0.0072722821,
        -0.0145712072,
        -0.0105150418,
         0.0279427082,
         0.0345037263,
        -0.0518044538,
        -0.1550525987,
        -0.0739371095,
         0.3079695935,
         0.8287636175,
         1.1302039792,
         0.9788298879,
         0.4935575036,
         0.0286548053,
        -0.1579231176,
        -0.0956129596,
         0.0144472274,
         0.0386584542,
         0.0012035315,
        -0.0180582542,
        -0.0005886957,
         0.0149692862,
         0.0064776390,
        -0.0070513384,
    },
    {
        -0.0070883478,          /* Filter 63 */
         0.0008200711,
         0.0143912428,
         0.0071698639,
        -0.0146537564,
        -0.0103774345,
         0.0281402469,
         0.0343070757,
        -0.0524410516,
        -0.1552953196,
        -0.0727274858,
         0.3105901453,
         0.8312241547,
         1.1306571957,
         0.9769152314,
         0.4907589408,
         0.0268535128,
        -0.1581039265,
        -0.0949826079,
         0.0148391066,
         0.0385515555,
         0.0010017821,
        -0.0180424310,
        -0.0004644087,
         0.0149855817,
         0.0063941899,
        -0.0070883478,
    },
    {
        -0.0071253572,          /* Filter 64 */
         0.0009020085,
         0.0144241033,
         0.0070674458,
        -0.0147363057,
        -0.0102398272,
         0.0283377856,
         0.0341104250,
        -0.0530776494,
        -0.1555380404,
        -0.0715178621,
         0.3132106970,
         0.8336846919,
         1.1311104123,
         0.9750005749,
         0.4879603781,
         0.0250522204,
        -0.1582847354,
        -0.0943522562,
         0.0152309858,
         0.0384446569,
         0.0008000327,
        -0.0180266078,
        -0.0003401218,
         0.0150018773,
         0.0063107407,
        -0.0071253572,
    },
    {
        -0.0071603984,          /* Filter 65 */
         0.0009845909,
         0.0144543506,
         0.0069630322,
        -0.0148156760,
        -0.0100976555,
         0.0285317978,
         0.0339022340,
        -0.0537173332,
        -0.1557597248,
        -0.0702726794,
         0.3158480896,
         0.8361197295,
         1.1315107147,
         0.9730476000,
         0.4851655571,
         0.0232843200,
        -0.1584370199,
        -0.0937178223,
         0.0156117854,
         0.0383306645,
         0.0006010807,
        -0.0180062152,
        -0.0002163337,
         0.0150150946,
         0.0062267989,
        -0.0071603984,
    },
    {
        -0.0071954396,          /* Filter 66 */
         0.0010671732,
         0.0144845980,
         0.0068586187,
        -0.0148950462,
        -0.0099554838,
         0.0287258100,
         0.0336940430,
        -0.0543570170,
        -0.1559814091,
        -0.0690274966,
         0.3184854822,
         0.8385547671,
         1.1319110171,
         0.9710946252,
         0.4823707362,
         0.0215164197,
        -0.1585893044,
        -0.0930833884,
         0.0159925851,
         0.0382166722,
         0.0004021286,
        -0.0179858226,
        -0.0000925456,
         0.0150283118,
         0.0061428571,
        -0.0071954396,
    },
    {
        -0.0072304808,          /* Filter 67 */
         0.0011497556,
         0.0145148453,
         0.0067542051,
        -0.0149744164,
        -0.0098133120,
         0.0289198222,
         0.0334858520,
        -0.0549967007,
        -0.1562030935,
        -0.0677823139,
         0.3211228748,
         0.8409898048,
         1.1323113195,
         0.9691416503,
         0.4795759152,
         0.0197485194,
        -0.1587415890,
        -0.0924489546,
         0.0163733847,
         0.0381026799,
         0.0002031766,
        -0.0179654300,
         0.0000312425,
         0.0150415291,
         0.0060589152,
        -0.0072304808,
    },
    {
        -0.0072655220,          /* Filter 68 */
         0.0012323380,
         0.0145450926,
         0.0066497916,
        -0.0150537867,
        -0.0096711403,
         0.0291138344,
         0.0332776610,
        -0.0556363845,
        -0.1564247779,
        -0.0665371312,
         0.3237602674,
         0.8434248424,
         1.1327116219,
         0.9671886754,
         0.4767810943,
         0.0179806190,
        -0.1588938735,
        -0.0918145207,
         0.0167541843,
         0.0379886875,
         0.0000042245,
        -0.0179450374,
         0.0001550306,
         0.0150547463,
         0.0059749734,
        -0.0072655220,
    },
    {
        -0.0072985821,          /* Filter 69 */
         0.0013155000,
         0.0145726813,
         0.0065434604,
        -0.0151298737,
        -0.0095244794,
         0.0293040921,
         0.0330578948,
        -0.0562787584,
        -0.1566249133,
        -0.0652564027,
         0.3264137554,
         0.8458335104,
         1.1330588584,
         0.9651981011,
         0.4739908953,
         0.0162463699,
        -0.1590180464,
        -0.0911764983,
         0.0171238088,
         0.0378678131,
        -0.0001917859,
        -0.0179201415,
         0.0002782127,
         0.0150648964,
         0.0058906138,
        -0.0072985821,
    },
    {
        -0.0073316423,          /* Filter 70 */
         0.0013986619,
         0.0146002700,
         0.0064371292,
        -0.0152059606,
        -0.0093778185,
         0.0294943498,
         0.0328381287,
        -0.0569211323,
        -0.1568250487,
        -0.0639756742,
         0.3290672434,
         0.8482421784,
         1.1334060948,
         0.9632075269,
         0.4712006964,
         0.0145121209,
        -0.1591422194,
        -0.0905384758,
         0.0174934334,
         0.0377469388,
        -0.0003877963,
        -0.0178952456,
         0.0004013948,
         0.0150750465,
         0.0058062542,
        -0.0073316423,
    },
    {
        -0.0073647024,          /* Filter 71 */
         0.0014818238,
         0.0146278587,
         0.0063307981,
        -0.0152820476,
        -0.0092311577,
         0.0296846075,
         0.0326183626,
        -0.0575635062,
        -0.1570251841,
        -0.0626949457,
         0.3317207313,
         0.8506508464,
         1.1337533312,
         0.9612169527,
         0.4684104974,
         0.0127778718,
        -0.1592663923,
        -0.0899004534,
         0.0178630580,
         0.0376260645,
        -0.0005838066,
        -0.0178703496,
         0.0005245769,
         0.0150851966,
         0.0057218945,
        -0.0073647024,
    },
    {
        -0.0073977626,          /* Filter 72 */
         0.0015649858,
         0.0146554474,
         0.0062244669,
        -0.0153581346,
        -0.0090844968,
         0.0298748652,
         0.0323985964,
        -0.0582058801,
        -0.1572253195,
        -0.0614142172,
         0.3343742193,
         0.8530595144,
         1.1341005677,
         0.9592263784,
         0.4656202984,
         0.0110436227,
        -0.1593905652,
        -0.0892624310,
         0.0182326825,
         0.0375051901,
        -0.0007798170,
        -0.0178454537,
         0.0006477590,
         0.0150953467,
         0.0056375349,
        -0.0073977626,
    },
    {
        -0.0074288307,          /* Filter 73 */
         0.0016486610,
         0.0146803340,
         0.0061162982,
        -0.0154308360,
        -0.0089334270,
         0.0300611403,
         0.0321672283,
        -0.0588505405,
        -0.1574033979,
        -0.0600979721,
         0.3370430459,
         0.8554409500,
         1.1343946064,
         0.9571989365,
         0.4628355950,
         0.0093432676,
        -0.1594870480,
        -0.0886213085,
         0.0185910456,
         0.0373776477,
        -0.0009727457,
        -0.0178161239,
         0.0007702295,
         0.0151024434,
         0.0055528321,
        -0.0074288307,
    },
    {
        -0.0074598989,          /* Filter 74 */
         0.0017323362,
         0.0147052206,
         0.0060081295,
        -0.0155035374,
        -0.0087823572,
         0.0302474155,
         0.0319358603,
        -0.0594952010,
        -0.1575814762,
        -0.0587817270,
         0.3397118725,
         0.8578223857,
         1.1346886452,
         0.9551714946,
         0.4600508916,
         0.0076429125,
        -0.1595835309,
        -0.0879801860,
         0.0189494088,
         0.0372501053,
        -0.0011656744,
        -0.0177867940,
         0.0008927000,
         0.0151095401,
         0.0054681293,
        -0.0074598989,
    },
    {
        -0.0074909671,          /* Filter 75 */
         0.0018160114,
         0.0147301073,
         0.0058999608,
        -0.0155762387,
        -0.0086312874,
         0.0304336906,
         0.0317044922,
        -0.0601398614,
        -0.1577595546,
        -0.0574654818,
         0.3423806991,
         0.8602038214,
         1.1349826840,
         0.9531440526,
         0.4572661882,
         0.0059425574,
        -0.1596800138,
        -0.0873390634,
         0.0193077719,
         0.0371225630,
        -0.0013586031,
        -0.0177574641,
         0.0010151706,
         0.0151166368,
         0.0053834266,
        -0.0074909671,
    },
    {
        -0.0075220352,          /* Filter 76 */
         0.0018996866,
         0.0147549939,
         0.0057917921,
        -0.0156489401,
        -0.0084802176,
         0.0306199657,
         0.0314731241,
        -0.0607845218,
        -0.1579376330,
        -0.0561492367,
         0.3450495257,
         0.8625852570,
         1.1352767227,
         0.9511166107,
         0.4544814848,
         0.0042422023,
        -0.1597764966,
        -0.0866979409,
         0.0196661350,
         0.0369950206,
        -0.0015515318,
        -0.0177281343,
         0.0011376411,
         0.0151237335,
         0.0052987238,
        -0.0075220352,
    },
    {
        -0.0075511022,          /* Filter 77 */
         0.0019838077,
         0.0147771370,
         0.0056818683,
        -0.0157181554,
        -0.0083248237,
         0.0308020301,
         0.0312301354,
        -0.0614310576,
        -0.1580931511,
        -0.0547975203,
         0.3477329233,
         0.8649386054,
         1.1355174522,
         0.9490530451,
         0.4517031437,
         0.0025759672,
        -0.1598457194,
        -0.0860542014,
         0.0200131596,
         0.0368610264,
        -0.0017412432,
        -0.0176944430,
         0.0012592959,
         0.0151277930,
         0.0052137523,
        -0.0075511022,
    },
    {
        -0.0075801691,          /* Filter 78 */
         0.0020679289,
         0.0147992801,
         0.0055719445,
        -0.0157873707,
        -0.0081694298,
         0.0309840946,
         0.0309871466,
        -0.0620775934,
        -0.1582486693,
        -0.0534458038,
         0.3504163209,
         0.8672919537,
         1.1357581817,
         0.9469894795,
         0.4489248026,
         0.0009097321,
        -0.1599149422,
        -0.0854104620,
         0.0203601842,
         0.0367270322,
        -0.0019309546,
        -0.0176607517,
         0.0013809507,
         0.0151318525,
         0.0051287807,
        -0.0075801691,
    },
    {
        -0.0076092361,          /* Filter 79 */
         0.0021520500,
         0.0148214231,
         0.0054620207,
        -0.0158565859,
        -0.0080140360,
         0.0311661591,
         0.0307441579,
        -0.0627241291,
        -0.1584041874,
        -0.0520940873,
         0.3530997184,
         0.8696453021,
         1.1359989112,
         0.9449259138,
         0.4461464615,
        -0.0007565030,
        -0.1599841650,
        -0.0847667225,
         0.0207072088,
         0.0365930381,
        -0.0021206660,
        -0.0176270603,
         0.0015026056,
         0.0151359121,
         0.0050438092,
        -0.0076092361,
    },
    {
        -0.0076383031,          /* Filter 80 */
         0.0022361711,
         0.0148435662,
         0.0053520969,
        -0.0159258012,
        -0.0078586421,
         0.0313482235,
         0.0305011692,
        -0.0633706649,
        -0.1585597055,
        -0.0507423709,
         0.3557831160,
         0.8719986504,
         1.1362396407,
         0.9428623482,
         0.4433681204,
        -0.0024227381,
        -0.1600533878,
        -0.0841229830,
         0.0210542334,
         0.0364590439,
        -0.0023103774,
        -0.0175933690,
         0.0016242604,
         0.0151399716,
         0.0049588376,
        -0.0076383031,
    },
    {
        -0.0076653616,          /* Filter 81 */
         0.0023206699,
         0.0148629263,
         0.0052405027,
        -0.0159914320,
        -0.0076990139,
         0.0315258494,
         0.0302465494,
        -0.0640186574,
        -0.1586921653,
        -0.0493552445,
         0.3584803062,
         0.8743230646,
         1.1364269696,
         0.9407634148,
         0.4405970010,
        -0.0040546438,
        -0.1600957887,
        -0.0834771042,
         0.0213898515,
         0.0363188161,
        -0.0024967402,
        -0.0175553917,
         0.0017449971,
         0.0151410128,
         0.0048736713,
        -0.0076653616,
    },
    {
        -0.0076924201,          /* Filter 82 */
         0.0024051688,
         0.0148822863,
         0.0051289086,
        -0.0160570628,
        -0.0075393856,
         0.0317034753,
         0.0299919296,
        -0.0646666499,
        -0.1588246251,
        -0.0479681182,
         0.3611774964,
         0.8766474789,
         1.1366142985,
         0.9386644814,
         0.4378258816,
        -0.0056865495,
        -0.1601381896,
        -0.0828312254,
         0.0217254696,
         0.0361785883,
        -0.0026831030,
        -0.0175174144,
         0.0018657338,
         0.0151420539,
         0.0047885049,
        -0.0076924201,
    },
    {
        -0.0077194786,          /* Filter 83 */
         0.0024896677,
         0.0149016464,
         0.0050173145,
        -0.0161226937,
        -0.0073797574,
         0.0318811011,
         0.0297373097,
        -0.0653146424,
        -0.1589570848,
        -0.0465809918,
         0.3638746867,
         0.8789718932,
         1.1368016273,
         0.9365655480,
         0.4350547621,
        -0.0073184552,
        -0.1601805906,
        -0.0821853465,
         0.0220610877,
         0.0360383604,
        -0.0028694659,
        -0.0174794371,
         0.0019864706,
         0.0151430951,
         0.0047033386,
        -0.0077194786,
    },
    {
        -0.0077465371,          /* Filter 84 */
         0.0025741665,
         0.0149210065,
         0.0049057203,
        -0.0161883245,
        -0.0072201291,
         0.0320587270,
         0.0294826899,
        -0.0659626349,
        -0.1590895446,
        -0.0451938654,
         0.3665718769,
         0.8812963074,
         1.1369889562,
         0.9344666146,
         0.4322836427,
        -0.0089503609,
        -0.1602229915,
        -0.0815394677,
         0.0223967058,
         0.0358981326,
        -0.0030558287,
        -0.0174414598,
         0.0021072073,
         0.0151441363,
         0.0046181723,
        -0.0077465371,
    },
    {
        -0.0077715817,          /* Filter 85 */
         0.0026589739,
         0.0149375463,
         0.0047925427,
        -0.0162502746,
        -0.0070563609,
         0.0322316868,
         0.0292164368,
        -0.0666116582,
        -0.1591984533,
        -0.0437714067,
         0.3692820712,
         0.8835909493,
         1.1371228133,
         0.9323330810,
         0.4295205967,
        -0.0105477443,
        -0.1602390166,
        -0.0808919213,
         0.0227208584,
         0.0357518911,
        -0.0032387162,
        -0.0173992750,
         0.0022269252,
         0.0151421803,
         0.0045328849,
        -0.0077715817,
    },
    {
        -0.0077966263,          /* Filter 86 */
         0.0027437814,
         0.0149540860,
         0.0046793651,
        -0.0163122247,
        -0.0068925926,
         0.0324046465,
         0.0289501837,
        -0.0672606816,
        -0.1593073621,
        -0.0423489480,
         0.3719922654,
         0.8858855912,
         1.1372566705,
         0.9301995473,
         0.4267575507,
        -0.0121451278,
        -0.1602550416,
        -0.0802443750,
         0.0230450111,
         0.0356056497,
        -0.0034216036,
        -0.0173570901,
         0.0023466432,
         0.0151402244,
         0.0044475975,
        -0.0077966263,
    },
    {
        -0.0078216708,          /* Filter 87 */
         0.0028285889,
         0.0149706258,
         0.0045661874,
        -0.0163741748,
        -0.0067288244,
         0.0325776063,
         0.0286839306,
        -0.0679097049,
        -0.1594162708,
        -0.0409264892,
         0.3747024597,
         0.8881802332,
         1.1373905277,
         0.9280660136,
         0.4239945048,
        -0.0137425112,
        -0.1602710667,
        -0.0795968286,
         0.0233691637,
         0.0354594082,
        -0.0036044911,
        -0.0173149052,
         0.0024663611,
         0.0151382684,
         0.0043623100,
        -0.0078216708,
    },
    {
        -0.0078467154,          /* Filter 88 */
         0.0029133963,
         0.0149871656,
         0.0044530098,
        -0.0164361249,
        -0.0065650562,
         0.0327505660,
         0.0284176775,
        -0.0685587283,
        -0.1595251795,
        -0.0395040305,
         0.3774126540,
         0.8904748751,
         1.1375243848,
         0.9259324800,
         0.4212314588,
        -0.0153398946,
        -0.1602870918,
        -0.0789492822,
         0.0236933163,
         0.0353131667,
        -0.0037873786,
        -0.0172727204,
         0.0025860790,
         0.0151363124,
         0.0042770226,
        -0.0078467154,
    },
    {
        -0.0078697424,          /* Filter 89 */
         0.0029984424,
         0.0150008499,
         0.0043383378,
        -0.0164943003,
        -0.0063972472,
         0.0329186327,
         0.0281397975,
        -0.0692083494,
        -0.1596100502,
        -0.0380463334,
         0.3801350536,
         0.8927389154,
         1.1376047194,
         0.9237651249,
         0.4184773301,
        -0.0169025795,
        -0.1602771947,
        -0.0783005341,
         0.0240059536,
         0.0351611331,
        -0.0039666685,
        -0.0172264093,
         0.0027046791,
         0.0151313829,
         0.0041916871,
        -0.0078697424,
    },
    {
        -0.0078927693,          /* Filter 90 */
         0.0030834886,
         0.0150145343,
         0.0042236658,
        -0.0165524757,
        -0.0062294381,
         0.0330866994,
         0.0278619174,
        -0.0698579705,
        -0.1596949209,
        -0.0365886362,
         0.3828574533,
         0.8950029557,
         1.1376850540,
         0.9215977697,
         0.4157232014,
        -0.0184652644,
        -0.1602672976,
        -0.0776517859,
         0.0243185908,
         0.0350090996,
        -0.0041459584,
        -0.0171800981,
         0.0028232792,
         0.0151264535,
         0.0041063517,
        -0.0078927693,
    },
    {
        -0.0079157963,          /* Filter 91 */
         0.0031685348,
         0.0150282187,
         0.0041089937,
        -0.0166106510,
        -0.0060616291,
         0.0332547661,
         0.0275840373,
        -0.0705075917,
        -0.1597797917,
        -0.0351309390,
         0.3855798530,
         0.8972669961,
         1.1377653887,
         0.9194304146,
         0.4129690726,
        -0.0200279493,
        -0.1602574005,
        -0.0770030378,
         0.0246312280,
         0.0348570660,
        -0.0043252482,
        -0.0171337870,
         0.0029418794,
         0.0151215240,
         0.0040210163,
        -0.0079157963,
    },
    {
        -0.0079388232,          /* Filter 92 */
         0.0032535809,
         0.0150419030,
         0.0039943217,
        -0.0166688264,
        -0.0058938201,
         0.0334228328,
         0.0273061573,
        -0.0711572128,
        -0.1598646624,
        -0.0336732419,
         0.3883022526,
         0.8995310364,
         1.1378457233,
         0.9172630595,
         0.4102149439,
        -0.0215906342,
        -0.1602475034,
        -0.0763542897,
         0.0249438653,
         0.0347050324,
        -0.0045045381,
        -0.0170874759,
         0.0030604795,
         0.0151165945,
         0.0039356808,
        -0.0079388232,
    },
    {
        -0.0079598307,          /* Filter 93 */
         0.0033387951,
         0.0150526990,
         0.0038782465,
        -0.0167231354,
        -0.0057220741,
         0.0335857801,
         0.0270166651,
        -0.0718069918,
        -0.1599250142,
        -0.0321804167,
         0.3910360493,
         0.9017636552,
         1.1378725049,
         0.9150626725,
         0.4074705678,
        -0.0231184609,
        -0.1602121450,
        -0.0757047995,
         0.0252449461,
         0.0345474298,
        -0.0046801126,
        -0.0170371225,
         0.0031778648,
         0.0151087176,
         0.0038503700,
        -0.0079598307,
    },
    {
        -0.0079808382,          /* Filter 94 */
         0.0034240093,
         0.0150634949,
         0.0037621712,
        -0.0167774444,
        -0.0055503281,
         0.0337487275,
         0.0267271730,
        -0.0724567708,
        -0.1599853660,
        -0.0306875914,
         0.3937698460,
         0.9039962740,
         1.1378992865,
         0.9128622855,
         0.4047261917,
        -0.0246462875,
        -0.1601767866,
        -0.0750553093,
         0.0255460270,
         0.0343898273,
        -0.0048556871,
        -0.0169867691,
         0.0032952501,
         0.0151008407,
         0.0037650592,
        -0.0079808382,
    },
    {
        -0.0080018457,          /* Filter 95 */
         0.0035092234,
         0.0150742909,
         0.0036460959,
        -0.0168317533,
        -0.0053785821,
         0.0339116748,
         0.0264376808,
        -0.0731065499,
        -0.1600457179,
        -0.0291947661,
         0.3965036428,
         0.9062288927,
         1.1379260681,
         0.9106618985,
         0.4019818156,
        -0.0261741142,
        -0.1601414281,
        -0.0744058191,
         0.0258471078,
         0.0342322247,
        -0.0050312616,
        -0.0169364157,
         0.0034126354,
         0.0150929638,
         0.0036797484,
        -0.0080018457,
    },
    {
        -0.0080228532,          /* Filter 96 */
         0.0035944376,
         0.0150850869,
         0.0035300207,
        -0.0168860623,
        -0.0052068361,
         0.0340746221,
         0.0261481886,
        -0.0737563289,
        -0.1601060697,
        -0.0277019409,
         0.3992374395,
         0.9084615115,
         1.1379528497,
         0.9084615115,
         0.3992374395,
        -0.0277019409,
        -0.1601060697,
        -0.0737563289,
         0.0261481886,
         0.0340746221,
        -0.0052068361,
        -0.0168860623,
         0.0035300207,
         0.0150850869,
         0.0035944376,
        -0.0080228532,
    },
    {
        -0.0080418412,          /* Filter 97 */
         0.0036797484,
         0.0150929638,
         0.0034126354,
        -0.0169364157,
        -0.0050312616,
         0.0342322247,
         0.0258471078,
        -0.0744058191,
        -0.1601414281,
        -0.0261741142,
         0.4019818156,
         0.9106618985,
         1.1379260681,
         0.9062288927,
         0.3965036428,
        -0.0291947661,
        -0.1600457179,
        -0.0731065499,
         0.0264376808,
         0.0339116748,
        -0.0053785821,
        -0.0168317533,
         0.0036460959,
         0.0150742909,
         0.0035092234,
        -0.0080418412,
    },
    {
        -0.0080608292,          /* Filter 98 */
         0.0037650592,
         0.0151008407,
         0.0032952501,
        -0.0169867691,
        -0.0048556871,
         0.0343898273,
         0.0255460270,
        -0.0750553093,
        -0.1601767866,
        -0.0246462875,
         0.4047261917,
         0.9128622855,
         1.1378992865,
         0.9039962740,
         0.3937698460,
        -0.0306875914,
        -0.1599853660,
        -0.0724567708,
         0.0267271730,
         0.0337487275,
        -0.0055503281,
        -0.0167774444,
         0.0037621712,
         0.0150634949,
         0.0034240093,
        -0.0080608292,
    },
    {
        -0.0080798172,          /* Filter 99 */
         0.0038503700,
         0.0151087176,
         0.0031778648,
        -0.0170371225,
        -0.0046801126,
         0.0345474298,
         0.0252449461,
        -0.0757047995,
        -0.1602121450,
        -0.0231184609,
         0.4074705678,
         0.9150626725,
         1.1378725049,
         0.9017636552,
         0.3910360493,
        -0.0321804167,
        -0.1599250142,
        -0.0718069918,
         0.0270166651,
         0.0335857801,
        -0.0057220741,
        -0.0167231354,
         0.0038782465,
         0.0150526990,
         0.0033387951,
        -0.0080798172,
    },
    {
        -0.0080988052,          /* Filter 100 */
         0.0039356808,
         0.0151165945,
         0.0030604795,
        -0.0170874759,
        -0.0045045381,
         0.0347050324,
         0.0249438653,
        -0.0763542897,
        -0.1602475034,
        -0.0215906342,
         0.4102149439,
         0.9172630595,
         1.1378457233,
         0.8995310364,
         0.3883022526,
        -0.0336732419,
        -0.1598646624,
        -0.0711572128,
         0.0273061573,
         0.0334228328,
        -0.0058938201,
        -0.0166688264,
         0.0039943217,
         0.0150419030,
         0.0032535809,
        -0.0080988052,
    },
    {
        -0.0081157754,          /* Filter 101 */
         0.0040210163,
         0.0151215240,
         0.0029418794,
        -0.0171337870,
        -0.0043252482,
         0.0348570660,
         0.0246312280,
        -0.0770030378,
        -0.1602574005,
        -0.0200279493,
         0.4129690726,
         0.9194304146,
         1.1377653887,
         0.8972669961,
         0.3855798530,
        -0.0351309390,
        -0.1597797917,
        -0.0705075917,
         0.0275840373,
         0.0332547661,
        -0.0060616291,
        -0.0166106510,
         0.0041089937,
         0.0150282187,
         0.0031685348,
        -0.0081157754,
    },
    {
        -0.0081327457,          /* Filter 102 */
         0.0041063517,
         0.0151264535,
         0.0028232792,
        -0.0171800981,
        -0.0041459584,
         0.0350090996,
         0.0243185908,
        -0.0776517859,
        -0.1602672976,
        -0.0184652644,
         0.4157232014,
         0.9215977697,
         1.1376850540,
         0.8950029557,
         0.3828574533,
        -0.0365886362,
        -0.1596949209,
        -0.0698579705,
         0.0278619174,
         0.0330866994,
        -0.0062294381,
        -0.0165524757,
         0.0042236658,
         0.0150145343,
         0.0030834886,
        -0.0081327457,
    },
    {
        -0.0081497159,          /* Filter 103 */
         0.0041916871,
         0.0151313829,
         0.0027046791,
        -0.0172264093,
        -0.0039666685,
         0.0351611331,
         0.0240059536,
        -0.0783005341,
        -0.1602771947,
        -0.0169025795,
         0.4184773301,
         0.9237651249,
         1.1376047194,
         0.8927389154,
         0.3801350536,
        -0.0380463334,
        -0.1596100502,
        -0.0692083494,
         0.0281397975,
         0.0329186327,
        -0.0063972472,
        -0.0164943003,
         0.0043383378,
         0.0150008499,
         0.0029984424,
        -0.0081497159,
    },
    {
        -0.0081666861,          /* Filter 104 */
         0.0042770226,
         0.0151363124,
         0.0025860790,
        -0.0172727204,
        -0.0037873786,
         0.0353131667,
         0.0236933163,
        -0.0789492822,
        -0.1602870918,
        -0.0153398946,
         0.4212314588,
         0.9259324800,
         1.1375243848,
         0.8904748751,
         0.3774126540,
        -0.0395040305,
        -0.1595251795,
        -0.0685587283,
         0.0284176775,
         0.0327505660,
        -0.0065650562,
        -0.0164361249,
         0.0044530098,
         0.0149871656,
         0.0029133963,
        -0.0081666861,
    },
    {
        -0.0081816420,          /* Filter 105 */
         0.0043623100,
         0.0151382684,
         0.0024663611,
        -0.0173149052,
        -0.0036044911,
         0.0354594082,
         0.0233691637,
        -0.0795968286,
        -0.1602710667,
        -0.0137425112,
         0.4239945048,
         0.9280660136,
         1.1373905277,
         0.8881802332,
         0.3747024597,
        -0.0409264892,
        -0.1594162708,
        -0.0679097049,
         0.0286839306,
         0.0325776063,
        -0.0067288244,
        -0.0163741748,
         0.0045661874,
         0.0149706258,
         0.0028285889,
        -0.0081816420,
    },
    {
        -0.0081965980,          /* Filter 106 */
         0.0044475975,
         0.0151402244,
         0.0023466432,
        -0.0173570901,
        -0.0034216036,
         0.0356056497,
         0.0230450111,
        -0.0802443750,
        -0.1602550416,
        -0.0121451278,
         0.4267575507,
         0.9301995473,
         1.1372566705,
         0.8858855912,
         0.3719922654,
        -0.0423489480,
        -0.1593073621,
        -0.0672606816,
         0.0289501837,
         0.0324046465,
        -0.0068925926,
        -0.0163122247,
         0.0046793651,
         0.0149540860,
         0.0027437814,
        -0.0081965980,
    },
    {
        -0.0082115539,          /* Filter 107 */
         0.0045328849,
         0.0151421803,
         0.0022269252,
        -0.0173992750,
        -0.0032387162,
         0.0357518911,
         0.0227208584,
        -0.0808919213,
        -0.1602390166,
        -0.0105477443,
         0.4295205967,
         0.9323330810,
         1.1371228133,
         0.8835909493,
         0.3692820712,
        -0.0437714067,
        -0.1591984533,
        -0.0666116582,
         0.0292164368,
         0.0322316868,
        -0.0070563609,
        -0.0162502746,
         0.0047925427,
         0.0149375463,
         0.0026589739,
        -0.0082115539,
    },
    {
        -0.0082265098,          /* Filter 108 */
         0.0046181723,
         0.0151441363,
         0.0021072073,
        -0.0174414598,
        -0.0030558287,
         0.0358981326,
         0.0223967058,
        -0.0815394677,
        -0.1602229915,
        -0.0089503609,
         0.4322836427,
         0.9344666146,
         1.1369889562,
         0.8812963074,
         0.3665718769,
        -0.0451938654,
        -0.1590895446,
        -0.0659626349,
         0.0294826899,
         0.0320587270,
        -0.0072201291,
        -0.0161883245,
         0.0049057203,
         0.0149210065,
         0.0025741665,
        -0.0082265098,
    },
    {
        -0.0082394567,          /* Filter 109 */
         0.0047033386,
         0.0151430951,
         0.0019864706,
        -0.0174794371,
        -0.0028694659,
         0.0360383604,
         0.0220610877,
        -0.0821853465,
        -0.1601805906,
        -0.0073184552,
         0.4350547621,
         0.9365655480,
         1.1368016273,
         0.8789718932,
         0.3638746867,
        -0.0465809918,
        -0.1589570848,
        -0.0653146424,
         0.0297373097,
         0.0318811011,
        -0.0073797574,
        -0.0161226937,
         0.0050173145,
         0.0149016464,
         0.0024896677,
        -0.0082394567,
    },
    {
        -0.0082524037,          /* Filter 110 */
         0.0047885049,
         0.0151420539,
         0.0018657338,
        -0.0175174144,
        -0.0026831030,
         0.0361785883,
         0.0217254696,
        -0.0828312254,
        -0.1601381896,
        -0.0056865495,
         0.4378258816,
         0.9386644814,
         1.1366142985,
         0.8766474789,
         0.3611774964,
        -0.0479681182,
        -0.1588246251,
        -0.0646666499,
         0.0299919296,
         0.0317034753,
        -0.0075393856,
        -0.0160570628,
         0.0051289086,
         0.0148822863,
         0.0024051688,
        -0.0082524037,
    },
    {
        -0.0082653506,          /* Filter 111 */
         0.0048736713,
         0.0151410128,
         0.0017449971,
        -0.0175553917,
        -0.0024967402,
         0.0363188161,
         0.0213898515,
        -0.0834771042,
        -0.1600957887,
        -0.0040546438,
         0.4405970010,
         0.9407634148,
         1.1364269696,
         0.8743230646,
         0.3584803062,
        -0.0493552445,
        -0.1586921653,
        -0.0640186574,
         0.0302465494,
         0.0315258494,
        -0.0076990139,
        -0.0159914320,
         0.0052405027,
         0.0148629263,
         0.0023206699,
        -0.0082653506,
    },
    {
        -0.0082782975,          /* Filter 112 */
         0.0049588376,
         0.0151399716,
         0.0016242604,
        -0.0175933690,
        -0.0023103774,
         0.0364590439,
         0.0210542334,
        -0.0841229830,
        -0.1600533878,
        -0.0024227381,
         0.4433681204,
         0.9428623482,
         1.1362396407,
         0.8719986504,
         0.3557831160,
        -0.0507423709,
        -0.1585597055,
        -0.0633706649,
         0.0305011692,
         0.0313482235,
        -0.0078586421,
        -0.0159258012,
         0.0053520969,
         0.0148435662,
         0.0022361711,
        -0.0082782975,
    },
    {
        -0.0082892424,          /* Filter 113 */
         0.0050438092,
         0.0151359121,
         0.0015026056,
        -0.0176270603,
        -0.0021206660,
         0.0365930381,
         0.0207072088,
        -0.0847667225,
        -0.1599841650,
        -0.0007565030,
         0.4461464615,
         0.9449259138,
         1.1359989112,
         0.8696453021,
         0.3530997184,
        -0.0520940873,
        -0.1584041874,
        -0.0627241291,
         0.0307441579,
         0.0311661591,
        -0.0080140360,
        -0.0158565859,
         0.0054620207,
         0.0148214231,
         0.0021520500,
        -0.0082892424,
    },
    {
        -0.0083001873,          /* Filter 114 */
         0.0051287807,
         0.0151318525,
         0.0013809507,
        -0.0176607517,
        -0.0019309546,
         0.0367270322,
         0.0203601842,
        -0.0854104620,
        -0.1599149422,
         0.0009097321,
         0.4489248026,
         0.9469894795,
         1.1357581817,
         0.8672919537,
         0.3504163209,
        -0.0534458038,
        -0.1582486693,
        -0.0620775934,
         0.0309871466,
         0.0309840946,
        -0.0081694298,
        -0.0157873707,
         0.0055719445,
         0.0147992801,
         0.0020679289,
        -0.0083001873,
    },
    {
        -0.0083111322,          /* Filter 115 */
         0.0052137523,
         0.0151277930,
         0.0012592959,
        -0.0176944430,
        -0.0017412432,
         0.0368610264,
         0.0200131596,
        -0.0860542014,
        -0.1598457194,
         0.0025759672,
         0.4517031437,
         0.9490530451,
         1.1355174522,
         0.8649386054,
         0.3477329233,
        -0.0547975203,
        -0.1580931511,
        -0.0614310576,
         0.0312301354,
         0.0308020301,
        -0.0083248237,
        -0.0157181554,
         0.0056818683,
         0.0147771370,
         0.0019838077,
        -0.0083111322,
    },
    {
        -0.0083220771,          /* Filter 116 */
         0.0052987238,
         0.0151237335,
         0.0011376411,
        -0.0177281343,
        -0.0015515318,
         0.0369950206,
         0.0196661350,
        -0.0866979409,
        -0.1597764966,
         0.0042422023,
         0.4544814848,
         0.9511166107,
         1.1352767227,
         0.8625852570,
         0.3450495257,
        -0.0561492367,
        -0.1579376330,
        -0.0607845218,
         0.0314731241,
         0.0306199657,
        -0.0084802176,
        -0.0156489401,
         0.0057917921,
         0.0147549939,
         0.0018996866,
        -0.0083220771,
    },
    {
        -0.0083310287,          /* Filter 117 */
         0.0053834266,
         0.0151166368,
         0.0010151706,
        -0.0177574641,
        -0.0013586031,
         0.0371225630,
         0.0193077719,
        -0.0873390634,
        -0.1596800138,
         0.0059425574,
         0.4572661882,
         0.9531440526,
         1.1349826840,
         0.8602038214,
         0.3423806991,
        -0.0574654818,
        -0.1577595546,
        -0.0601398614,
         0.0317044922,
         0.0304336906,
        -0.0086312874,
        -0.0155762387,
         0.0058999608,
         0.0147301073,
         0.0018160114,
        -0.0083310287,
    },
    {
        -0.0083399803,          /* Filter 118 */
         0.0054681293,
         0.0151095401,
         0.0008927000,
        -0.0177867940,
        -0.0011656744,
         0.0372501053,
         0.0189494088,
        -0.0879801860,
        -0.1595835309,
         0.0076429125,
         0.4600508916,
         0.9551714946,
         1.1346886452,
         0.8578223857,
         0.3397118725,
        -0.0587817270,
        -0.1575814762,
        -0.0594952010,
         0.0319358603,
         0.0302474155,
        -0.0087823572,
        -0.0155035374,
         0.0060081295,
         0.0147052206,
         0.0017323362,
        -0.0083399803,
    },
    {
        -0.0083489318,          /* Filter 119 */
         0.0055528321,
         0.0151024434,
         0.0007702295,
        -0.0178161239,
        -0.0009727457,
         0.0373776477,
         0.0185910456,
        -0.0886213085,
        -0.1594870480,
         0.0093432676,
         0.4628355950,
         0.9571989365,
         1.1343946064,
         0.8554409500,
         0.3370430459,
        -0.0600979721,
        -0.1574033979,
        -0.0588505405,
         0.0321672283,
         0.0300611403,
        -0.0089334270,
        -0.0154308360,
         0.0061162982,
         0.0146803340,
         0.0016486610,
        -0.0083489318,
    },
    {
        -0.0083578834,          /* Filter 120 */
         0.0056375349,
         0.0150953467,
         0.0006477590,
        -0.0178454537,
        -0.0007798170,
         0.0375051901,
         0.0182326825,
        -0.0892624310,
        -0.1593905652,
         0.0110436227,
         0.4656202984,
         0.9592263784,
         1.1341005677,
         0.8530595144,
         0.3343742193,
        -0.0614142172,
        -0.1572253195,
        -0.0582058801,
         0.0323985964,
         0.0298748652,
        -0.0090844968,
        -0.0153581346,
         0.0062244669,
         0.0146554474,
         0.0015649858,
        -0.0083578834,
    },
    {
        -0.0083648520,          /* Filter 121 */
         0.0057218945,
         0.0150851966,
         0.0005245769,
        -0.0178703496,
        -0.0005838066,
         0.0376260645,
         0.0178630580,
        -0.0899004534,
        -0.1592663923,
         0.0127778718,
         0.4684104974,
         0.9612169527,
         1.1337533312,
         0.8506508464,
         0.3317207313,
        -0.0626949457,
        -0.1570251841,
        -0.0575635062,
         0.0326183626,
         0.0296846075,
        -0.0092311577,
        -0.0152820476,
         0.0063307981,
         0.0146278587,
         0.0014818238,
        -0.0083648520,
    },
    {
        -0.0083718207,          /* Filter 122 */
         0.0058062542,
         0.0150750465,
         0.0004013948,
        -0.0178952456,
        -0.0003877963,
         0.0377469388,
         0.0174934334,
        -0.0905384758,
        -0.1591422194,
         0.0145121209,
         0.4712006964,
         0.9632075269,
         1.1334060948,
         0.8482421784,
         0.3290672434,
        -0.0639756742,
        -0.1568250487,
        -0.0569211323,
         0.0328381287,
         0.0294943498,
        -0.0093778185,
        -0.0152059606,
         0.0064371292,
         0.0146002700,
         0.0013986619,
        -0.0083718207,
    },
    {
        -0.0083787894,          /* Filter 123 */
         0.0058906138,
         0.0150648964,
         0.0002782127,
        -0.0179201415,
        -0.0001917859,
         0.0378678131,
         0.0171238088,
        -0.0911764983,
        -0.1590180464,
         0.0162463699,
         0.4739908953,
         0.9651981011,
         1.1330588584,
         0.8458335104,
         0.3264137554,
        -0.0652564027,
        -0.1566249133,
        -0.0562787584,
         0.0330578948,
         0.0293040921,
        -0.0095244794,
        -0.0151298737,
         0.0065434604,
         0.0145726813,
         0.0013155000,
        -0.0083787894,
    },
    {
        -0.0083857580,          /* Filter 124 */
         0.0059749734,
         0.0150547463,
         0.0001550306,
        -0.0179450374,
         0.0000042245,
         0.0379886875,
         0.0167541843,
        -0.0918145207,
        -0.1588938735,
         0.0179806190,
         0.4767810943,
         0.9671886754,
         1.1327116219,
         0.8434248424,
         0.3237602674,
        -0.0665371312,
        -0.1564247779,
        -0.0556363845,
         0.0332776610,
         0.0291138344,
        -0.0096711403,
        -0.0150537867,
         0.0066497916,
         0.0145450926,
         0.0012323380,
        -0.0083857580,
    },
    {
        -0.0083907558,          /* Filter 125 */
         0.0060589152,
         0.0150415291,
         0.0000312425,
        -0.0179654300,
         0.0002031766,
         0.0381026799,
         0.0163733847,
        -0.0924489546,
        -0.1587415890,
         0.0197485194,
         0.4795759152,
         0.9691416503,
         1.1323113195,
         0.8409898048,
         0.3211228748,
        -0.0677823139,
        -0.1562030935,
        -0.0549967007,
         0.0334858520,
         0.0289198222,
        -0.0098133120,
        -0.0149744164,
         0.0067542051,
         0.0145148453,
         0.0011497556,
        -0.0083907558,
    },
    {
        -0.0083957537,          /* Filter 126 */
         0.0061428571,
         0.0150283118,
        -0.0000925456,
        -0.0179858226,
         0.0004021286,
         0.0382166722,
         0.0159925851,
        -0.0930833884,
        -0.1585893044,
         0.0215164197,
         0.4823707362,
         0.9710946252,
         1.1319110171,
         0.8385547671,
         0.3184854822,
        -0.0690274966,
        -0.1559814091,
        -0.0543570170,
         0.0336940430,
         0.0287258100,
        -0.0099554838,
        -0.0148950462,
         0.0068586187,
         0.0144845980,
         0.0010671732,
        -0.0083957537,
    },
    {
        -0.0084007515,          /* Filter 127 */
         0.0062267989,
         0.0150150946,
        -0.0002163337,
        -0.0180062152,
         0.0006010807,
         0.0383306645,
         0.0156117854,
        -0.0937178223,
        -0.1584370199,
         0.0232843200,
         0.4851655571,
         0.9730476000,
         1.1315107147,
         0.8361197295,
         0.3158480896,
        -0.0702726794,
        -0.1557597248,
        -0.0537173332,
         0.0339022340,
         0.0285317978,
        -0.0100976555,
        -0.0148156760,
         0.0069630322,
         0.0144543506,
         0.0009845909,
        -0.0084007515,
    },
    {
        -0.0084057493,          /* Filter 128 */
         0.0063107407,
         0.0150018773,
        -0.0003401218,
        -0.0180266078,
         0.0008000327,
         0.0384446569,
         0.0152309858,
        -0.0943522562,
        -0.1582847354,
         0.0250522204,
         0.4879603781,
         0.9750005749,
         1.1311104123,
         0.8336846919,
         0.3132106970,
        -0.0715178621,
        -0.1555380404,
        -0.0530776494,
         0.0341104250,
         0.0283377856,
        -0.0102398272,
        -0.0147363057,
         0.0070674458,
         0.0144241033,
         0.0009020085,
        -0.0084057493,
    },
    {
        -0.0084087900,          /* Filter 129 */
         0.0063941899,
         0.0149855817,
        -0.0004644087,
        -0.0180424310,
         0.0010017821,
         0.0385515555,
         0.0148391066,
        -0.0949826079,
        -0.1581039265,
         0.0268535128,
         0.4907589408,
         0.9769152314,
         1.1306571957,
         0.8312241547,
         0.3105901453,
        -0.0727274858,
        -0.1552953196,
        -0.0524410516,
         0.0343070757,
         0.0281402469,
        -0.0103774345,
        -0.0146537564,
         0.0071698639,
         0.0143912428,
         0.0008200711,
        -0.0084087900,
    },
    {
        -0.0084118308,          /* Filter 130 */
         0.0064776390,
         0.0149692862,
        -0.0005886957,
        -0.0180582542,
         0.0012035315,
         0.0386584542,
         0.0144472274,
        -0.0956129596,
        -0.1579231176,
         0.0286548053,
         0.4935575036,
         0.9788298879,
         1.1302039792,
         0.8287636175,
         0.3079695935,
        -0.0739371095,
        -0.1550525987,
        -0.0518044538,
         0.0345037263,
         0.0279427082,
        -0.0105150418,
        -0.0145712072,
         0.0072722821,
         0.0143583824,
         0.0007381336,
        -0.0084118308,
    },
    {
        -0.0084148715,          /* Filter 131 */
         0.0065610881,
         0.0149529906,
        -0.0007129826,
        -0.0180740774,
         0.0014052809,
         0.0387653529,
         0.0140553483,
        -0.0962433112,
        -0.1577423087,
         0.0304560978,
         0.4963560664,
         0.9807445444,
         1.1297507626,
         0.8263030803,
         0.3053490417,
        -0.0751467332,
        -0.1548098779,
        -0.0511678560,
         0.0347003770,
         0.0277451696,
        -0.0106526491,
        -0.0144886579,
         0.0073747002,
         0.0143255219,
         0.0006561962,
        -0.0084148715,
    },
    {
        -0.0084179123,          /* Filter 132 */
         0.0066445373,
         0.0149366950,
        -0.0008372696,
        -0.0180899006,
         0.0016070303,
         0.0388722515,
         0.0136634691,
        -0.0968736629,
        -0.1575614998,
         0.0322573902,
         0.4991546291,
         0.9826592009,
         1.1292975460,
         0.8238425431,
         0.3027284900,
        -0.0763563569,
        -0.1545671571,
        -0.0505312582,
         0.0348970277,
         0.0275476309,
        -0.0107902564,
        -0.0144061086,
         0.0074771184,
         0.0142926615,
         0.0005742587,
        -0.0084179123,
    },
    {
        -0.0084190113,          /* Filter 133 */
         0.0067274187,
         0.0149173125,
        -0.0009619468,
        -0.0181010915,
         0.0018114286,
         0.0389718474,
         0.0132606152,
        -0.0974994339,
        -0.1573517628,
         0.0340917989,
         0.5019560473,
         0.9845348330,
         1.1287915871,
         0.8213573834,
         0.3001255131,
        -0.0775304241,
        -0.1543039166,
        -0.0498981343,
         0.0350821807,
         0.0273467933,
        -0.0109232287,
        -0.0143204862,
         0.0075774657,
         0.0142572352,
         0.0004930304,
        -0.0084190113,
    },
    {
        -0.0084201103,          /* Filter 134 */
         0.0068103001,
         0.0148979301,
        -0.0010866241,
        -0.0181122824,
         0.0020158269,
         0.0390714433,
         0.0128577614,
        -0.0981252050,
        -0.1571420257,
         0.0359262076,
         0.5047574656,
         0.9864104651,
         1.1282856282,
         0.8188722237,
         0.2975225362,
        -0.0787044914,
        -0.1540406760,
        -0.0492650104,
         0.0352673337,
         0.0271459557,
        -0.0110562009,
        -0.0142348637,
         0.0076778131,
         0.0142218089,
         0.0004118021,
        -0.0084201103,
    },
    {
        -0.0084212093,          /* Filter 135 */
         0.0068931815,
         0.0148785476,
        -0.0012113014,
        -0.0181234734,
         0.0022202251,
         0.0391710391,
         0.0124549075,
        -0.0987509760,
        -0.1569322887,
         0.0377606163,
         0.5075588838,
         0.9882860972,
         1.1277796693,
         0.8163870640,
         0.2949195592,
        -0.0798785587,
        -0.1537774355,
        -0.0486318865,
         0.0354524867,
         0.0269451182,
        -0.0111891732,
        -0.0141492413,
         0.0077781605,
         0.0141863827,
         0.0003305737,
        -0.0084212093,
    },
    {
        -0.0084223083,          /* Filter 136 */
         0.0069760629,
         0.0148591651,
        -0.0013359786,
        -0.0181346643,
         0.0024246234,
         0.0392706350,
         0.0120520536,
        -0.0993767470,
        -0.1567225517,
         0.0395950250,
         0.5103603020,
         0.9901617293,
         1.1272737104,
         0.8139019043,
         0.2923165823,
        -0.0810526259,
        -0.1535141950,
        -0.0479987626,
         0.0356376397,
         0.0267442806,
        -0.0113221454,
        -0.0140636189,
         0.0078785078,
         0.0141509564,
         0.0002493454,
        -0.0084223083,
    },
    {
        -0.0084214825,          /* Filter 137 */
         0.0070583015,
         0.0148366898,
        -0.0014609363,
        -0.0181411635,
         0.0026315179,
         0.0393627217,
         0.0116383393,
        -0.0999974342,
        -0.1564834922,
         0.0414622576,
         0.5131636835,
         0.9919976443,
         1.1267152010,
         0.8113930056,
         0.2897319024,
        -0.0821911550,
        -0.1532309553,
        -0.0473694925,
         0.0358113454,
         0.0265403713,
        -0.0114504169,
        -0.0139750309,
         0.0079767115,
         0.0141130135,
         0.0001688893,
        -0.0084214825,
    },
    {
        -0.0084206567,          /* Filter 138 */
         0.0071405400,
         0.0148142145,
        -0.0015858941,
        -0.0181476627,
         0.0028384123,
         0.0394548085,
         0.0112246249,
        -0.1006181213,
        -0.1562444327,
         0.0433294902,
         0.5159670651,
         0.9938335593,
         1.1261566915,
         0.8088841069,
         0.2871472226,
        -0.0833296841,
        -0.1529477156,
        -0.0467402225,
         0.0359850512,
         0.0263364621,
        -0.0115786884,
        -0.0138864430,
         0.0080749152,
         0.0140750705,
         0.0000884333,
        -0.0084206567,
    },
    {
        -0.0084198310,          /* Filter 139 */
         0.0072227785,
         0.0147917392,
        -0.0017108518,
        -0.0181541619,
         0.0030453068,
         0.0395468952,
         0.0108109106,
        -0.1012388084,
        -0.1560053732,
         0.0451967228,
         0.5187704467,
         0.9956694743,
         1.1255981821,
         0.8063752082,
         0.2845625427,
        -0.0844682133,
        -0.1526644760,
        -0.0461109524,
         0.0361587569,
         0.0261325528,
        -0.0117069598,
        -0.0137978550,
         0.0081731188,
         0.0140371276,
         0.0000079772,
        -0.0084198310,
    },
    {
        -0.0084190052,          /* Filter 140 */
         0.0073050171,
         0.0147692639,
        -0.0018358095,
        -0.0181606611,
         0.0032522013,
         0.0396389819,
         0.0103971963,
        -0.1018594956,
        -0.1557663137,
         0.0470639554,
         0.5215738282,
         0.9975053893,
         1.1250396727,
         0.8038663095,
         0.2819778628,
        -0.0856067424,
        -0.1523812363,
        -0.0454816823,
         0.0363324626,
         0.0259286435,
        -0.0118352313,
        -0.0137092670,
         0.0082713225,
         0.0139991847,
        -0.0000724789,
        -0.0084190052,
    },
    {
        -0.0084162732,          /* Filter 141 */
         0.0073865376,
         0.0147436925,
        -0.0019609366,
        -0.0181624126,
         0.0034614352,
         0.0397233560,
         0.0099727451,
        -0.1024745913,
        -0.1554975469,
         0.0489637030,
         0.5243782755,
         0.9993009082,
         1.1244288244,
         0.8013345616,
         0.2794121900,
        -0.0867097673,
        -0.1520785217,
        -0.0448566378,
         0.0364947790,
         0.0257218890,
        -0.0119587410,
        -0.0136178226,
         0.0083673121,
         0.0139587762,
        -0.0001521007,
        -0.0084162732,
    },
    {
        -0.0084135412,          /* Filter 142 */
         0.0074680581,
         0.0147181210,
        -0.0020860637,
        -0.0181641642,
         0.0036706691,
         0.0398077301,
         0.0095482939,
        -0.1030896870,
        -0.1552287801,
         0.0508634507,
         0.5271827229,
         1.0010964271,
         1.1238179760,
         0.7988028136,
         0.2768465172,
        -0.0878127922,
        -0.1517758070,
        -0.0442315934,
         0.0366570954,
         0.0255151345,
        -0.0120822508,
        -0.0135263781,
         0.0084633017,
         0.0139183676,
        -0.0002317225,
        -0.0084135412,
    },
    {
        -0.0084108092,          /* Filter 143 */
         0.0075495786,
         0.0146925495,
        -0.0022111908,
        -0.0181659157,
         0.0038799031,
         0.0398921042,
         0.0091238428,
        -0.1037047827,
        -0.1549600134,
         0.0527631983,
         0.5299871702,
         1.0028919459,
         1.1232071276,
         0.7962710656,
         0.2742808445,
        -0.0889158172,
        -0.1514730924,
        -0.0436065490,
         0.0368194119,
         0.0253083800,
        -0.0122057605,
        -0.0134349336,
         0.0085592912,
         0.0138779590,
        -0.0003113444,
        -0.0084108092,
    },
    {
        -0.0084080772,          /* Filter 144 */
         0.0076310991,
         0.0146669781,
        -0.0023363179,
        -0.0181676672,
         0.0040891370,
         0.0399764783,
         0.0086993916,
        -0.1043198784,
        -0.1546912466,
         0.0546629459,
         0.5327916175,
         1.0046874648,
         1.1225962793,
         0.7937393177,
         0.2717151717,
        -0.0900188421,
        -0.1511703778,
        -0.0429815045,
         0.0369817283,
         0.0251016255,
        -0.0123292702,
        -0.0133434892,
         0.0086552808,
         0.0138375505,
        -0.0003909662,
        -0.0084080772,
    },
    {
        -0.0084034591,          /* Filter 145 */
         0.0077118264,
         0.0146383099,
        -0.0024615020,
        -0.0181646186,
         0.0043005496,
         0.0400529394,
         0.0082643366,
        -0.1049288709,
        -0.1543923977,
         0.0565948832,
         0.5355962280,
         1.0064419225,
         1.1219333234,
         0.7911856159,
         0.2691692038,
        -0.0910864123,
        -0.1508487156,
        -0.0423610491,
         0.0371327210,
         0.0248922515,
        -0.0124479620,
        -0.0132492987,
         0.0087489883,
         0.0137947290,
        -0.0004696930,
        -0.0084034591,
    },
    {
        -0.0083988409,          /* Filter 146 */
         0.0077925538,
         0.0146096417,
        -0.0025866862,
        -0.0181615700,
         0.0045119622,
         0.0401294005,
         0.0078292816,
        -0.1055378633,
        -0.1540935488,
         0.0585268205,
         0.5384008385,
         1.0081963802,
         1.1212703674,
         0.7886319141,
         0.2666232359,
        -0.0921539825,
        -0.1505270533,
        -0.0417405937,
         0.0372837136,
         0.0246828775,
        -0.0125666538,
        -0.0131551082,
         0.0088426959,
         0.0137519074,
        -0.0005484199,
        -0.0083988409,
    },
    {
        -0.0083942228,          /* Filter 147 */
         0.0078732811,
         0.0145809736,
        -0.0027118704,
        -0.0181585214,
         0.0047233748,
         0.0402058615,
         0.0073942266,
        -0.1061468558,
        -0.1537946998,
         0.0604587578,
         0.5412054490,
         1.0099508380,
         1.1206074115,
         0.7860782123,
         0.2640772680,
        -0.0932215526,
        -0.1502053910,
        -0.0411201383,
         0.0374347062,
         0.0244735035,
        -0.0126853455,
        -0.0130609178,
         0.0089364034,
         0.0137090859,
        -0.0006271468,
        -0.0083942228,
    },
    {
        -0.0083896047,          /* Filter 148 */
         0.0079540084,
         0.0145523054,
        -0.0028370545,
        -0.0181554728,
         0.0049347874,
         0.0402823226,
         0.0069591716,
        -0.1067558483,
        -0.1534958509,
         0.0623906951,
         0.5440100595,
         1.0117052957,
         1.1199444556,
         0.7835245105,
         0.2615313001,
        -0.0942891228,
        -0.1498837288,
        -0.0404996829,
         0.0375856989,
         0.0242641295,
        -0.0128040373,
        -0.0129667273,
         0.0090301109,
         0.0136662644,
        -0.0007058736,
        -0.0083896047,
    },
    {
        -0.0083831221,          /* Filter 149 */
         0.0080338675,
         0.0145205425,
        -0.0029621824,
        -0.0181475753,
         0.0051482140,
         0.0403506736,
         0.0065136553,
        -0.1073582218,
        -0.1531665552,
         0.0643544803,
         0.5468139260,
         1.0134180415,
         1.1192296431,
         0.7809497556,
         0.2590057222,
        -0.0953213029,
        -0.1495436493,
        -0.0398841716,
         0.0377254405,
         0.0240523607,
        -0.0129178597,
        -0.0128699026,
         0.0091214711,
         0.0136210843,
        -0.0007836460,
        -0.0083831221,
    },
    {
        -0.0083766394,          /* Filter 150 */
         0.0081137266,
         0.0144887797,
        -0.0030873103,
        -0.0181396778,
         0.0053616406,
         0.0404190246,
         0.0060681390,
        -0.1079605953,
        -0.1528372594,
         0.0663182654,
         0.5496177925,
         1.0151307873,
         1.1185148306,
         0.7783750007,
         0.2564801443,
        -0.0963534830,
        -0.1492035698,
        -0.0392686603,
         0.0378651821,
         0.0238405920,
        -0.0130316821,
        -0.0127730779,
         0.0092128313,
         0.0135759042,
        -0.0008614184,
        -0.0083766394,
    },
    {
        -0.0083701567,          /* Filter 151 */
         0.0081935858,
         0.0144570168,
        -0.0032124381,
        -0.0181317803,
         0.0055750672,
         0.0404873756,
         0.0056226226,
        -0.1085629689,
        -0.1525079637,
         0.0682820506,
         0.5524216589,
         1.0168435331,
         1.1178000180,
         0.7758002457,
         0.2539545665,
        -0.0973856632,
        -0.1488634904,
        -0.0386531490,
         0.0380049238,
         0.0236288232,
        -0.0131455046,
        -0.0126762532,
         0.0093041915,
         0.0135307242,
        -0.0009391908,
        -0.0083701567,
    },
    {
        -0.0083636741,          /* Filter 152 */
         0.0082734449,
         0.0144252539,
        -0.0033375660,
        -0.0181238828,
         0.0057884938,
         0.0405557266,
         0.0051771063,
        -0.1091653424,
        -0.1521786680,
         0.0702458358,
         0.5552255254,
         1.0185562789,
         1.1170852055,
         0.7732254908,
         0.2514289886,
        -0.0984178433,
        -0.1485234109,
        -0.0380376377,
         0.0381446654,
         0.0234170544,
        -0.0132593270,
        -0.0125794285,
         0.0093955517,
         0.0134855441,
        -0.0010169632,
        -0.0083636741,
    },
    {
        -0.0083553500,          /* Filter 153 */
         0.0083523609,
         0.0143904012,
        -0.0034625233,
        -0.0181110913,
         0.0060037659,
         0.0406157739,
         0.0047212807,
        -0.1097605776,
        -0.1518185712,
         0.0722411107,
         0.5580277364,
         1.0202266767,
         1.1163188069,
         0.7706305883,
         0.2489244731,
        -0.0994147134,
        -0.1481654471,
        -0.0374274171,
         0.0382732360,
         0.0232031144,
        -0.0133682335,
        -0.0124800826,
         0.0094845018,
         0.0134380614,
        -0.0010937229,
        -0.0083553500,
    },
    {
        -0.0083470259,          /* Filter 154 */
         0.0084312770,
         0.0143555485,
        -0.0035874805,
        -0.0180982998,
         0.0062190379,
         0.0406758213,
         0.0042654550,
        -0.1103558127,
        -0.1514584744,
         0.0742363857,
         0.5608299474,
         1.0218970744,
         1.1155524083,
         0.7680356859,
         0.2464199576,
        -0.1004115835,
        -0.1478074833,
        -0.0368171965,
         0.0384018067,
         0.0229891745,
        -0.0134771399,
        -0.0123807366,
         0.0095734519,
         0.0133905787,
        -0.0011704827,
        -0.0083470259,
    },
    {
        -0.0083387019,          /* Filter 155 */
         0.0085101930,
         0.0143206958,
        -0.0037124377,
        -0.0180855083,
         0.0064343100,
         0.0407358686,
         0.0038096294,
        -0.1109510478,
        -0.1510983776,
         0.0762316606,
         0.5636321583,
         1.0235674721,
         1.1147860096,
         0.7654407834,
         0.2439154420,
        -0.1014084535,
        -0.1474495196,
        -0.0362069758,
         0.0385303773,
         0.0227752346,
        -0.0135860464,
        -0.0122813907,
         0.0096624020,
         0.0133430961,
        -0.0012472424,
        -0.0083387019,
    },
    {
        -0.0083303778,          /* Filter 156 */
         0.0085891090,
         0.0142858431,
        -0.0038373950,
        -0.0180727168,
         0.0066495821,
         0.0407959159,
         0.0033538037,
        -0.1115462830,
        -0.1507382808,
         0.0782269355,
         0.5664343693,
         1.0252378699,
         1.1140196110,
         0.7628458810,
         0.2414109265,
        -0.1024053236,
        -0.1470915558,
        -0.0355967552,
         0.0386589480,
         0.0225612946,
        -0.0136949529,
        -0.0121820448,
         0.0097513521,
         0.0132956134,
        -0.0013240021,
        -0.0083303778,
    },
    {
        -0.0083202368,          /* Filter 157 */
         0.0086670073,
         0.0142479081,
        -0.0039620663,
        -0.0180549900,
         0.0068665274,
         0.0408474696,
         0.0028878302,
        -0.1121338569,
        -0.1503470394,
         0.0802533257,
         0.5692340095,
         1.0268652984,
         1.1132019161,
         0.7602317411,
         0.2389281325,
        -0.1033669786,
        -0.1467162430,
        -0.0349921631,
         0.0387764347,
         0.0223454057,
        -0.0137989015,
        -0.0120802917,
         0.0098378320,
         0.0132458857,
        -0.0013996923,
        -0.0083202368,
    },
    {
        -0.0083100959,          /* Filter 158 */
         0.0087449056,
         0.0142099731,
        -0.0040867377,
        -0.0180372632,
         0.0070834727,
         0.0408990232,
         0.0024218567,
        -0.1127214308,
        -0.1499557981,
         0.0822797160,
         0.5720336496,
         1.0284927270,
         1.1123842213,
         0.7576176012,
         0.2364453385,
        -0.1043286335,
        -0.1463409303,
        -0.0343875711,
         0.0388939214,
         0.0221295169,
        -0.0139028502,
        -0.0119785386,
         0.0099243119,
         0.0131961579,
        -0.0014753825,
        -0.0083100959,
    },
    {
        -0.0082999550,          /* Filter 159 */
         0.0088228040,
         0.0141720380,
        -0.0042114090,
        -0.0180195365,
         0.0073004179,
         0.0409505768,
         0.0019558832,
        -0.1133090048,
        -0.1495645568,
         0.0843061062,
         0.5748332898,
         1.0301201555,
         1.1115665265,
         0.7550034614,
         0.2339625446,
        -0.1052902885,
        -0.1459656175,
        -0.0337829790,
         0.0390114081,
         0.0219136281,
        -0.0140067989,
        -0.0118767855,
         0.0100107918,
         0.0131464301,
        -0.0015510728,
        -0.0082999550,
    },
    {
        -0.0082898140,          /* Filter 160 */
         0.0089007023,
         0.0141341030,
        -0.0043360803,
        -0.0180018097,
         0.0075173632,
         0.0410021305,
         0.0014899097,
        -0.1138965787,
        -0.1491733154,
         0.0863324965,
         0.5776329299,
         1.0317475841,
         1.1107488316,
         0.7523893215,
         0.2314797506,
        -0.1062519435,
        -0.1455903047,
        -0.0331783869,
         0.0391288948,
         0.0216977392,
        -0.0141107475,
        -0.0117750324,
         0.0100972717,
         0.0130967024,
        -0.0016267630,
        -0.0082898140,
    },
    {
        -0.0082778821,          /* Filter 161 */
         0.0089775086,
         0.0140930960,
        -0.0044603497,
        -0.0179791102,
         0.0077358057,
         0.0410450044,
         0.0010139594,
        -0.1144759654,
        -0.1487505969,
         0.0883896114,
         0.5804290805,
         1.0333314375,
         1.1098801496,
         0.7497568583,
         0.2290193240,
        -0.1071784933,
        -0.1451981802,
        -0.0325797525,
         0.0392353915,
         0.0214801224,
        -0.0142097012,
        -0.0116709872,
         0.0101812239,
         0.0130447886,
        -0.0017013282,
        -0.0082778821,
    },
    {
        -0.0082659503,          /* Filter 162 */
         0.0090543149,
         0.0140520889,
        -0.0045846191,
        -0.0179564107,
         0.0079542483,
         0.0410878783,
         0.0005380091,
        -0.1150553521,
        -0.1483278784,
         0.0904467264,
         0.5832252311,
         1.0349152908,
         1.1090114676,
         0.7471243951,
         0.2265588975,
        -0.1081050431,
        -0.1448060556,
        -0.0319811182,
         0.0393418882,
         0.0212625055,
        -0.0143086549,
        -0.0115669419,
         0.0102651761,
         0.0129928749,
        -0.0017758935,
        -0.0082659503,
    },
    {
        -0.0082540185,          /* Filter 163 */
         0.0091311211,
         0.0140110819,
        -0.0047088885,
        -0.0179337113,
         0.0081726908,
         0.0411307521,
         0.0000620587,
        -0.1156347387,
        -0.1479051599,
         0.0925038414,
         0.5860213816,
         1.0364991441,
         1.1081427855,
         0.7444919319,
         0.2240984709,
        -0.1090315928,
        -0.1444139311,
        -0.0313824838,
         0.0394483848,
         0.0210448887,
        -0.0144076086,
        -0.0114628967,
         0.0103491284,
         0.0129409612,
        -0.0018504587,
        -0.0082540185,
    },
    {
        -0.0082420866,          /* Filter 164 */
         0.0092079274,
         0.0139700749,
        -0.0048331579,
        -0.0179110118,
         0.0083911333,
         0.0411736260,
        -0.0004138916,
        -0.1162141254,
        -0.1474824414,
         0.0945609563,
         0.5888175322,
         1.0380829975,
         1.1072741035,
         0.7418594687,
         0.2216380443,
        -0.1099581426,
        -0.1440218066,
        -0.0307838494,
         0.0395548815,
         0.0208272719,
        -0.0145065623,
        -0.0113588515,
         0.0104330806,
         0.0128890474,
        -0.0019250239,
        -0.0082420866,
    },
    {
        -0.0082283912,          /* Filter 165 */
         0.0092835676,
         0.0139260090,
        -0.0049569085,
        -0.0178833062,
         0.0086108936,
         0.0412076380,
        -0.0008996382,
        -0.1167847959,
        -0.1470279245,
         0.0966483892,
         0.5916092714,
         1.0396226852,
         1.1063547626,
         0.7392096000,
         0.2192006174,
        -0.1108497118,
        -0.1436134093,
        -0.0301914931,
         0.0396504889,
         0.0206081464,
        -0.0146004886,
        -0.0112526301,
         0.0105144504,
         0.0128350080,
        -0.0019984100,
        -0.0082283912,
    },
    {
        -0.0082146959,          /* Filter 166 */
         0.0093592079,
         0.0138819430,
        -0.0050806591,
        -0.0178556005,
         0.0088306538,
         0.0412416500,
        -0.0013853848,
        -0.1173554664,
        -0.1465734077,
         0.0987358221,
         0.5944010105,
         1.0411623729,
         1.1054354216,
         0.7365597312,
         0.2167631905,
        -0.1117412809,
        -0.1432050120,
        -0.0295991367,
         0.0397460963,
         0.0203890209,
        -0.0146944149,
        -0.0111464087,
         0.0105958202,
         0.0127809687,
        -0.0020717962,
        -0.0082146959,
    },
    {
        -0.0082010005,          /* Filter 167 */
         0.0094348481,
         0.0138378770,
        -0.0052044097,
        -0.0178278949,
         0.0090504141,
         0.0412756620,
        -0.0018711315,
        -0.1179261368,
        -0.1461188909,
         0.1008232550,
         0.5971927497,
         1.0427020605,
         1.1045160806,
         0.7339098625,
         0.2143257637,
        -0.1126328501,
        -0.1427966148,
        -0.0290067804,
         0.0398417036,
         0.0201698953,
        -0.0147883412,
        -0.0110401874,
         0.0106771900,
         0.0127269293,
        -0.0021451824,
        -0.0082010005,
    },
    {
        -0.0081873051,          /* Filter 168 */
         0.0095104884,
         0.0137938111,
        -0.0053281603,
        -0.0178001892,
         0.0092701743,
         0.0413096740,
        -0.0023568781,
        -0.1184968073,
        -0.1456643740,
         0.1029106879,
         0.5999844889,
         1.0442417482,
         1.1035967397,
         0.7312599938,
         0.2118883368,
        -0.1135244193,
        -0.1423882175,
        -0.0284144241,
         0.0399373110,
         0.0199507698,
        -0.0148822675,
        -0.0109339660,
         0.0107585598,
         0.0126728899,
        -0.0022185685,
        -0.0081873051,
    },
    {
        -0.0081718749,          /* Filter 169 */
         0.0095848891,
         0.0137467021,
        -0.0054512747,
        -0.0177674479,
         0.0094910693,
         0.0413346462,
        -0.0028522309,
        -0.1190582300,
        -0.1451777490,
         0.1050280159,
         0.6027708922,
         1.0457366955,
         1.1026270869,
         0.7285936405,
         0.2094745282,
        -0.1143811470,
        -0.1419640879,
        -0.0278286572,
         0.0400221364,
         0.0197303531,
        -0.0149711387,
        -0.0108256852,
         0.0108372951,
         0.0126167868,
        -0.0022907229,
        -0.0081718749,
    },
    {
        -0.0081564448,          /* Filter 170 */
         0.0096592897,
         0.0136995931,
        -0.0055743891,
        -0.0177347066,
         0.0097119643,
         0.0413596184,
        -0.0033475838,
        -0.1196196527,
        -0.1446911239,
         0.1071453439,
         0.6055572955,
         1.0472316428,
         1.1016574340,
         0.7259272872,
         0.2070607195,
        -0.1152378747,
        -0.1415399582,
        -0.0272428903,
         0.0401069617,
         0.0195099365,
        -0.0150600100,
        -0.0107174044,
         0.0109160303,
         0.0125606836,
        -0.0023628774,
        -0.0081564448,
    },
    {
        -0.0081410146,          /* Filter 171 */
         0.0097336904,
         0.0136524840,
        -0.0056975035,
        -0.0177019653,
         0.0099328593,
         0.0413845907,
        -0.0038429366,
        -0.1201810753,
        -0.1442044989,
         0.1092626720,
         0.6083436989,
         1.0487265902,
         1.1006877812,
         0.7232609339,
         0.2046469108,
        -0.1160946025,
        -0.1411158285,
        -0.0266571235,
         0.0401917871,
         0.0192895198,
        -0.0151488812,
        -0.0106091236,
         0.0109947656,
         0.0125045805,
        -0.0024350318,
        -0.0081410146,
    },
    {
        -0.0081255844,          /* Filter 172 */
         0.0098080911,
         0.0136053750,
        -0.0058206179,
        -0.0176692240,
         0.0101537543,
         0.0414095629,
        -0.0043382895,
        -0.1207424980,
        -0.1437178738,
         0.1113800000,
         0.6111301022,
         1.0502215375,
         1.0997181284,
         0.7205945806,
         0.2022331022,
        -0.1169513302,
        -0.1406916989,
        -0.0260713566,
         0.0402766124,
         0.0190691031,
        -0.0152377524,
        -0.0105008428,
         0.0110735009,
         0.0124484774,
        -0.0025071863,
        -0.0081255844,
    },
    {
        -0.0081084495,          /* Filter 173 */
         0.0098811792,
         0.0135552415,
        -0.0059429781,
        -0.0176314216,
         0.0103755977,
         0.0414253219,
        -0.0048430490,
        -0.1212941389,
        -0.1431988426,
         0.1135267845,
         0.6139102430,
         1.0516711859,
         1.0986985296,
         0.7179126665,
         0.1998435162,
        -0.1177733700,
        -0.1402523783,
        -0.0254924816,
         0.0403507694,
         0.0188476109,
        -0.0153215454,
        -0.0103906199,
         0.0111495523,
         0.0123903736,
        -0.0025780580,
        -0.0081084495,
    },
    {
        -0.0080913145,          /* Filter 174 */
         0.0099542672,
         0.0135051081,
        -0.0060653383,
        -0.0175936193,
         0.0105974410,
         0.0414410808,
        -0.0053478084,
        -0.1218457798,
        -0.1426798114,
         0.1156735689,
         0.6166903838,
         1.0531208343,
         1.0976789308,
         0.7152307524,
         0.1974539303,
        -0.1185954098,
        -0.1398130578,
        -0.0249136066,
         0.0404249265,
         0.0186261188,
        -0.0154053385,
        -0.0102803970,
         0.0112256038,
         0.0123322698,
        -0.0026489296,
        -0.0080913145,
    },
    {
        -0.0080741796,          /* Filter 175 */
         0.0100273553,
         0.0134549746,
        -0.0061876986,
        -0.0175558169,
         0.0108192844,
         0.0414568398,
        -0.0058525679,
        -0.1223974207,
        -0.1421607801,
         0.1178203534,
         0.6194705246,
         1.0545704826,
         1.0966593320,
         0.7125488383,
         0.1950643444,
        -0.1194174496,
        -0.1393737373,
        -0.0243347316,
         0.0404990835,
         0.0184046266,
        -0.0154891315,
        -0.0101701741,
         0.0113016552,
         0.0122741660,
        -0.0027198013,
        -0.0080741796,
    },
    {
        -0.0080570447,          /* Filter 176 */
         0.0101004434,
         0.0134048412,
        -0.0063100588,
        -0.0175180145,
         0.0110411278,
         0.0414725987,
        -0.0063573274,
        -0.1229490616,
        -0.1416417489,
         0.1199671379,
         0.6222506654,
         1.0560201310,
         1.0956397332,
         0.7098669242,
         0.1926747584,
        -0.1202394894,
        -0.1389344167,
        -0.0237558566,
         0.0405732405,
         0.0181831345,
        -0.0155729245,
        -0.0100599512,
         0.0113777066,
         0.0122160622,
        -0.0027906730,
        -0.0080570447,
    },
    {
        -0.0080382364,          /* Filter 177 */
         0.0101721464,
         0.0133517048,
        -0.0064315464,
        -0.0174751298,
         0.0112637299,
         0.0414789754,
        -0.0068712844,
        -0.1234903846,
        -0.1410900254,
         0.1221429243,
         0.6250236152,
         1.0574239382,
         1.0945705729,
         0.7071703754,
         0.1903099855,
        -0.1210270090,
        -0.1384804475,
        -0.0231841667,
         0.0406368492,
         0.0179607805,
        -0.0156516210,
        -0.0099479042,
         0.0114510276,
         0.0121560221,
        -0.0028602122,
        -0.0080382364,
    },
    {
        -0.0080194281,          /* Filter 178 */
         0.0102438494,
         0.0132985683,
        -0.0065530340,
        -0.0174322452,
         0.0114863321,
         0.0414853522,
        -0.0073852414,
        -0.1240317076,
        -0.1405383020,
         0.1243187106,
         0.6277965649,
         1.0588277453,
         1.0935014125,
         0.7044738266,
         0.1879452126,
        -0.1218145285,
        -0.1380264784,
        -0.0226124769,
         0.0407004580,
         0.0177384266,
        -0.0157303174,
        -0.0098358572,
         0.0115243486,
         0.0120959820,
        -0.0029297514,
        -0.0080194281,
    },
    {
        -0.0080006198,          /* Filter 179 */
         0.0103155524,
         0.0132454319,
        -0.0066745217,
        -0.0173893605,
         0.0117089343,
         0.0414917289,
        -0.0078991983,
        -0.1245730307,
        -0.1399865786,
         0.1264944970,
         0.6305695147,
         1.0602315525,
         1.0924322522,
         0.7017772778,
         0.1855804396,
        -0.1226020481,
        -0.1375725092,
        -0.0220407870,
         0.0407640667,
         0.0175160726,
        -0.0158090139,
        -0.0097238102,
         0.0115976695,
         0.0120359418,
        -0.0029992907,
        -0.0080006198,
    },
    {
        -0.0079818115,          /* Filter 180 */
         0.0103872554,
         0.0131922955,
        -0.0067960093,
        -0.0173464758,
         0.0119315364,
         0.0414981056,
        -0.0084131553,
        -0.1251143537,
        -0.1394348551,
         0.1286702834,
         0.6333424645,
         1.0616353597,
         1.0913630919,
         0.6990807290,
         0.1832156667,
        -0.1233895677,
        -0.1371185400,
        -0.0214690972,
         0.0408276754,
         0.0172937187,
        -0.0158877103,
        -0.0096117632,
         0.0116709905,
         0.0119759017,
        -0.0030688299,
        -0.0079818115,
    },
    {
        -0.0079613624,          /* Filter 181 */
         0.0104575015,
         0.0131361803,
        -0.0069165056,
        -0.0172984917,
         0.0121547045,
         0.0414949359,
        -0.0089360912,
        -0.1256448209,
        -0.1388501656,
         0.1308746015,
         0.6361072934,
         1.0629927999,
         1.0902447728,
         0.6963704736,
         0.1808762827,
        -0.1241427487,
        -0.1366504649,
        -0.0209048767,
         0.0408808619,
         0.0170707144,
        -0.0159612963,
        -0.0094980105,
         0.0117415372,
         0.0119139907,
        -0.0031369887,
        -0.0079613624,
    },
    {
        -0.0079409132,          /* Filter 182 */
         0.0105277476,
         0.0130800652,
        -0.0070370019,
        -0.0172505076,
         0.0123778727,
         0.0414917662,
        -0.0094590271,
        -0.1261752882,
        -0.1382654762,
         0.1330789196,
         0.6388721222,
         1.0643502402,
         1.0891264538,
         0.6936602182,
         0.1785368986,
        -0.1248959297,
        -0.1361823898,
        -0.0203406562,
         0.0409340485,
         0.0168477102,
        -0.0160348823,
        -0.0093842577,
         0.0118120839,
         0.0118520798,
        -0.0032051475,
        -0.0079409132,
    },
    {
        -0.0079204640,          /* Filter 183 */
         0.0105979936,
         0.0130239501,
        -0.0071574981,
        -0.0172025235,
         0.0126010409,
         0.0414885965,
        -0.0099819630,
        -0.1267057555,
        -0.1376807868,
         0.1352832377,
         0.6416369510,
         1.0657076804,
         1.0880081347,
         0.6909499628,
         0.1761975146,
        -0.1256491108,
        -0.1357143147,
        -0.0197764357,
         0.0409872351,
         0.0166247059,
        -0.0161084683,
        -0.0092705050,
         0.0118826305,
         0.0117901689,
        -0.0032733062,
        -0.0079204640,
    },
    {
        -0.0079000149,          /* Filter 184 */
         0.0106682397,
         0.0129678349,
        -0.0072779944,
        -0.0171545394,
         0.0128242090,
         0.0414854268,
        -0.0105048989,
        -0.1272362227,
        -0.1370960973,
         0.1374875558,
         0.6444017799,
         1.0670651207,
         1.0868898157,
         0.6882397074,
         0.1738581306,
        -0.1264022918,
        -0.1352462396,
        -0.0192122152,
         0.0410404216,
         0.0164017016,
        -0.0161820543,
        -0.0091567523,
         0.0119531772,
         0.0117282579,
        -0.0033414650,
        -0.0079000149,
    },
    {
        -0.0078779587,          /* Filter 185 */
         0.0107369577,
         0.0129087681,
        -0.0073973803,
        -0.0171014431,
         0.0130477473,
         0.0414725514,
        -0.0110365856,
        -0.1277552947,
        -0.1364781806,
         0.1397199198,
         0.6471575569,
         1.0683756853,
         1.0857227590,
         0.6855166750,
         0.1715446968,
        -0.1271213298,
        -0.1347646015,
        -0.0186557390,
         0.0410833180,
         0.0161782562,
        -0.0162505206,
        -0.0090414127,
         0.0120209086,
         0.0116645427,
        -0.0034081968,
        -0.0078779587,
    },
    {
        -0.0078559026,          /* Filter 186 */
         0.0108056758,
         0.0128497013,
        -0.0075167661,
        -0.0170483468,
         0.0132712856,
         0.0414596759,
        -0.0115682723,
        -0.1282743666,
        -0.1358602638,
         0.1419522838,
         0.6499133339,
         1.0696862498,
         1.0845557023,
         0.6827936425,
         0.1692312630,
        -0.1278403679,
        -0.1342829635,
        -0.0180992628,
         0.0411262144,
         0.0159548109,
        -0.0163189869,
        -0.0089260730,
         0.0120886399,
         0.0116008276,
        -0.0034749286,
        -0.0078559026,
    },
    {
        -0.0078338464,          /* Filter 187 */
         0.0108743939,
         0.0127906345,
        -0.0076361520,
        -0.0169952506,
         0.0134948240,
         0.0414468005,
        -0.0120999589,
        -0.1287934386,
        -0.1352423471,
         0.1441846479,
         0.6526691109,
         1.0709968144,
         1.0833886456,
         0.6800706101,
         0.1669178292,
        -0.1285594059,
        -0.1338013254,
        -0.0175427866,
         0.0411691108,
         0.0157313656,
        -0.0163874531,
        -0.0088107333,
         0.0121563712,
         0.0115371125,
        -0.0035416604,
        -0.0078338464,
    },
    {
        -0.0078117902,          /* Filter 188 */
         0.0109431119,
         0.0127315677,
        -0.0077555379,
        -0.0169421543,
         0.0137183623,
         0.0414339250,
        -0.0126316456,
        -0.1293125105,
        -0.1346244304,
         0.1464170119,
         0.6554248879,
         1.0723073790,
         1.0822215889,
         0.6773475777,
         0.1646043954,
        -0.1292784439,
        -0.1333196873,
        -0.0169863104,
         0.0412120072,
         0.0155079202,
        -0.0164559194,
        -0.0086953937,
         0.0122241026,
         0.0114733973,
        -0.0036083922,
        -0.0078117902,
    },
    {
        -0.0077897340,          /* Filter 189 */
         0.0110118299,
         0.0126725009,
        -0.0078749238,
        -0.0168890580,
         0.0139419006,
         0.0414210496,
        -0.0131633323,
        -0.1298315825,
        -0.1340065137,
         0.1486493759,
         0.6581806649,
         1.0736179436,
         1.0810545322,
         0.6746245453,
         0.1622909616,
        -0.1299974819,
        -0.1328380492,
        -0.0164298342,
         0.0412549036,
         0.0152844749,
        -0.0165243857,
        -0.0085800541,
         0.0122918340,
         0.0114096821,
        -0.0036751240,
        -0.0077897340,
    },
    {
        -0.0077676778,          /* Filter 190 */
         0.0110805480,
         0.0126134341,
        -0.0079943096,
        -0.0168359618,
         0.0141654390,
         0.0414081741,
        -0.0136950189,
        -0.1303506544,
        -0.1333885969,
         0.1508817400,
         0.6609364419,
         1.0749285081,
         1.0798874755,
         0.6719015128,
         0.1599775278,
        -0.1307165199,
        -0.1323564111,
        -0.0158733580,
         0.0412978000,
         0.0150610295,
        -0.0165928520,
        -0.0084647144,
         0.0123595653,
         0.0113459670,
        -0.0037418558,
        -0.0077676778,
    },
    {
        -0.0077456217,          /* Filter 191 */
         0.0111492661,
         0.0125543673,
        -0.0081136955,
        -0.0167828655,
         0.0143889773,
         0.0413952987,
        -0.0142267056,
        -0.1308697263,
        -0.1327706802,
         0.1531141040,
         0.6636922189,
         1.0762390727,
         1.0787204188,
         0.6691784804,
         0.1576640940,
        -0.1314355580,
        -0.1318747731,
        -0.0153168818,
         0.0413406964,
         0.0148375842,
        -0.0166613182,
        -0.0083493747,
         0.0124272966,
         0.0112822519,
        -0.0038085876,
        -0.0077456217,
    }
};
#endif

const complex_t v17_14400_constellation[128] =
{
    {-8, -3},       /* 0x00 */
    { 9,  2},       /* 0x01 */
    { 2, -9},       /* 0x02 */
    {-3,  8},       /* 0x03 */
    { 8,  3},       /* 0x04 */
    {-9, -2},       /* 0x05 */
    {-2,  9},       /* 0x06 */
    { 3, -8},       /* 0x07 */
    {-8,  1},       /* 0x08 */
    { 9, -2},       /* 0x09 */
    {-2, -9},       /* 0x0A */
    { 1,  8},       /* 0x0B */
    { 8, -1},       /* 0x0C */
    {-9,  2},       /* 0x0D */
    { 2,  9},       /* 0x0E */
    {-1, -8},       /* 0x0F */
    {-4, -3},       /* 0x10 */
    { 5,  2},       /* 0x11 */
    { 2, -5},       /* 0x12 */
    {-3,  4},       /* 0x13 */
    { 4,  3},       /* 0x14 */
    {-5, -2},       /* 0x15 */
    {-2,  5},       /* 0x16 */
    { 3, -4},       /* 0x17 */
    {-4,  1},       /* 0x18 */
    { 5, -2},       /* 0x19 */
    {-2, -5},       /* 0x1A */
    { 1,  4},       /* 0x1B */
    { 4, -1},       /* 0x1C */
    {-5,  2},       /* 0x1D */
    { 2,  5},       /* 0x1E */
    {-1, -4},       /* 0x1F */
    { 4, -3},       /* 0x20 */
    {-3,  2},       /* 0x21 */
    { 2,  3},       /* 0x22 */
    {-3, -4},       /* 0x23 */
    {-4,  3},       /* 0x24 */
    { 3, -2},       /* 0x25 */
    {-2, -3},       /* 0x26 */
    { 3,  4},       /* 0x27 */
    { 4,  1},       /* 0x28 */
    {-3, -2},       /* 0x29 */
    {-2,  3},       /* 0x2A */
    { 1, -4},       /* 0x2B */
    {-4, -1},       /* 0x2C */
    { 3,  2},       /* 0x2D */
    { 2, -3},       /* 0x2E */
    {-1,  4},       /* 0x2F */
    { 0, -3},       /* 0x30 */
    { 1,  2},       /* 0x31 */
    { 2, -1},       /* 0x32 */
    {-3,  0},       /* 0x33 */
    { 0,  3},       /* 0x34 */
    {-1, -2},       /* 0x35 */
    {-2,  1},       /* 0x36 */
    { 3,  0},       /* 0x37 */
    { 0,  1},       /* 0x38 */
    { 1, -2},       /* 0x39 */
    {-2, -1},       /* 0x3A */
    { 1,  0},       /* 0x3B */
    { 0, -1},       /* 0x3C */
    {-1,  2},       /* 0x3D */
    { 2,  1},       /* 0x3E */
    {-1,  0},       /* 0x3F */
    { 8, -3},       /* 0x40 */
    {-7,  2},       /* 0x41 */
    { 2,  7},       /* 0x42 */
    {-3, -8},       /* 0x43 */
    {-8,  3},       /* 0x44 */
    { 7, -2},       /* 0x45 */
    {-2, -7},       /* 0x46 */
    { 3,  8},       /* 0x47 */
    { 8,  1},       /* 0x48 */
    {-7, -2},       /* 0x49 */
    {-2,  7},       /* 0x4A */
    { 1, -8},       /* 0x4B */
    {-8, -1},       /* 0x4C */
    { 7,  2},       /* 0x4D */
    { 2, -7},       /* 0x4E */
    {-1,  8},       /* 0x4F */
    {-4, -7},       /* 0x50 */
    { 5,  6},       /* 0x51 */
    { 6, -5},       /* 0x52 */
    {-7,  4},       /* 0x53 */
    { 4,  7},       /* 0x54 */
    {-5, -6},       /* 0x55 */
    {-6,  5},       /* 0x56 */
    { 7, -4},       /* 0x57 */
    {-4,  5},       /* 0x58 */
    { 5, -6},       /* 0x59 */
    {-6, -5},       /* 0x5A */
    { 5,  4},       /* 0x5B */
    { 4, -5},       /* 0x5C */
    {-5,  6},       /* 0x5D */
    { 6,  5},       /* 0x5E */
    {-5, -4},       /* 0x5F */
    { 4, -7},       /* 0x60 */
    {-3,  6},       /* 0x61 */
    { 6,  3},       /* 0x62 */
    {-7, -4},       /* 0x63 */
    {-4,  7},       /* 0x64 */
    { 3, -6},       /* 0x65 */
    {-6, -3},       /* 0x66 */
    { 7,  4},       /* 0x67 */
    { 4,  5},       /* 0x68 */
    {-3, -6},       /* 0x69 */
    {-6,  3},       /* 0x6A */
    { 5, -4},       /* 0x6B */
    {-4, -5},       /* 0x6C */
    { 3,  6},       /* 0x6D */
    { 6, -3},       /* 0x6E */
    {-5,  4},       /* 0x6F */
    { 0, -7},       /* 0x70 */
    { 1,  6},       /* 0x71 */
    { 6, -1},       /* 0x72 */
    {-7,  0},       /* 0x73 */
    { 0,  7},       /* 0x74 */
    {-1, -6},       /* 0x75 */
    {-6,  1},       /* 0x76 */
    { 7,  0},       /* 0x77 */
    { 0,  5},       /* 0x78 */
    { 1, -6},       /* 0x79 */
    {-6, -1},       /* 0x7A */
    { 5,  0},       /* 0x7B */
    { 0, -5},       /* 0x7C */
    {-1,  6},       /* 0x7D */
    { 6,  1},       /* 0x7E */
    {-5,  0}        /* 0x7F */
};

const complex_t v17_12000_constellation[64] =
{
    { 7,  1},       /* 0x00 */
    {-5, -1},       /* 0x01 */
    {-1,  5},       /* 0x02 */
    { 1, -7},       /* 0x03 */
    {-7, -1},       /* 0x04 */
    { 5,  1},       /* 0x05 */
    { 1, -5},       /* 0x06 */
    {-1,  7},       /* 0x07 */
    { 3, -3},       /* 0x08 */
    {-1,  3},       /* 0x09 */
    { 3,  1},       /* 0x0A */
    {-3, -3},       /* 0x0B */
    {-3,  3},       /* 0x0C */
    { 1, -3},       /* 0x0D */
    {-3, -1},       /* 0x0E */
    { 3,  3},       /* 0x0F */
    { 7, -7},       /* 0x10 */
    {-5,  7},       /* 0x11 */
    { 7,  5},       /* 0x12 */
    {-7, -7},       /* 0x13 */
    {-7,  7},       /* 0x14 */
    { 5, -7},       /* 0x15 */
    {-7, -5},       /* 0x16 */
    { 7,  7},       /* 0x17 */
    {-1, -7},       /* 0x18 */
    { 3,  7},       /* 0x19 */
    { 7, -3},       /* 0x1A */
    {-7,  1},       /* 0x1B */
    { 1,  7},       /* 0x1C */
    {-3, -7},       /* 0x1D */
    {-7,  3},       /* 0x1E */
    { 7, -1},       /* 0x1F */
    { 3,  5},       /* 0x20 */
    {-1, -5},       /* 0x21 */
    {-5,  1},       /* 0x22 */
    { 5, -3},       /* 0x23 */
    {-3, -5},       /* 0x24 */
    { 1,  5},       /* 0x25 */
    { 5, -1},       /* 0x26 */
    {-5,  3},       /* 0x27 */
    {-1,  1},       /* 0x28 */
    { 3, -1},       /* 0x29 */
    {-1, -3},       /* 0x2A */
    { 1,  1},       /* 0x2B */
    { 1, -1},       /* 0x2C */
    {-3,  1},       /* 0x2D */
    { 1,  3},       /* 0x2E */
    {-1, -1},       /* 0x2F */
    {-5,  5},       /* 0x30 */
    { 7, -5},       /* 0x31 */
    {-5, -7},       /* 0x32 */
    { 5,  5},       /* 0x33 */
    { 5, -5},       /* 0x34 */
    {-7,  5},       /* 0x35 */
    { 5,  7},       /* 0x36 */
    {-5, -5},       /* 0x37 */
    {-5, -3},       /* 0x38 */
    { 7,  3},       /* 0x39 */
    { 3, -7},       /* 0x3A */
    {-3,  5},       /* 0x3B */
    { 5,  3},       /* 0x3C */
    {-7, -3},       /* 0x3D */
    {-3,  7},       /* 0x3E */
    { 3, -5}        /* 0x3F */
};

const complex_t v17_9600_constellation[32] =
{
    {-8,  2},       /* 0x00 */
    {-6, -4},       /* 0x01 */
    {-4,  6},       /* 0x02 */
    { 2,  8},       /* 0x03 */
    { 8, -2},       /* 0x04 */
    { 6,  4},       /* 0x05 */
    { 4, -6},       /* 0x06 */
    {-2, -8},       /* 0x07 */
    { 0,  2},       /* 0x08 */
    {-6,  4},       /* 0x09 */
    { 4,  6},       /* 0x0A */
    { 2,  0},       /* 0x0B */
    { 0, -2},       /* 0x0C */
    { 6, -4},       /* 0x0D */
    {-4, -6},       /* 0x0E */
    {-2,  0},       /* 0x0F */
    { 0, -6},       /* 0x10 */
    { 2, -4},       /* 0x11 */
    {-4, -2},       /* 0x12 */
    {-6,  0},       /* 0x13 */
    { 0,  6},       /* 0x14 */
    {-2,  4},       /* 0x15 */
    { 4,  2},       /* 0x16 */
    { 6,  0},       /* 0x17 */
    { 8,  2},       /* 0x18 */
    { 2,  4},       /* 0x19 */
    { 4, -2},       /* 0x1A */
    { 2, -8},       /* 0x1B */
    {-8, -2},       /* 0x1C */
    {-2, -4},       /* 0x1D */
    {-4,  2},       /* 0x1E */
    {-2,  8}        /* 0x1F */
};

const complex_t v17_7200_constellation[16] =
{
    { 6, -6},       /* 0x00 */
    {-2,  6},       /* 0x01 */
    { 6,  2},       /* 0x02 */
    {-6, -6},       /* 0x03 */
    {-6,  6},       /* 0x04 */
    { 2, -6},       /* 0x05 */
    {-6, -2},       /* 0x06 */
    { 6,  6},       /* 0x07 */
    {-2,  2},       /* 0x08 */
    { 6, -2},       /* 0x09 */
    {-2, -6},       /* 0x0A */
    { 2,  2},       /* 0x0B */
    { 2, -2},       /* 0x0C */
    {-6,  2},       /* 0x0D */
    { 2,  6},       /* 0x0E */
    {-2, -2}        /* 0x0F */
};

float v17_rx_carrier_frequency(v17_rx_state_t *s)
{
    return s->carrier_phase_rate*(float) SAMPLE_RATE/(65536.0*65536.0);
}
/*- End of function --------------------------------------------------------*/

float v17_rx_symbol_timing_correction(v17_rx_state_t *s)
{
    return s->gardner_total_correction;
}
/*- End of function --------------------------------------------------------*/

float v17_rx_signal_power(v17_rx_state_t *s)
{
    return power_meter_dbm0(&s->power);
}
/*- End of function --------------------------------------------------------*/

int v17_rx_equalizer_state(v17_rx_state_t *s, complex_t **coeffs)
{
    *coeffs = s->eq_coeff;
    return 2*V17_EQUALIZER_LEN + 1;
}
/*- End of function --------------------------------------------------------*/

static void equalizer_save(v17_rx_state_t *s)
{
    int i;

    for (i = 0;  i < 2*V17_EQUALIZER_LEN + 1;  i++)
        s->eq_coeff_save[i] = s->eq_coeff[i];
}
/*- End of function --------------------------------------------------------*/

static void equalizer_restore(v17_rx_state_t *s)
{
    int i;

    for (i = 0;  i < 2*V17_EQUALIZER_LEN + 1;  i++)
        s->eq_coeff[i] = s->eq_coeff_save[i];
}
/*- End of function --------------------------------------------------------*/

static void equalizer_reset(v17_rx_state_t *s, float delta)
{
    int i;

    /* Start with an equalizer based on everything being perfect */
    for (i = 0;  i < 2*V17_EQUALIZER_LEN + 1;  i++)
        s->eq_coeff[i] = complex_set(0.0, 0.0);
    s->eq_coeff[V17_EQUALIZER_LEN] = complex_set(3.0, 0.0);
    for (i = 0;  i <= V17_EQUALIZER_MASK;  i++)
        s->eq_buf[i] = complex_set(0.0, 0.0);

    s->eq_put_step = 320 - 1;
    s->eq_step = 0;
    s->eq_delta = delta/(2*V17_EQUALIZER_LEN + 1);
}
/*- End of function --------------------------------------------------------*/

static inline complex_t equalizer_get(v17_rx_state_t *s)
{
    int i;
    int p;
    complex_t z;
    complex_t z1;

    /* Get the next equalized value. */
    z = complex_set(0.0, 0.0);
    for (i = 0;  i < 2*V17_EQUALIZER_LEN + 1;  i++)
    {
        p = (s->eq_step + i) & V17_EQUALIZER_MASK;
        z1 = complex_mul(&s->eq_coeff[i], &s->eq_buf[p]);
        z = complex_add(&z, &z1);
    }
    return z;
}
/*- End of function --------------------------------------------------------*/

static int descramble(v17_rx_state_t *s, int in_bit)
{
    int out_bit;

    out_bit = (in_bit ^ (s->scramble_reg >> 17) ^ (s->scramble_reg >> 22)) & 1;
    s->scramble_reg <<= 1;
    if (s->in_training > TRAINING_STAGE_NORMAL_OPERATION  &&  s->in_training < TRAINING_STAGE_TCM_WINDUP)
        s->scramble_reg |= out_bit;
    else
        s->scramble_reg |= (in_bit & 1);
    return out_bit;
}
/*- End of function --------------------------------------------------------*/

static inline int find_quadrant(complex_t *z)
{
    int b1;
    int b2;

    /* Split the space along the two diagonals. */
    b1 = (z->im > z->re);
    b2 = (z->im < -z->re);
    return (b2 << 1) | (b1 ^ b2);
}
/*- End of function --------------------------------------------------------*/

static void tune_equalizer(v17_rx_state_t *s, const complex_t *z, const complex_t *target)
{
    int i;
    int p;
    complex_t ez;
    complex_t z1;

    /* Find the x and y mismatch from the exact constellation position. */
    ez = complex_sub(target, z);
    //fprintf(stderr, "%f\n", sqrt(ez.re*ez.re + ez.im*ez.im));
    /* Use weighting to put more emphasis on getting the close together
       constellation points right. */
    ez.re *= s->eq_delta;
    ez.im *= s->eq_delta;

    for (i = 0;  i <= 2*V17_EQUALIZER_LEN;  i++)
    {
        p = (s->eq_step + i) & V17_EQUALIZER_MASK;
        z1 = complex_conj(&s->eq_buf[p]);
        z1 = complex_mul(&ez, &z1);
        s->eq_coeff[i] = complex_add(&s->eq_coeff[i], &z1);
        s->eq_coeff[i].re *= 0.9999;
        s->eq_coeff[i].im *= 0.9999;
    }
}
/*- End of function --------------------------------------------------------*/

static void track_carrier(v17_rx_state_t *s, const complex_t *z, const complex_t *target)
{
    complex_t zz;

    /* For small errors the imaginary part of zz is now proportional to the phase error,
       for any particular target. However, the different amplitudes of the various target
       positions scale things. */

    zz = complex_conj(target);
    zz = complex_mul(z, &zz);
    
    s->carrier_phase_rate += s->carrier_track_i*zz.im;
    s->carrier_phase += s->carrier_track_p*zz.im;
    //fprintf(stderr, "Im = %15.5f   f = %15.5f\n", zz.im, s->carrier_phase_rate*8000.0/(65536.0*65536.0));
}
/*- End of function --------------------------------------------------------*/

static inline void put_bit(v17_rx_state_t *s, int bit)
{
    int out_bit;

    /* We need to strip the last part of the training - the test period of all 1s -
       before we let data go to the application. */
    if (s->in_training == TRAINING_STAGE_NORMAL_OPERATION)
    {
        out_bit = descramble(s, bit);
        s->put_bit(s->user_data, out_bit);
    }
    else if (s->in_training == TRAINING_STAGE_TEST_ONES)
    {
        /* The bits during the final stage of training should be all ones. However,
           buggy modems mean you cannot rely on this. Therefore we don't bother
           testing for ones, but just rely on a constellation mismatch measurement. */
        out_bit = descramble(s, bit);
        printf("A 1 is really %d\n", out_bit);
    }
}
/*- End of function --------------------------------------------------------*/

static int decode_baud(v17_rx_state_t *s, complex_t *z)
{
    static const int diff_code[16] =
    {
        0, 3, 2, 1, 1, 0, 3, 2, 2, 1, 0, 3, 3, 2, 1, 0                         
    };
    static const int tcm_paths[8][4] =
    {
        {0, 6, 2, 4},
        {6, 0, 4, 2},
        {2, 4, 0, 6},
        {4, 2, 6, 0},
        {1, 3, 7, 5},
        {5, 7, 3, 1},
        {7, 5, 1, 3},
        {3, 1, 5, 7}
    };
    int nearest;
    int i;
    int j;
    int k;
    int re;
    int im;
    int raw;
    int constellation_state;
    float distances[8];
    float new_distances[8];
    float min;

    re = (z->re + 9.0)*5.0;
    if (re > 89)
        re = 89;
    else if (re < 0)
        re = 0;
    im = (z->im + 9.0)*5.0;
    if (im > 89)
        im = 89;
    else if (im < 0)
        im = 0;

    /* Find a set of 8 candidate constellation positions, that are the closest
       to the target, with different patterns in the last 3 bits. */
    min = 9999999.0;
    j = 0;
    for (i = 0;  i < 8;  i++)
    {
        nearest = s->space_map[re][im][i];
        distances[i] = (s->constellation[nearest].re - z->re)*(s->constellation[nearest].re - z->re)
                     + (s->constellation[nearest].im - z->im)*(s->constellation[nearest].im - z->im);
        if (min > distances[i])
        {
            min = distances[i];
            j = i;
        }
    }
    nearest = s->space_map[re][im][j];
    /* Control the equalizer, carrier tracking, etc. based on the non-trellis
       corrected information. The trellis correct stuff comes out a bit late. */
    track_carrier(s, z, &s->constellation[nearest]);
    //tune_equalizer(s, z, &s->constellation[nearest]);
    constellation_state = nearest;

    /* Now do the trellis decoding */
    /* Update the minimum accumulated distance to each of the 8 states */
    if (++s->trellis_ptr >= 16)
        s->trellis_ptr = 0;
    for (i = 0;  i < 4;  i++)
    {
        min = distances[tcm_paths[i][0]] + s->distances[0];
        k = 0;
        for (j = 1;  j < 4;  j++)
        {
            if (min > distances[tcm_paths[i][j]] + s->distances[j << 1])
            {
                min = distances[tcm_paths[i][j]] + s->distances[j << 1];
                k = j;
            }
        }
        /* Use an elementary IIR filter to track the distance to date. */
        new_distances[i] = s->distances[k << 1]*0.9 + distances[tcm_paths[i][k]]*0.1;
        s->full_path_to_past_state_locations[s->trellis_ptr][i] = s->space_map[re][im][tcm_paths[i][k]];
        s->past_state_locations[s->trellis_ptr][i] = k << 1;
    }
    for (i = 4;  i < 8;  i++)
    {
        min = distances[tcm_paths[i][0]] + s->distances[1];
        k = 0;
        for (j = 1;  j < 4;  j++)
        {
            if (min > distances[tcm_paths[i][j]] + s->distances[(j << 1) + 1])
            {
                min = distances[tcm_paths[i][j]] + s->distances[(j << 1) + 1];
                k = j;
            }
        }
        new_distances[i] = s->distances[(k << 1) + 1]*0.9 + distances[tcm_paths[i][k]]*0.1;
        s->full_path_to_past_state_locations[s->trellis_ptr][i] = s->space_map[re][im][tcm_paths[i][k]];
        s->past_state_locations[s->trellis_ptr][i] = (k << 1) + 1;
    }
    memcpy(s->distances, new_distances, sizeof(s->distances));

    /* Find the minimum distance to date. This is the start of the path back to
       the result. */
    min = s->distances[0];
    k = 0;
    for (i = 1;  i < 8;  i++)
    {
        if (min > s->distances[i])
        {
            min = s->distances[i];
            k = i;
        }
    }
    /* Trace back through every time step, starting with the current one, and find the
       state from which the path came one step before. At the end of this search, the
       last state found also points to the constellation point at that state. This is the
       output of the trellis. */
    for (i = 0, j = s->trellis_ptr;  i < 15;  i++)
    {
        k = s->past_state_locations[j][k];
        if (--j < 0)
            j = 15;
    }
    nearest = s->full_path_to_past_state_locations[j][k] >> 1;

    /* Differentially decode */
    raw = (nearest & 0x3C) | diff_code[((nearest & 0x03) << 2) | s->diff];
    s->diff = nearest & 0x03;
    for (i = 0;  i < s->bits_per_symbol;  i++)
    {
        put_bit(s, raw);
        raw >>= 1;
    }
    return constellation_state;
}
/*- End of function --------------------------------------------------------*/

int fred = 0;

static void process_baud(v17_rx_state_t *s, const complex_t *sample)
{
    static const complex_t cdba[4] =
    {
        { 6.0,  2.0},
        {-2.0,  6.0},
        { 2.0, -6.0},
        {-6.0, -2.0}
    };
    complex_t z;
    complex_t zz;
    const complex_t *target;
    float p;
    float q;
    int bit;
    int i;
    int j;
    float phase;
    int32_t angle;
    int32_t ang;
    int constellation_state;

    s->rrc_filter[s->rrc_filter_step].re =
    s->rrc_filter[s->rrc_filter_step + V17RX_FILTER_STEPS].re = sample->re;
    s->rrc_filter[s->rrc_filter_step].im =
    s->rrc_filter[s->rrc_filter_step + V17RX_FILTER_STEPS].im = sample->im;
    if (++s->rrc_filter_step >= V17RX_FILTER_STEPS)
        s->rrc_filter_step = 0;
    /* Put things into the equalization buffer at T/2 rate. The Gardner algorithm
       will fiddle the step to align this with the bits. */
    if ((s->eq_put_step -= 192) > 0)
    {
        //fprintf(stderr, "Samp, %f, %f, %f, 0, 0x%X\n", z.re, z.im, sqrt(z.re*z.re + z.im*z.im), s->eq_put_step);
        return;
    }

    /* This is our interpolation filter and phase shifter, as well as our demod filter. */
    j = -s->eq_put_step;
    if (j > 192 - 1)
        j = 192 - 1;
    z = complex_set(0.0, 0.0);
    for (i = 0;  i < V17RX_FILTER_STEPS;  i++)
    {
        z.re += pulseshaper[j][i]*s->rrc_filter[i + s->rrc_filter_step].re;
        z.im += pulseshaper[j][i]*s->rrc_filter[i + s->rrc_filter_step].im;
    }
    z.re *= 1.0/PULSESHAPER_GAIN;
    z.im *= 1.0/PULSESHAPER_GAIN;

    s->eq_put_step += 320;

    /* Add a sample to the equalizer's circular buffer, but don't calculate anything
       at this time. */
    s->eq_buf[s->eq_step].re = z.re;
    s->eq_buf[s->eq_step].im = z.im;
    s->eq_step = (s->eq_step + 1) & V17_EQUALIZER_MASK;

    /* On alternate insertions we have a whole baud and must process it. */
    if ((s->baud_phase ^= 1))
        return;

    /* Perform a Gardner test for baud alignment on the three most recent samples. */
    p = s->eq_buf[(s->eq_step - 3) & V17_EQUALIZER_MASK].re
      - s->eq_buf[(s->eq_step - 1) & V17_EQUALIZER_MASK].re;
    p *= s->eq_buf[(s->eq_step - 2) & V17_EQUALIZER_MASK].re;
    s->gardner_integrate += (p > 0.0)  ?  s->gardner_step  :  -s->gardner_step;

    q = s->eq_buf[(s->eq_step - 3) & V17_EQUALIZER_MASK].im
      - s->eq_buf[(s->eq_step - 1) & V17_EQUALIZER_MASK].im;
    q *= s->eq_buf[(s->eq_step - 2) & V17_EQUALIZER_MASK].im;
    s->gardner_integrate += (q > 0.0)  ?  s->gardner_step  :  -s->gardner_step;

    if (abs(s->gardner_integrate) >= 16)
    {
        /* This integrate and dump approach avoids rapid changes of the equalizer put step.
           Rapid changes, without hysteresis, are bad. They degrade the equalizer performance
           when the true symbol boundary is close to a sample boundary. */
        s->eq_put_step += (s->gardner_integrate/16);
        s->gardner_total_correction += (s->gardner_integrate/16);
        if (s->qam_report)
            s->qam_report(s->qam_user_data, NULL, NULL, s->gardner_integrate);
        s->gardner_integrate = 0;
    }

printf("Gardtest %d %d %d\n", fred++, s->gardner_total_correction, s->gardner_step);

    z = equalizer_get(s);

    constellation_state = 0;
    switch (s->in_training)
    {
    case TRAINING_STAGE_NORMAL_OPERATION:
        /* Normal operation. */
        constellation_state = decode_baud(s, &z);
        target = &s->constellation[constellation_state];
        break;
    case TRAINING_STAGE_SYMBOL_ACQUISITION:
        /* Allow time for the Gardner algorithm to settle the symbol timing. */
        target = &z;
        /* Don't start narrowing the bandwidth of the Gardner algorithm too early.
           Some modems are a bit wobbly when they start sending the signal. Also, we start
           this analysis before our filter buffers have completely filled. */
        if (++s->training_count == 30)
            s->gardner_step = 16;
        else if (s->training_count == 40)
            s->gardner_step = 8;
        else if (s->training_count >= 50)
        {
            /* Record the current phase angle */
            s->in_training = TRAINING_STAGE_LOG_PHASE;
            s->angles[0] =
            s->start_angles[0] = arctan2(z.im, z.re);
            /* QAM and Gardner only play nicely with heavy damping, so we need to change to
               a slow rate of symbol timing adaption. However, it must not be so slow that it
               cannot track the worst case timing error specified in V.17. This should be 0.01%,
               but since we might be off in the opposite direction from the source, the total
               error could be higher. */
            s->gardner_step = 8;
        }
        break;
    case TRAINING_STAGE_LOG_PHASE:
        /* Record the current alternate phase angle */
        target = &z;
        angle = arctan2(z.im, z.re);
        s->angles[1] =
        s->start_angles[1] = angle;
        s->training_count = 1;
        if (s->short_train)
        {
            if (((s->start_angles[1] >> 1) - (s->start_angles[0] >> 1)) < 0x40000000)
                angle = s->start_angles[0];
            q = 3.1415926535 + 0.321751 - angle*(2.0*3.14159)/(65536.0*65536.0);
            zz = complex_set(cos(-q), -sin(-q));
            for (i = 0;  i < 2*V17RX_FILTER_STEPS;  i++)
                s->rrc_filter[i] = complex_mul(&s->rrc_filter[i], &zz);
            for (i = 0;  i <= V17_EQUALIZER_MASK;  i++)
                s->eq_buf[i] = complex_mul(&s->eq_buf[i], &zz);

            ang = q*(65536.0*65536.0)/(2.0*3.14159);
            s->carrier_phase -= ang;
            s->in_training = TRAINING_STAGE_SHORT_WAIT_FOR_CDBA;
            s->carrier_track_i = 100.0;
            s->carrier_track_p = 500000.0;
        }
        else
        {
            s->in_training = TRAINING_STAGE_WAIT_FOR_CDBA;
        }
        break;
    case TRAINING_STAGE_WAIT_FOR_CDBA:
        target = &z;
        angle = arctan2(z.im, z.re);
        /* Look for the initial ABAB sequence to display a phase reversal, which will
           signal the start of the scrambled CDBA segment */
        ang = angle - s->angles[(s->training_count - 1) & 0xF];
        s->angles[(s->training_count + 1) & 0xF] = angle;
        if ((ang > 0x40000000  ||  ang < -0x40000000)  &&  s->training_count >= 13)
        {
            /* We seem to have a phase reversal */
            /* Slam the carrier frequency into line, based on the total phase drift over the last
               section. Use the shift from the odd bits and the shift from the even bits to get
               better jitter suppression. We need to scale here, or at the maximum specified
               frequency deviation we could overflow, and get a silly answer. */
            /* Step back a few symbols so we don't get ISI distorting things. */
            i = (s->training_count - 8) & ~1;
            j = i & 0xF;
            ang = (s->angles[j] - s->start_angles[0])/i
                + (s->angles[j | 0x1] - s->start_angles[1])/i;
            s->carrier_phase_rate += 3*(ang/20);
            //fprintf(stderr, "%d %d %d %d %d\n", s->angles[s->training_count & 0xF], s->start_angles[0], s->angles[(s->training_count | 0x1) & 0xF], s->start_angles[1], s->training_count);
            fprintf(stderr, "Coarse carrier frequency %7.2f (%d)\n", s->carrier_phase_rate*8000.0/(65536.0*65536.0), s->training_count);

            /* Make a step shift in the phase, to pull it into line. We need to rotate the RRC filter
               buffer and the equalizer buffer, as well as the carrier phase, for this to play out
               nicely. */
            q = 0.321751 - angle*(2.0*3.14159)/(65536.0*65536.0);
            zz = complex_set(cos(-q), -sin(-q));
            for (i = 0;  i < 2*V17RX_FILTER_STEPS;  i++)
                s->rrc_filter[i] = complex_mul(&s->rrc_filter[i], &zz);
            for (i = 0;  i <= V17_EQUALIZER_MASK;  i++)
                s->eq_buf[i] = complex_mul(&s->eq_buf[i], &zz);
            ang = q*(65536.0*65536.0)/(2.0*3.14159);
            s->carrier_phase += ang;

            /* We have just seen the first symbol of the scrambled sequence, so skip it. */
            descramble(s, 1);
            descramble(s, 1);
            s->training_count = 1;
            s->in_training = TRAINING_STAGE_TRAIN_ON_CDBA;
            s->gardner_step = 6;
        }
        else if (++s->training_count > V17_TRAINING_SEG_1_LEN)
        {
            /* This is bogus. There are not this many bits in this section
               of a real training sequence. */
            fprintf(stderr, "Training failed (sequence failed)\n");
            /* Park this modem */
            s->in_training = TRAINING_STAGE_PARKED;
            s->put_bit(s->user_data, PUTBIT_TRAINING_FAILED);
        }
        break;
    case TRAINING_STAGE_TRAIN_ON_CDBA:
        /* Train on the scrambled CDBA section. */
        bit = descramble(s, 1);
        bit = (bit << 1) | descramble(s, 1);
        target = &cdba[bit];
        track_carrier(s, &z, target);
        tune_equalizer(s, &z, target);
        if (s->training_count == V17_TRAINING_SEG_2_LEN - 2000)
            s->eq_delta /= 5.0;
        if (++s->training_count >= V17_TRAINING_SEG_2_LEN - 48)
        {
            s->in_training = TRAINING_STAGE_TRAIN_ON_CDBA_AND_TEST;
            s->gardner_step = 4;
            s->training_error = 0.0;
            s->carrier_track_i = 100.0;
            s->carrier_track_p = 500000.0;
        }
        break;
    case TRAINING_STAGE_TRAIN_ON_CDBA_AND_TEST:
        /* Continue training on the scrambled CDBA section, but measure the quality of training too. */
        bit = descramble(s, 1);
        bit = (bit << 1) | descramble(s, 1);

        //fprintf(stderr, "%5d [%15.5f, %15.5f]     [%15.5f, %15.5f]\n", s->training_count, z.re, z.im, cdba[bit].re, cdba[bit].im);
        target = &cdba[bit];
        track_carrier(s, &z, target);
        tune_equalizer(s, &z, target);
        /* Measure the training error */
        zz = complex_sub(&z, &cdba[bit]);
        s->training_error += power(&zz);
        if (++s->training_count >= V17_TRAINING_SEG_2_LEN)
        {
            fprintf(stderr, "Training error %f\n", s->training_error);
            if (s->training_error < 100.0)
            {
                s->training_count = 0;
                s->training_error = 0.0;
                s->in_training = TRAINING_STAGE_BRIDGE;
            }
            else
            {
                fprintf(stderr, "Training failed (convergence failed)\n");
                /* Park this modem */
                s->in_training = TRAINING_STAGE_PARKED;
                s->put_bit(s->user_data, PUTBIT_TRAINING_FAILED);
            }
        }
        break;
    case TRAINING_STAGE_BRIDGE:
        descramble(s, V17_BRIDGE_WORD >> ((s->training_count & 0x7) << 1));
        descramble(s, V17_BRIDGE_WORD >> (((s->training_count & 0x7) << 1) + 1));
        target = &z;
        if (++s->training_count >= V17_TRAINING_SEG_3_LEN)
        {
            s->training_count = 0;
            s->training_error = 0.0;
            s->in_training = TRAINING_STAGE_TCM_WINDUP;
        }
        break;
    case TRAINING_STAGE_SHORT_WAIT_FOR_CDBA:
        target = &cdba[(s->training_count & 1) + 2];
        angle = arctan2(z.im, z.re);
        /* Look for the initial ABAB sequence to display a phase reversal, which will
           signal the start of the scrambled CDBA segment */
        ang = angle - s->angles[(s->training_count - 1) & 0xF];
        s->angles[(s->training_count + 1) & 0xF] = angle;
        if ((ang > 0x40000000  ||  ang < -0x40000000)  &&  s->training_count >= 13)
        {
            /* We seem to have a phase reversal */
            /* Slam the carrier frequency into line, based on the total phase drift over the last
               section. Use the shift from the odd bits and the shift from the even bits to get
               better jitter suppression. We need to scale here, or at the maximum specified
               frequency deviation we could overflow, and get a silly answer. */

            /* We have just seen the first symbol of the scrambled sequence, so skip it. */
            descramble(s, 1);
            descramble(s, 1);
            s->training_count = 1;
            s->in_training = TRAINING_STAGE_SHORT_TRAIN_ON_CDBA_AND_TEST;
            s->gardner_step = 4;
        }
        else
        {
            if (++s->training_count > V17_TRAINING_SEG_1_LEN)
            {
                /* This is bogus. There are not this many bits in this section
                   of a real training sequence. */
                fprintf(stderr, "Training failed (sequence failed)\n");
                /* Park this modem */
                s->in_training = TRAINING_STAGE_PARKED;
                s->put_bit(s->user_data, PUTBIT_TRAINING_FAILED);
            }
        }
        break;
    case TRAINING_STAGE_SHORT_TRAIN_ON_CDBA_AND_TEST:
        /* Short retrain on the scrambled CDBA section, but measure the quality of training too. */
        bit = descramble(s, 1);
        bit = (bit << 1) | descramble(s, 1);
        //fprintf(stderr, "%5d [%15.5f, %15.5f]     [%15.5f, %15.5f] %d\n", s->training_count, z.re, z.im, cdba[bit].re, cdba[bit].im, arctan2(z.im, z.re));
        target = &cdba[bit];
        track_carrier(s, &z, target);
        //tune_equalizer(s, &z, target);
        /* Measure the training error */
        if (s->training_count > 8)
        {
            zz = complex_sub(&z, &cdba[bit]);
            s->training_error += power(&zz);
        }
        if (++s->training_count >= V17_TRAINING_SHORT_SEG_2_LEN)
        {
            fprintf(stderr, "Short training error %f\n", s->training_error);
            if (s->training_error < 4000.0)
            {
                s->training_count = 0;
                s->in_training = TRAINING_STAGE_TCM_WINDUP;
            }
            else
            {
                fprintf(stderr, "Short training failed (convergence failed)\n");
                /* Park this modem */
                s->in_training = TRAINING_STAGE_PARKED;
                s->put_bit(s->user_data, PUTBIT_TRAINING_FAILED);
            }
        }
        break;
    case TRAINING_STAGE_TCM_WINDUP:
        /* We need to wait 15 bauds while the trellis fills up. */
        //fprintf(stderr, "%5d %15.5f, %15.5f\n", s->training_count, z.re, z.im);
        constellation_state = decode_baud(s, &z);
        target = &s->constellation[constellation_state];
        /* Measure the training error */
        zz = complex_sub(&z, target);
        s->training_error += power(&zz);
        if (++s->training_count >= V17_TRAINING_SEG_4A_LEN)
        {
            s->in_training = TRAINING_STAGE_TEST_ONES;
            s->training_count = 0;
            s->training_error = 0.0;
            /* Restart the differential decoder */
            s->diff = (s->short_train)  ?  0  :  1;
        }
        break;
    case TRAINING_STAGE_TEST_ONES:
        /* We are in the test phase, where we check that we can receive reliably.
           We should get a run of 1's, 48 symbols long. */
        //fprintf(stderr, "%5d %15.5f, %15.5f\n", s->training_count, z.re, z.im);
        constellation_state = decode_baud(s, &z);
        target = &s->constellation[constellation_state];
        /* Measure the training error */
        zz = complex_sub(&z, target);
        s->training_error += power(&zz);
        if (++s->training_count >= V17_TRAINING_SEG_4_LEN)
        {
            if (s->training_error < 25.0)
            {
                /* We are up and running */
                fprintf(stderr, "Training succeeded (constellation mismatch %f)\n", s->training_error);
                s->in_training = TRAINING_STAGE_NORMAL_OPERATION;
                s->put_bit(s->user_data, PUTBIT_TRAINING_SUCCEEDED);
                equalizer_save(s);
                s->carrier_phase_rate_save = s->carrier_phase_rate;
            }
            else
            {
                /* Training has failed */
                fprintf(stderr, "Training failed (constellation mismatch %f)\n", s->training_error);
                /* Park this modem */
                s->in_training = TRAINING_STAGE_PARKED;
                s->put_bit(s->user_data, PUTBIT_TRAINING_FAILED);
            }
        }
        break;
    case TRAINING_STAGE_PARKED:
    default:
        /* We failed to train! */
        /* Park here until the carrier drops. */
        target = &z;
        break;
    }
    if (s->qam_report)
        s->qam_report(s->qam_user_data, &z, target, constellation_state);
}
/*- End of function --------------------------------------------------------*/

void v17_rx(v17_rx_state_t *s, const int16_t *amp, int len)
{
    int i;
    int16_t sample;
    complex_t z;
    int32_t power;
    float x;

    for (i = 0;  i < len;  i++)
    {
        sample = amp[i];
        power = power_meter_update(&(s->power), sample);
        if (s->carrier_present)
        {
            /* Look for power below -48dBm0 to turn the carrier off */
            if (power < s->carrier_off_power)
            {
                v17_rx_restart(s, s->bit_rate, s->short_train);
                s->put_bit(s->user_data, PUTBIT_CARRIER_DOWN);
                continue;
            }
        }
        else
        {
            /* Look for power exceeding -43dBm0 to turn the carrier on */
            if (power < s->carrier_on_power)
                continue;
            s->carrier_present = TRUE;
            s->put_bit(s->user_data, PUTBIT_CARRIER_UP);
        }
        if (s->in_training != TRAINING_STAGE_PARKED)
        {
            /* Only spend effort processing this data if the modem is not
               parked, after training failure. */
            if (s->in_training == TRAINING_STAGE_SYMBOL_ACQUISITION)
            {
                /* Only AGC during the initial training */
                s->agc_scaling = 3.0*3.60/sqrt(power);
            }
            x = sample*s->agc_scaling;
            /* Shift to baseband */
            z = dds_complexf(&(s->carrier_phase), s->carrier_phase_rate);
            z.re *= x;
            z.im *= x;
            process_baud(s, &z);
        }
    }
}
/*- End of function --------------------------------------------------------*/

int v17_rx_restart(v17_rx_state_t *s, int bit_rate, int short_train)
{
    int i;
    int j;

    switch (bit_rate)
    {
    case 14400:
        s->constellation = v17_14400_constellation;
        s->space_map = space_map_14400;
        s->bits_per_symbol = 6;
        break;
    case 12000:
        s->constellation = v17_12000_constellation;
        s->space_map = space_map_12000;
        s->bits_per_symbol = 5;
        break;
    case 9600:
        s->constellation = v17_9600_constellation;
        s->space_map = space_map_9600;
        s->bits_per_symbol = 4;
        break;
    case 7200:
        s->constellation = v17_7200_constellation;
        s->space_map = space_map_7200;
        s->bits_per_symbol = 3;
        break;
    default:
        return -1;
    }
    s->bit_rate = bit_rate;
    memset(s->rrc_filter, 0, sizeof(s->rrc_filter));
    s->rrc_filter_step = 0;

    s->diff = 1;
    s->scramble_reg = 0x2ECDD5;
    s->in_training = TRAINING_STAGE_SYMBOL_ACQUISITION;
    s->training_count = 0;
    s->carrier_present = FALSE;
    s->short_train = short_train;

    /* Initialise the TCM decoder parameters. */
    /* The accumulated distance vectors are set so state zero starts
       at a value of zero, and all others start larger. This forces the
       initial paths to merge at the zero states. */
    for (i = 0;  i < 8;  i++)
    {
        s->distances[i] = 99.0;
        for (j = 0;  j < 16;  j++)
        {
            s->full_path_to_past_state_locations[j][i] = 0;
            s->past_state_locations[j][i] = 0;
        }
    }
    s->distances[0] = 0;
    s->trellis_ptr = 14;

printf("Phase rates %f %f\n", s->carrier_phase_rate*(float) SAMPLE_RATE/(65536.0*65536.0), s->carrier_phase_rate_save*(float) SAMPLE_RATE/(65536.0*65536.0));
    if (s->short_train)
        s->carrier_phase_rate = s->carrier_phase_rate_save;
    else
        s->carrier_phase_rate = dds_phase_stepf(1800.0);
    s->carrier_phase = 0;
    s->carrier_track_i = 1000.0;
    s->carrier_track_p = 40000.0;
    power_meter_init(&(s->power), 4);
    s->carrier_on_power = power_meter_level(-26); //(-43);
    s->carrier_off_power = power_meter_level(-31); //(-48);
    s->agc_scaling = 0.0005;

    equalizer_reset(s, 0.25);
    if (s->short_train)
        equalizer_restore(s);

    s->gardner_integrate = 0;
    s->gardner_total_correction = 0;
    /* Start with very big Gardner steps, until we start to pull in the symbol timing. */
    s->gardner_step = 64;
    s->baud_phase = 0;
    
    return 0;
}
/*- End of function --------------------------------------------------------*/

void v17_rx_init(v17_rx_state_t *s, int bit_rate, put_bit_func_t put_bit, void *user_data)
{
    int i;
    int j;
    int k;
    int l;
    int best;
    float distance;
    float best_distance;
    float x;
    float y;

    memset(s, 0, sizeof(*s));
    s->put_bit = put_bit;
    s->user_data = user_data;

    if (!inited)
    {
        /* Build the nearest point map for the constellation */
        for (i = 0;  i < 90;  i++)
        {
            for (j = 0;  j < 90;  j++)
            {
                x = (i - 45)/5.0 + 0.1;
                y = (j - 45)/5.0 + 0.1;
                for (k = 0;  k < 8;  k++)
                {
                    best = 0;
                    best_distance = 100000.0;
                    for (l = k;  l < 128;  l += 8)
                    {
                        distance = (x - v17_14400_constellation[l].re)*(x - v17_14400_constellation[l].re)
                                 + (y - v17_14400_constellation[l].im)*(y - v17_14400_constellation[l].im);
                        if (distance <= best_distance)
                        {
                            best_distance = distance;
                            best = l;
                        }
                    }
                    space_map_14400[i][j][k] = best;
                
                    best = 0;
                    best_distance = 100000.0;
                    for (l = k;  l < 64;  l += 8)
                    {
                        distance = (x - v17_12000_constellation[l].re)*(x - v17_12000_constellation[l].re)
                                 + (y - v17_12000_constellation[l].im)*(y - v17_12000_constellation[l].im);
                        if (distance <= best_distance)
                        {
                            best_distance = distance;
                            best = l;
                        }
                    }
                    space_map_12000[i][j][k] = best;

                    best = 0;
                    best_distance = 100000.0;
                    for (l = k;  l < 32;  l += 8)
                    {
                        distance = (x - v17_9600_constellation[l].re)*(x - v17_9600_constellation[l].re)
                                 + (y - v17_9600_constellation[l].im)*(y - v17_9600_constellation[l].im);
                        if (distance <= best_distance)
                        {
                            best_distance = distance;
                            best = l;
                        }
                    }
                    space_map_9600[i][j][k] = best;

                    best = 0;
                    best_distance = 100000.0;
                    for (l = k;  l < 16;  l += 8)
                    {
                        distance = (x - v17_7200_constellation[l].re)*(x - v17_7200_constellation[l].re)
                                 + (y - v17_7200_constellation[l].im)*(y - v17_7200_constellation[l].im);
                        if (distance <= best_distance)
                        {
                            best_distance = distance;
                            best = l;
                        }
                    }
                    space_map_7200[i][j][k] = best;
                }
            }
        }
        inited = TRUE;
    }
    
    s->short_train = FALSE;
    v17_rx_restart(s, bit_rate, s->short_train);
}
/*- End of function --------------------------------------------------------*/

void v17_rx_set_qam_report_handler(v17_rx_state_t *s, qam_report_handler_t *handler, void *user_data)
{
    s->qam_report = handler;
    s->qam_user_data = user_data;
}
/*- End of function --------------------------------------------------------*/
/*- End of file ------------------------------------------------------------*/
