/******************************************************************************
*		       							      *
* gnome/reader.c (part of rcalc)				       	      *
* Copyright (C) 2001 Free Software Foundation, Inc.			      *
*								       	      *
* This program is free software; you can redistribute it and/or modify 	      *
* it under the terms of the GNU General Public License as published by 	      *
* the Free Software Foundation; either version 2 of the License, or    	      *
* (at your option) any later version.				       	      *
*								       	      *
* This program is distributed in the hope that it will be useful,      	      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       	      *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	       	      *
* GNU General Public License for more details.			       	      *
*								       	      *
* You should have received a copy of the GNU General Public License    	      *
* along with this program; if not, write to the Free Software	       	      *
* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.	       	      *
*								       	      *
******************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "reader.h"		/* This file's header	     		*/
#include "../console/readline.h"	/* TODO: get rid */

#include <signal.h>

/*****************************************************************************/

/* Define the prompt to use.
** Nonprinting characters must be protected by `\[' and `\]' as in bash.
*/
#define DEFAULTCOLOUR	"\x1B[0m"
#define PROMPTCOLOUR	"\x1B[0;34m"

#define PROMPT		"\\[" PROMPTCOLOUR "\\]"	\
			PACKAGE ">"			\
			"\\[" DEFAULTCOLOUR "\\]"	\
			" "


/* The RcReadline used to obtain the user input. This must be static
** so that we can delete it (and hence write the history) when we are
** terminated by the main process.
*/
static RcReadline *the_readline = NULL;


/* Signal handler to delete the RcReadline.
*/
static RETSIGTYPE rcg_reader_process_sighandler( int sig )
{
	rcc_readline_delete( the_readline );
}


/* Run the reader process for the GNOME user interface. This never
** exits but is terminated (via a SIGTERM) by the main process. Prior
** to sending the SIGTERM it will send a SIGUSR1 which is a signal
** that we should clean up.
*/
void rcg_reader_process( FILE *to_main, FILE *from_main )
{
	/* Create a readline to read the user's input and register
	** an exit function to delete it when we exit.
	*/
	the_readline = rcc_readline_new( PROMPT );
	signal( SIGUSR1, rcg_reader_process_sighandler );
	
	/* The main loop: never exits.
	*/
	while(1)
	{
		const gchar *user_input;
		size_t user_input_size;
		gchar c;
			
		/* Read the user input and send it to the main process.
		*/
		user_input = rcc_readline_read_line( the_readline );
		if( !user_input ) user_input = "exit";
		user_input_size = strlen( user_input );
		if( !user_input_size ) continue;
		
		fwrite( &user_input_size, sizeof(size_t), 1, to_main );
		fwrite( user_input, 1, user_input_size, to_main );
		fflush( to_main );

		/* Copy the response to stdout.
		*/
		while(( c=getc( from_main ) )) putchar(c);
		fflush( stdout );
	}
}

/*** end of gnome/reader.c ***************************************************/
