/***************************************************************************
                          transparencydialog.cpp  -  description
                             -------------------
    begin                : Sat Sep 28 2002
    copyright            : (C) 2002 by Michael Herder
    email                : crapsite@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "transparencydialog.h"

#include "quiteinsane/qxmlconfig.h"
#include "quiteinsane/sliderspin.h"

#include <math.h>

#include <qapplication.h>
#include <qcheckbox.h>
#include <qframe.h>
#include <qhbox.h>
#include <qimage.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qnamespace.h>
#include <qpixmap.h>
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qvbox.h>

TransparencyDialog::TransparencyDialog(int preview_size,QImage* image,QWidget* parent)
                   :ImageFilterDialog(preview_size,image,parent)
{
  initControls();
}
TransparencyDialog::~TransparencyDialog()
{
}
/** No descriptions */
void TransparencyDialog::initControls()
{
  int mode = xmlConfig->intValue("FILTER_TRANSPARENCY_MODE",0);
  int max_hue = xmlConfig->intValue("FILTER_TRANSPARENCY_MAX_HUE",0);
  int min_hue = xmlConfig->intValue("FILTER_TRANSPARENCY_MIN_HUE",0);
  int max_sat = xmlConfig->intValue("FILTER_TRANSPARENCY_MAX_SAT",255);
  int min_sat = xmlConfig->intValue("FILTER_TRANSPARENCY_MIN_SAT",0);
  int max_val = xmlConfig->intValue("FILTER_TRANSPARENCY_MAX_VAL",255);
  int min_val = xmlConfig->intValue("FILTER_TRANSPARENCY_MIN_VAL",0);
  bool hue_on = xmlConfig->boolValue("FILTER_TRANSPARENCY_HUE_ON",false);
  bool sat_on = xmlConfig->boolValue("FILTER_TRANSPARENCY_SAT_ON",false);
  bool val_on = xmlConfig->boolValue("FILTER_TRANSPARENCY_VAL_ON",false);
  int max_red = xmlConfig->intValue("FILTER_TRANSPARENCY_MAX_RED",0);
  int min_red = xmlConfig->intValue("FILTER_TRANSPARENCY_MIN_RED",0);
  int max_green = xmlConfig->intValue("FILTER_TRANSPARENCY_MAX_GREEN",255);
  int min_green = xmlConfig->intValue("FILTER_TRANSPARENCY_MIN_GREEN",0);
  int max_blue = xmlConfig->intValue("FILTER_TRANSPARENCY_MAX_BLUE",255);
  int min_blue = xmlConfig->intValue("FILTER_TRANSPARENCY_MIN_BLUE",0);
  bool red_on = xmlConfig->boolValue("FILTER_TRANSPARENCY_RED_ON",false);
  bool green_on = xmlConfig->boolValue("FILTER_TRANSPARENCY_GREEN_ON",false);
  bool blue_on = xmlConfig->boolValue("FILTER_TRANSPARENCY_BLUE_ON",false);
  bool c_up = xmlConfig->boolValue("FILTER_TRANSPARENCY_CONTINOUS_UPDATE",false);

  QVBox* vb = controlsVBox();
  if(!vb)
    return;
  setTitle(tr("Transparency"));
  setCaption(tr("Transparency"));
  //tabwidget; we use it to toggle between HSV and RGB mode
  mpTabWidget = new QTabWidget(vb);

  //HSV tab
  QVBox* tabpage1 = new QVBox(mpTabWidget);
  tabpage1->setMargin(5);
  tabpage1->setSpacing(2);
  //Hue
  mpHueCheckBox = new QCheckBox(tr("Hue"),tabpage1);
  //minimum
  mpMinHueSlider = new SliderSpin(-1,360,min_hue,tr("Minimum"),tabpage1);
  mpMinHueSlider->setMinimumWidth(150);
  //maximum
  mpMaxHueSlider = new SliderSpin(-1,360,max_hue,tr("Maximum"),tabpage1);
  mpMaxHueSlider->setMinimumWidth(150);

  //separator
  QFrame* sep1 = new QFrame(tabpage1);
  sep1->setFrameStyle(QFrame::HLine|QFrame::Sunken);
  sep1->setLineWidth(2);

  //Saturation
  mpSatCheckBox = new QCheckBox(tr("Saturation"),tabpage1);
  //minimum
  mpMinSatSlider = new SliderSpin(0,255,min_sat,tr("Minimum"),tabpage1);
  mpMinSatSlider->setMinimumWidth(150);
  //maximum
  mpMaxSatSlider = new SliderSpin(0,255,max_sat,tr("Maximum"),tabpage1);
  mpMaxSatSlider->setMinimumWidth(150);

  //separator
  QFrame* sep2 = new QFrame(tabpage1);
  sep2->setFrameStyle(QFrame::HLine|QFrame::Sunken);
  sep2->setLineWidth(2);

  //Value
  mpValCheckBox = new QCheckBox(tr("Value"),tabpage1);
  //minimum
  mpMinValSlider = new SliderSpin(0,255,min_val,tr("Minimum"),tabpage1);
  mpMinValSlider->setMinimumWidth(150);
  //maximum
  mpMaxValSlider = new SliderSpin(0,255,max_val,tr("Maximum"),tabpage1);
  mpMaxValSlider->setMinimumWidth(150);

  QWidget* dummy = new QWidget(tabpage1);
  tabpage1->setStretchFactor(dummy,1);

  mpTabWidget->addTab(tabpage1,tr("HSV"));

  //RGB tab
  QVBox* tabpage2 = new QVBox(mpTabWidget);
  tabpage2->setMargin(5);
  tabpage2->setSpacing(2);
  //Red
  mpRedCheckBox = new QCheckBox(tr("Red"),tabpage2);
  //minimum
  mpMinRedSlider = new SliderSpin(0,255,min_red,tr("Minimum"),tabpage2);
  mpMinRedSlider->setMinimumWidth(150);
  //maximum
  mpMaxRedSlider = new SliderSpin(0,255,max_red,tr("Maximum"),tabpage2);
  mpMaxRedSlider->setMinimumWidth(150);

  //separator
  QFrame* sep3 = new QFrame(tabpage2);
  sep3->setFrameStyle(QFrame::HLine|QFrame::Sunken);
  sep3->setLineWidth(2);

  //Green
  mpGreenCheckBox = new QCheckBox(tr("Green"),tabpage2);
  //minimum
  mpMinGreenSlider = new SliderSpin(0,255,min_green,tr("Minimum"),tabpage2);
  mpMinGreenSlider->setMinimumWidth(150);
  //maximum
  mpMaxGreenSlider = new SliderSpin(0,255,max_green,tr("Maximum"),tabpage2);
  mpMaxGreenSlider->setMinimumWidth(150);

  //separator
  QFrame* sep4 = new QFrame(tabpage2);
  sep4->setFrameStyle(QFrame::HLine|QFrame::Sunken);
  sep4->setLineWidth(2);

  //Blue
  mpBlueCheckBox = new QCheckBox(tr("Blue"),tabpage2);
  //minimum
  mpMinBlueSlider = new SliderSpin(0,255,min_blue,tr("Minimum"),tabpage2);
  mpMinBlueSlider->setMinimumWidth(150);
  //maximum
  mpMaxBlueSlider = new SliderSpin(0,255,max_blue,tr("Maximum"),tabpage2);
  mpMaxBlueSlider->setMinimumWidth(150);

  dummy = new QWidget(tabpage2);
  tabpage2->setStretchFactor(dummy,1);

  mpTabWidget->addTab(tabpage2,tr("RGB"));


  connect(mpMinHueSlider,SIGNAL(signalValueChanged(int)),
          this,SLOT(slotMinHueChanged(int)));
  connect(mpMaxHueSlider,SIGNAL(signalValueChanged(int)),
          this,SLOT(slotMaxHueChanged(int)));
  connect(mpMinSatSlider,SIGNAL(signalValueChanged(int)),
          this,SLOT(slotMinSatChanged(int)));
  connect(mpMaxSatSlider,SIGNAL(signalValueChanged(int)),
          this,SLOT(slotMaxSatChanged(int)));
  connect(mpMinValSlider,SIGNAL(signalValueChanged(int)),
          this,SLOT(slotMinValChanged(int)));
  connect(mpMaxValSlider,SIGNAL(signalValueChanged(int)),
          this,SLOT(slotMaxValChanged(int)));

  connect(mpHueCheckBox,SIGNAL(toggled(bool)),
          this,SLOT(slotHueEnabled(bool)));
  connect(mpSatCheckBox,SIGNAL(toggled(bool)),
          this,SLOT(slotSatEnabled(bool)));
  connect(mpValCheckBox,SIGNAL(toggled(bool)),
          this,SLOT(slotValEnabled(bool)));


  connect(mpMinRedSlider,SIGNAL(signalValueChanged(int)),
          this,SLOT(slotMinRedChanged(int)));
  connect(mpMaxRedSlider,SIGNAL(signalValueChanged(int)),
          this,SLOT(slotMaxRedChanged(int)));
  connect(mpMinGreenSlider,SIGNAL(signalValueChanged(int)),
          this,SLOT(slotMinGreenChanged(int)));
  connect(mpMaxGreenSlider,SIGNAL(signalValueChanged(int)),
          this,SLOT(slotMaxGreenChanged(int)));
  connect(mpMinBlueSlider,SIGNAL(signalValueChanged(int)),
          this,SLOT(slotMinBlueChanged(int)));
  connect(mpMaxBlueSlider,SIGNAL(signalValueChanged(int)),
          this,SLOT(slotMaxBlueChanged(int)));

  connect(mpHueCheckBox,SIGNAL(toggled(bool)),
          this,SLOT(slotHueEnabled(bool)));
  connect(mpSatCheckBox,SIGNAL(toggled(bool)),
          this,SLOT(slotSatEnabled(bool)));
  connect(mpValCheckBox,SIGNAL(toggled(bool)),
          this,SLOT(slotValEnabled(bool)));

  connect(mpRedCheckBox,SIGNAL(toggled(bool)),
          this,SLOT(slotRedEnabled(bool)));
  connect(mpGreenCheckBox,SIGNAL(toggled(bool)),
          this,SLOT(slotGreenEnabled(bool)));
  connect(mpBlueCheckBox,SIGNAL(toggled(bool)),
          this,SLOT(slotBlueEnabled(bool)));

  connect(mpTabWidget,SIGNAL(currentChanged(QWidget*)),
          this,SLOT(slotChangeMode(QWidget*)));
  //load values
  slotMinHueChanged(min_hue);
  slotMaxHueChanged(max_hue);
  slotMinSatChanged(min_sat);
  slotMaxSatChanged(max_sat);
  slotMinValChanged(min_val);
  slotMaxValChanged(max_val);

  slotMinRedChanged(min_red);
  slotMaxRedChanged(max_red);
  slotMinGreenChanged(min_green);
  slotMaxGreenChanged(max_green);
  slotMinBlueChanged(min_blue);
  slotMaxBlueChanged(max_blue);

  mpHueCheckBox->setChecked(hue_on);
  mpSatCheckBox->setChecked(sat_on);
  mpValCheckBox->setChecked(val_on);

  slotHueEnabled(hue_on);
  slotSatEnabled(sat_on);
  slotValEnabled(val_on);

  mpRedCheckBox->setChecked(red_on);
  mpGreenCheckBox->setChecked(green_on);
  mpBlueCheckBox->setChecked(blue_on);

  slotRedEnabled(red_on);
  slotGreenEnabled(green_on);
  slotBlueEnabled(blue_on);

  mpTabWidget->setCurrentPage(mode);
  layout()->activate();
  setFixedSize(sizeHint().width(),sizeHint().height());
  setContinousUpdate(c_up);
}
/** No descriptions */
bool TransparencyDialog::apply(QImage* image,bool emit_progress)
{
  int x,y;
  QColor color;
  int progress,progresscnt;
  progress = image->width() * image->height();
  progresscnt = 0;
  int old_p = 0;
  int max_hue,min_hue;
  int max_sat,min_sat;
  int max_val,min_val;
  bool hue_on,sat_on,val_on;
  int max_red,min_red;
  int max_green,min_green;
  int max_blue,min_blue;
  bool red_on,green_on,blue_on;
  int mode = 0;
  bool must_apply;
  int h,s,v;
  int r,g,b;
  QImage im;

  im = image->copy();

  if(im.isNull())
    return false;
  if(im.depth() < 32)
    im = im.convertDepth(32);
  if(!im.hasAlphaBuffer())
    im.setAlphaBuffer(true);

  min_hue = mpMinHueSlider->value();
  max_hue = mpMaxHueSlider->value();
  hue_on = mpHueCheckBox->isChecked();
  min_sat = mpMinSatSlider->value();
  max_sat = mpMaxSatSlider->value();
  sat_on = mpSatCheckBox->isChecked();
  min_val = mpMinValSlider->value();
  max_val = mpMaxValSlider->value();
  val_on = mpValCheckBox->isChecked();

  min_red = mpMinRedSlider->value();
  max_red = mpMaxRedSlider->value();
  red_on = mpRedCheckBox->isChecked();
  min_green = mpMinGreenSlider->value();
  max_green = mpMaxGreenSlider->value();
  green_on = mpGreenCheckBox->isChecked();
  min_blue = mpMinBlueSlider->value();
  max_blue = mpMaxBlueSlider->value();
  blue_on = mpBlueCheckBox->isChecked();

  mode=mpTabWidget->currentPageIndex();

  for (y=0; y < im.height(); y++)
  {
    for (x=0; x < im.width(); x++)
    {
      color.setRgb(im.pixel(x,y));
      color.hsv(&h,&s,&v);
      r = color.red();
      g = color.green();
      b = color.blue();
      must_apply = false;
      if(mode == 0)
      {
        if( ((((min_hue < max_hue) && ((h>=min_hue) && (h<=max_hue))) ||           //hue
            ((min_hue > max_hue) && ((h>=min_hue) || (h<=max_hue)))) && hue_on) || //hue
            ((((min_sat < max_sat) && ((s>=min_sat) && (s<=max_sat))) ||           //saturation
            ((min_sat > max_sat) && ((s>=min_sat) || (s<=max_sat)))) && sat_on) || //saturation
            ((((min_val < max_val) && ((v>=min_val) && (v<=max_val))) ||           //value
            ((min_val > max_val) && ((v>=min_val) || (v<=max_val)))) && val_on) )  //value
        {
          must_apply = true;
        }
      }
      else if(mode == 1)
      {
        if( ((((min_red < max_red) && ((r>=min_red) && (r<=max_red))) ||           //red
            ((min_red > max_red) && ((r>=min_red) || (r<=max_red)))) && red_on) || //red
            ((((min_green < max_green) && ((g>=min_green) && (g<=max_green))) ||             //green
            ((min_green > max_green) && ((g>=min_green) || (g<=max_green)))) && green_on) || //green
            ((((min_blue < max_blue) && ((b>=min_blue) && (b<=max_blue))) ||            //blue
            ((min_blue > max_blue) && ((b>=min_blue) || (b<=max_blue)))) && blue_on) )  //blue
        {
          must_apply = true;
        }
      }
      if(must_apply == true)
      {
        QRgb rgb;
        rgb = color.rgb();
        im.setPixel(x,y,qRgba(qRed(rgb),qGreen(rgb),qBlue(rgb),qAlpha(0)));
        if(emit_progress)
        {
          if(stopped())
            return false;
          ++progresscnt;
          int p = int(100.0*double(progresscnt)/double(progress));
          if((p % 5 == 0) && (p > old_p))
          {
            old_p = p;
            emit signalFilterProgress(p);
            qApp->processEvents();
          }
        }
      }
    }
  }
  *image = im;
  return true;
}
/**  */
void TransparencyDialog::slotMaxHueChanged(int min)
{
  updatePreview();
}
/**  */
void TransparencyDialog::slotMinHueChanged(int max)
{
  updatePreview();
}
/**  */
void TransparencyDialog::slotMaxSatChanged(int min)
{
  updatePreview();
}
/**  */
void TransparencyDialog::slotMinSatChanged(int max)
{
  updatePreview();
}
/**  */
void TransparencyDialog::slotMaxValChanged(int min)
{
  updatePreview();
}
/**  */
void TransparencyDialog::slotMinValChanged(int max)
{
  updatePreview();
}
/**  */
void TransparencyDialog::slotMaxRedChanged(int min)
{
  updatePreview();
}
/**  */
void TransparencyDialog::slotMinRedChanged(int max)
{
  updatePreview();
}
/**  */
void TransparencyDialog::slotMaxGreenChanged(int min)
{
  updatePreview();
}
/**  */
void TransparencyDialog::slotMinGreenChanged(int max)
{
  updatePreview();
}
/**  */
void TransparencyDialog::slotMaxBlueChanged(int min)
{
  updatePreview();
}
/**  */
void TransparencyDialog::slotMinBlueChanged(int max)
{
  updatePreview();
}

/** No descriptions */
void TransparencyDialog::saveConfig()
{
  xmlConfig->setIntValue("FILTER_TRANSPARENCY_MAX_HUE",
                         mpMaxHueSlider->value());
  xmlConfig->setIntValue("FILTER_TRANSPARENCY_MIN_HUE",
                         mpMinHueSlider->value());
  xmlConfig->setBoolValue("FILTER_TRANSPARENCY_HUE_ON",
                         mpHueCheckBox->isChecked());
  xmlConfig->setIntValue("FILTER_TRANSPARENCY_MAX_SAT",
                         mpMaxSatSlider->value());
  xmlConfig->setIntValue("FILTER_TRANSPARENCY_MIN_SAT",
                         mpMinSatSlider->value());
  xmlConfig->setBoolValue("FILTER_TRANSPARENCY_SAT_ON",
                         mpSatCheckBox->isChecked());
  xmlConfig->setIntValue("FILTER_TRANSPARENCY_MAX_VAL",
                         mpMaxValSlider->value());
  xmlConfig->setIntValue("FILTER_TRANSPARENCY_MIN_VAL",
                         mpMinValSlider->value());
  xmlConfig->setBoolValue("FILTER_TRANSPARENCY_VAL_ON",
                         mpValCheckBox->isChecked());

  xmlConfig->setIntValue("FILTER_TRANSPARENCY_MAX_RED",
                         mpMaxRedSlider->value());
  xmlConfig->setIntValue("FILTER_TRANSPARENCY_MIN_RED",
                         mpMinRedSlider->value());
  xmlConfig->setBoolValue("FILTER_TRANSPARENCY_RED_ON",
                         mpRedCheckBox->isChecked());
  xmlConfig->setIntValue("FILTER_TRANSPARENCY_MAX_GREEN",
                         mpMaxGreenSlider->value());
  xmlConfig->setIntValue("FILTER_TRANSPARENCY_MIN_GREEN",
                         mpMinGreenSlider->value());
  xmlConfig->setBoolValue("FILTER_TRANSPARENCY_GREEN_ON",
                         mpGreenCheckBox->isChecked());
  xmlConfig->setIntValue("FILTER_TRANSPARENCY_MAX_BLUE",
                         mpMaxBlueSlider->value());
  xmlConfig->setIntValue("FILTER_TRANSPARENCY_MIN_BLUE",
                         mpMinBlueSlider->value());
  xmlConfig->setBoolValue("FILTER_TRANSPARENCY_BLUE_ON",
                         mpBlueCheckBox->isChecked());

  xmlConfig->setIntValue("FILTER_TRANSPARENCY_MODE",
                         mpTabWidget->currentPageIndex());

  xmlConfig->setBoolValue("FILTER_TRANSPARENCY_CONTINOUS_UPDATE",
                          continousUpdate());
}
/** No descriptions */
void TransparencyDialog::slotHueEnabled(bool enabled)
{
  mpMinHueSlider->setEnabled(enabled);
  mpMaxHueSlider->setEnabled(enabled);
  updatePreview();
}
/** No descriptions */
void TransparencyDialog::slotSatEnabled(bool enabled)
{
  mpMinSatSlider->setEnabled(enabled);
  mpMaxSatSlider->setEnabled(enabled);
  updatePreview();
}
/** No descriptions */
void TransparencyDialog::slotValEnabled(bool enabled)
{
  mpMinValSlider->setEnabled(enabled);
  mpMaxValSlider->setEnabled(enabled);
  updatePreview();
}
/** No descriptions */
void TransparencyDialog::slotRedEnabled(bool enabled)
{
  mpMinRedSlider->setEnabled(enabled);
  mpMaxRedSlider->setEnabled(enabled);
  updatePreview();
}
/** No descriptions */
void TransparencyDialog::slotGreenEnabled(bool enabled)
{
  mpMinGreenSlider->setEnabled(enabled);
  mpMaxGreenSlider->setEnabled(enabled);
  updatePreview();
}
/** No descriptions */
void TransparencyDialog::slotBlueEnabled(bool enabled)
{
  mpMinBlueSlider->setEnabled(enabled);
  mpMaxBlueSlider->setEnabled(enabled);
  updatePreview();
}
/** No descriptions */
void TransparencyDialog::slotChangeMode(QWidget*)
{
  updatePreview();
}
