use strict;
use Template;
use CGI qw(:standard);

$ENV{'HOME'} = "/Daten/collin";

our $session_timeout = 300;

use lib "/Daten/collin/Sources/projects/pronto-cvs/pronto/";
use lib "/Daten/collin/Sources/projects/pronto-cvs/pronto/web";
require "/Daten/collin/Sources/projects/pronto-cvs/pronto/prontolib.pl";

our($conn, %prefs, $template);

&read_prefs();
$conn = &open_db_conn;
$template = new Template({INCLUDE_PATH => "/Daten/collin/Sources/projects/pronto-cvs/pronto/web/templates",
			  POST_CHOMP => 1});

&check_session unless $main::no_session_check;

sub check_session {
  my $valid_till = time() + $session_timeout;
  my $sql = "UPDATE web_session SET valid_till = $valid_till WHERE session = " . param('session') .
      " AND valid_till > " . time();
  my $affected_rows = $conn->do($sql);
  if (!defined $affected_rows) {
    die $sql . ": " . $conn->errstr;
  }
  elsif ($affected_rows == 0) {
    die "Your session is no longer valid";
  }
}

sub html_die {
  my $message = shift;

  eval { #we must not die in this function => recursion
    print header, start_html("Error"), $message, end_html;
    exit 1;
  };
  if ($@) {
    print STDERR $@;
    exit 1;
  }
}


END {
  $conn->disconnect() if $conn;
}

1;
