#
# $Id: HtmlStripper.pm,v 1.1.1.1 2001/01/16 10:26:38 muhri Exp $
#

package HtmlStripper;

require HTML::Filter;

@ISA=qw(HTML::Filter);

%allowed = ();

foreach (split(/\s+/, $main::prefs{'HtmlAllowed'})) { $allowed{$_} = 1; };

sub comment { }
sub start
{
	my ($self, $tag, $attr, $attrseq, $origtext) = @_;
	if (! $allowed{$tag})
	{
#		print STDERR "killing tag $tag\n";
		return;
	}; 

# need a better attribute list for this to be ok to use - ai

	foreach (keys %$attr)
	{
		if (! ($allowed{"$tag:$_"} || $allowed{"$tag:*"}))
		{
			delete $attr->{$_};
			$origtext = '';
		};
	};
	$attrseq = [ keys %attr ];
    if (! $origtext)
	{
		$origtext = "<$tag";
		foreach (@$attrseq) { $origtext .= " $_=\"$attr->{$_}\" "; };
		$origtext .= ">";
	};

	$self->SUPER::start($tag, $attr, $attrseq, $origtext);
}

sub end
{
	my ($self, $tag, $origtext) = @_;
	if (! $allowed{$tag}) { return; }; 
	$self->SUPER::end($tag, $origtext);
}

sub output { push(@{$_[0]->{'fhtml'}}, $_[1]) }
sub filtered_html
{
#	print main::STDERR  join("", @{$_[0]->{'fhtml'}});
	return join("", @{$_[0]->{'fhtml'}});
}

1;
