//  $Id: groundtype.hxx,v 1.2 2002/09/27 11:26:43 torangan Exp $
// 
//  Pingus - A free Lemmings clone
//  Copyright (C) 2002 Ingo Ruhnke <grumbel@gmx.de>
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version 2
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
// 
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

#ifndef HEADER_PINGUS_GROUNDTYPE_HXX
#define HEADER_PINGUS_GROUNDTYPE_HXX

#include <string>

/** This class olds the definitions of the different types of ground
    available in pingus, it might also provide converter function from
    GPType to std::string and vice verse. */
class Groundtype
{
public:
  enum GPType { 
    GP_NOTHING,
    GP_SOLID, 
    GP_TRANSPARENT,
    GP_GROUND,
    GP_BRIDGE, 
    GP_WATER,
    GP_LAVA,
    GP_REMOVE, 
    GP_OUTOFSCREEN
  };

  static GPType      string_to_type (const std::string& arg_type);
  static std::string type_to_string (GPType arg_type);
};

#endif

/* EOF */
