(* $Id: simple-select-one-row.ml,v 1.1 2004/08/05 13:40:59 rwmj Exp $ *)

open Printf

open ExamplesLib

let () =
  (* Supply the name of the database on the command line. *)
  let dbname = if Array.length Sys.argv > 1 then Sys.argv.(1) else "rich" in

  let dbh = set_up_database dbname in

  (* A simple SELECT statement which returns one row. *)
  let sth = dbh#prepare "select sum (salary) from employees" in
  sth#execute [];

  (* '#fetch1int' is a shortcut method when you know the result tuple
   * contains a single integer.
   *)
  let sum = sth#fetch1int () in

  printf "Total salary for employees is $%d.\n" sum
