(* $Id: column-names.ml,v 1.1 2004/08/05 13:40:59 rwmj Exp $ *)

open Printf

open ExamplesLib

let () =
  (* Supply the name of the database on the command line. *)
  let dbname = if Array.length Sys.argv > 1 then Sys.argv.(1) else "rich" in

  let dbh = set_up_database dbname in

  (* Most databases support column names. *)
  let sth = dbh#prepare "select name, id as employee_id, salary
                           from employees
                          order by 1" in
  sth#execute [];

  let names = sth#names in

  sth#iter (fun row ->
	      let row = List.combine names row in
	      List.iter (function
			     (name, `String elem) ->
			       printf "%s = %s; " name elem
			   | (name, `Int elem) ->
			       printf "%s = %d; " name elem
			   | _ ->
			       assert false (* unknown column type *))
		row;
	      print_endline "")
