// vmessage.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// Subclass of InterViews Message class, allowing setting and retrieval of text
// value, and allowing greying out of value (for use in indicating inactive
// items.

#ifndef VMESSAGE_H
#ifdef __GNUG__
#pragma interface
#endif
#define VMESSAGE_H

#include <InterViews/message.h>
#include "localdefs.h"

class Painter;
class Pattern;

class VMessage : public Message {
	typedef Message Super;
public:
	VMessage(const char* msg, Alignment al=Left, int pad=0, boolean enabld=true);
	VMessage(const char* name, const char* msg, Alignment al=Left, int pad=0, boolean enabld=true);
	virtual ~VMessage();
	
	redefined void Highlight(boolean);
	
	void setText(const char *newtext);
	const char *getText() const { return text; }
	void enable(boolean);
	virtual boolean isEnabled() { return enabled; }
protected:
	redefined void Reconfig();
	redefined void Redraw(Coord, Coord, Coord, Coord);
private:
	void Init(const char *);
	char* sample;
	Painter* grayout;
	Pattern* gray_pat;
	boolean enabled;
};

class StatusBar : public VMessage {
	typedef VMessage Super;
public:
	StatusBar(const char* mesg);
	StatusBar(const char* name, const char* mesg);
	void setText(const char *newtext);
private:
	void Init();
};

#endif

