// vmessage.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifdef __GNUG__
#pragma implementation
#endif

#include <InterViews/canvas.h>
#include <InterViews/font.h>
#include <InterViews/pattern.h>
#include <InterViews/painter.h>
#include <InterViews/resource.h>
#include <InterViews/scene.h>
#include <InterViews/shape.h>
#include <InterViews/style.h>
#include <InterViews/window.h>
#include <InterViews/world.h>
#include <IV-X11/xwindow.h>
#include "localdefs.h"
#include "vmessage.h"

VMessage::VMessage(const char* msg, Alignment al, int pad, boolean enabld)
	: Message(msg, al, pad, 0, 0),
		enabled(enabld), grayout(nil), gray_pat(nil) {
	Init(msg);
}

VMessage::VMessage(const char* name, const char* msg, Alignment al, 
		int pad, boolean enabld) : Message(name, msg, al, pad, 0, 0),
			enabled(enabld), grayout(nil), gray_pat(nil) {
	Init(msg);
}

VMessage::~VMessage() {
	delete [] sample;
	Resource::unref(grayout);
	Resource::unref(gray_pat);
}

void
VMessage::Reconfig() {
    const Font* f = output->GetFont();
    shape->Rect(f->Width(sample) + pad + pad, f->Height() + pad + pad);
    shape->Rigid(0, hfil, 0, 0);
	grayout = new Painter(output);
	grayout->ref();
	grayout->SetColors(output->GetBgColor(), output->GetFgColor());
	gray_pat = new Pattern(Pattern::gray);
	gray_pat->ref();
	grayout->SetPattern(gray_pat);
	grayout->FillBg(false);
}

void 
VMessage::Redraw(Coord l, Coord b, Coord r, Coord t) {
	Message::Redraw(l, b, r, t);
	if(!isEnabled()) {
		grayout->Clip(canvas, l, b, r, t);
		grayout->FillRect(canvas, 0, 0, xmax, ymax);
		grayout->NoClip();
	}
}

void 
VMessage::Highlight(boolean b) {
	if(isEnabled())
		Message::Highlight(b);
}

void
VMessage::Init(const char* samp) {
	SetClassName("VMessage");
    sample = newstr(samp);
}

void
VMessage::enable(boolean b) {
	if(b != enabled) {
		enabled = b;
		Draw();
	}
}

void
VMessage::setText(const char *newtext) {
	if(!text || strcmp(text, newtext) != 0) {
		delete [] text;
		text = newstr(newtext);
		if (canvas != nil && canvas->status() == Canvas::mapped)
			Draw();
	}
}

// ************

StatusBar::StatusBar(const char* mesg) : VMessage(mesg, Center, 10) {
	Init();
}

StatusBar::StatusBar(const char* name, const char* mesg)
		: VMessage(name, mesg, Center, 10) {
	Init();
}

void
StatusBar::Init() {
	SetClassName("StatusBar");
}

// make window visible by raising to top of stack and display text

void
StatusBar::setText(const char *newtext) {
	VMessage::setText(newtext);
	World *w = GetWorld();
	if(w != nil) {
		ManagedWindow *top = GetTopLevelWindow();
		if(top != nil)
			top->raise();
//		w->Sync();
		w->flush();
	}
}
