// valuesetter.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

// ValueSetters, instantiated via templates, allow members of structs to be
// correctly loaded with values from disk, regardless of the in-memory
// offsets of the individual members.  Any necessary byte-swapping is handled
// here for cross-platform file i/o.

#ifndef VALUESETTER_H
#define VALUESETTER_H

#include "byteswap.h"
#include "datafile.h"

class ValueSetterBase {
public:
	virtual int readAndSet(DataFile *)=0;
	virtual int writeTo(DataFile *)=0;
};

template <class T>
class ValueSetter : public ValueSetterBase {
public:
	ValueSetter(T* ptr) : myPtr(ptr) {}
	redefined int readAndSet(DataFile *f) {
		int good = f->read((char *) myPtr, sizeof(*myPtr)).good();
		if(f->bytesAreSwapped()) *myPtr = swap(*myPtr);
		return good;
	}
	redefined int writeTo(DataFile *f) {
		T temp = f->bytesAreSwapped() ? swap(*myPtr) : *(const T *)myPtr;
		return f->write((char *) &temp, sizeof(temp)).good();
	}
private:
	T* myPtr;
};

template <class T>
inline ValueSetter<T>* newValueSetter(T* ptr) {
	return new ValueSetter<T>(ptr);
}

// BlockSetters allow reading and writing of undifferentiated char blocks

class BlockSetter : public ValueSetterBase {
public:
	BlockSetter(char* ptr, long nbytes) : myPtr(ptr), bytes(nbytes) {}
	redefined int readAndSet(DataFile *f) {
		return f->read(myPtr, bytes).good();
	}
	redefined int writeTo(DataFile *f) {
		return f->write(myPtr, bytes).good();
	}
private:
	char* myPtr;
	long bytes;
};

#endif
