// synthfunction.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// Specialized QueuedOutputFunction for all synthesis (output only) routines.

#ifndef SYNTHFUNCTION_H
#ifdef __GNUG__
#pragma interface
#endif
#define SYNTHFUNCTION_H

#include "outputfunction.h"
#include "wavetable.h"

class Data;

class SynthFunction : public QueuedOutputFunction {
	typedef QueuedOutputFunction Super;
	enum QSize { outQSize = 32 };
public:
	SynthFunction(Data* output, double amplitude=1.0);
	redefined const char* message() { return "Synthesizing..."; }
protected:
	redefined int doProcessing();
	virtual double doSynthesis() = 0;
protected:
	double myAmp;
};

class Buzz : public SynthFunction {
	typedef SynthFunction Super;
	enum TableSize { buzzTableSize = 1024 };
public:
	Buzz(Data* output);
	Buzz(Data* output, double freq, int nHarmonics, double amp=1.0);
	redefined void restoreState();
	virtual void set(double freq, int nHarmonics, double amp=1.0);
protected:
	redefined void initialize();
	redefined double doSynthesis();
	double tableLength();
private:
	SineTable mySineTable;
	double myPhase;
	double mySamplingIncr;
	double harmonicsX2;				// 2 x nharmonics cached for optimization
	double lengthOverHalfSR;		// cached for sampling incr calculation
};

#endif
