// soundblaster.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

#ifdef SOUNDBLASTER

#ifdef __GNUG__
#pragma implementation
#endif

#include "application.h"
#include "soundblaster.h"
#include <sys/sb.h>

SoundBlaster::SoundBlaster() : ConverterDevice("/dev/sbdsp") {}

SoundBlaster::~SoundBlaster() {
	stop();
}

boolean
SoundBlaster::isPlayableFormat(DataType type) {
	return (type == MuLawData);
}

DataType
SoundBlaster::bestPlayableType() {
	return MuLawData;
}

int
SoundBlaster::pause() {
	return false;
}

int
SoundBlaster::stop() {
	return ConverterDevice::stop();
}

int
SoundBlaster::checkSampleRate(int rate) {
	if(rate < 4000 || rate > 24000) {
		Application::alert("Sample rate must be 4000-24000 to be played.");
		return false;
	}
	return true;
}

int
SoundBlaster::checkChannels(int chans) {
	if(chans != 1) {
		Application::alert("Only monaural files may be played.");
		return false;
	}
	return true;
}

int
SoundBlaster::doConfigure() {
	int status = true;
	if(!reOpen())
		status = false;
	else if(ioctl(DSP_IOCTL_SPEED, sampleRate()) < 0) {
		error("Can't initialize device!");
		status = false;
	}
	return status;
}

#endif /* SOUNDBLASTER */
