// envelopeheader.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993 - 1999 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       April 20, 1999
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

#ifndef EVPHEADER_H
#ifdef __GNUG__
#pragma interface
#endif
#define EVPHEADER_H

#include "header.h"
#include "diskstruct.h"
#include "localdefs.h"
#include "requester.h"

class EnvelopeHeader : public Header {
	typedef Header Super;
	enum { EVP_MAGIC = 777, EVP_SWAPMAGIC = 0x9030000 };
	enum Points { EvpMinPoints = 8 };
	enum { EvpChannels = 1 };
public:		// class portion
	enum Type { None=0x1, With=0x2 };
	static Type defaultHeaderType() { return default_HeaderType; }
	static ByteOrder defaultByteOrder() { return default_ByteOrder; }
	static void setDefaultHeaderType(Type t) { default_HeaderType = t; }
	static void setDefaultByteOrder(ByteOrder b) { default_ByteOrder = b; }
public:		// object portion
	EnvelopeHeader(int npts, int srate);
	EnvelopeHeader();
	virtual int nPoints() { return _npoints; }
	virtual int sampleRate() { return _samprate; }
protected:
	redefined int diskHeaderSize() { return 20; }
	redefined int diskHeaderCommentSize() { return 4; }
	redefined boolean isMagic();
	redefined boolean magicIsSwapped();
	redefined boolean isLittleEndian();
	redefined int readInfo(DataFile *);
	redefined int checkHeader();
	redefined int writeInfo(DataFile *);
	redefined const char* magicError();
	redefined void reset();
protected:
	class EvpConfigRequester : public Header::ConfigRequester {
	    typedef Header::ConfigRequester Super;
	public:
	    EvpConfigRequester(Header* h);
	};
	friend EvpConfigRequester::EvpConfigRequester(Header *);

	class EvpStruct : public DiskStruct {
	    typedef DiskStruct Super;
	public:
	    EvpStruct(int m=EVP_MAGIC, int hs=0, int np=0, float sr=0)
	        : evpmagic(m), headersize(hs), npoints(np), srate(sr) {}
	    redefined long readSize();
	protected:
	    redefined ValueSetterBase** valueSetters();
	    enum { NumElements = 4 };
	private:
	    friend class EnvelopeHeader;
	    int	evpmagic,
		headersize,
		npoints;	// number of points in evp
	    float srate;	// sampling rate of orig data
	};
	friend EvpStruct::EvpStruct(int, int, int, float);

public:
	redefined Requester* configRequester() {
		return new EvpConfigRequester(this);
	}
private:
	int _samprate;
	int _npoints;
private:
	static Type default_HeaderType;
	static ByteOrder default_ByteOrder;
};

#endif
