/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/

/* setell.f -- translated by f2c (version of 16 February 1991  0:35:15).
   You must link the resulting object file with the libraries:
	-lf2c -lm -lc   (in that order)
*/

#include "f2c.h"

/* The following routines are needed to get this to compile using f2c */
#ifdef F2C_INCLUDE

#ifdef __GNUC__
#define INLINE inline
#else
#define INLINE	/* dont try inline functions for non-gnu C compilers */
#endif

INLINE double
cdabs_(z)
	doublecomplex *z;
{
	double hypot();
	return( hypot( z->r, z->i ) );
}

INLINE double
dreal_(x)
	doublecomplex *x;
{
	return x->r;
}

INLINE void
cdexp_(r, z)
	doublecomplex *r, *z;
{
	double d_exp(), cos(), sin();

	double expx = d_exp(&z->r);
	r->r = expx * cos(z->i);
	r->i = expx * sin(z->i);
}

void
cdsqrt_(r, z)
	doublecomplex *r, *z;
{
	double mag, sqrt(), hypot();

	if( (mag = hypot(z->r, z->i)) == 0.)
		r->r = r->i = 0.;
	else if(z->r > 0) {
		r->r = sqrt(0.5 * (mag + z->r) );
		r->i = z->i / r->r / 2;
	}
	else {
		r->i = sqrt(0.5 * (mag - z->r) );
		if(z->i < 0)
			r->i = - r->i;
		r->r = z->i / r->i /2;
	}
}

#endif /* F2C_INCLUDE */

/* Common Block Declarations */

static struct {
    double cn[30], cd[30];
    long mn, md;
    double const_;
} b_;

#define b_1 b_

static struct {
    double k, kprime, cosp0, w1, hpass;
} ellipt_;

#define ellipt_1 ellipt_

/* Table of constant values */

static long c__200 = 200;
static double c_b3 = 0.;
static double c_b11 = 10.;

/*<       subroutine setell(zsmpr,zf1,zf2,zf3,zripple,zatten,zretarr,nsects) >*/
/* Subroutine */ int setell_(zsmpr, zf1, zf2, zf3, zripple, zatten, zretarr, 
	nsects)
float *zsmpr, *zf1, *zf2, *zf3, *zripple, *zatten, *zretarr;
long *nsects;
{
    /* System generated locals */
    long i__1;

    /* Local variables */
    static double smpr, xnyq;
    static long i;
    static double atten;
    extern /* Subroutine */ int fresp_(), reset_();
    static double f1, f2, f3;
    static long m2;
    extern /* Subroutine */ int ellips_();
    static double ripple;
    static long jjj;

/*<       implicit real*8 (a-h,o-z)                                          >*/
/*<       real*4 zsmpr,zf1,zf2,zf3,zripple,zatten,zretarr >*/
/*<       dimension zretarr(1) >*/
/*<       common/b/cn(30),cd(30),mn,md,const                                 >*/
/*<       smpr = zsmpr >*/
    /* Parameter adjustments */
    --zretarr;

    /* Function Body */
    smpr = *zsmpr;
/*<       f1 = zf1 >*/
    f1 = *zf1;
/*<       f2 = zf2 >*/
    f2 = *zf2;
/*<       f3 = zf3 >*/
    f3 = *zf3;
/*<       ripple = zripple >*/
    ripple = *zripple;
/*<       atten = zatten >*/
    atten = *zatten;
/*<       call reset                                                         >*/
    reset_();
/*<       xnyq=smpr/2.d0                                                     >*/
    xnyq = smpr / 2.;
/*<       call ellips(f1,f2,f3,ripple,atten,smpr)                            >*/
    ellips_(&f1, &f2, &f3, &ripple, &atten, &smpr);
/*<       call fresp(200,smpr,0.d0,xnyq,f1)                                  >*/
    fresp_(&c__200, &smpr, &c_b3, &xnyq, &f1);
/*<       m2=mn/2                                                            >*/
    m2 = b_1.mn / 2;
/*<       nsects=m2 >*/
    *nsects = m2;
/*<       jjj=1 >*/
    jjj = 1;
/*<       do 1414 i=1,mn >*/
    i__1 = b_1.mn;
    for (i = 1; i <= i__1; ++i) {
/*< 	zretarr(jjj)=cn(i) >*/
	zretarr[jjj] = b_1.cn[i - 1];
/*< 	zretarr(jjj+1)=cd(i) >*/
	zretarr[jjj + 1] = b_1.cd[i - 1];
/*< 	jjj=jjj+2 >*/
	jjj += 2;
/*< 1414  continue >*/
/* L1414: */
    }
/*<       zretarr(jjj)=const >*/
    zretarr[jjj] = b_1.const_;
/*<       return                                                             >*/
    return 0;
/*<       end                                                                >*/
} /* setell_ */

/*<       subroutine reset                                                   >*/
/* Subroutine */ int reset_()
{
    static long m;

/*<       implicit real*8 (a-h,o-z)                                          >*/
/*<       common/b/cn(30),cd(30),mn,md,const                                 >*/
/*<       mn=0                                                               >*/
    b_1.mn = 0;
/*<       md=0     >*/
    b_1.md = 0;
/*<       do 100 m=1,30                                                      >*/
    for (m = 1; m <= 30; ++m) {
/*<       cn(m)=0.                                                           >*/
	b_1.cn[m - 1] = (float)0.;
/*<       cd(m)=0.                                                           >*/
	b_1.cd[m - 1] = (float)0.;
/*< 100   continue                                                           >*/
/* L100: */
    }
/*<       return                                                             >*/
    return 0;
/*<       end                                                                >*/
} /* reset_ */

/*<       subroutine ellips(f1,f2,f3,ripple,atten,samr)                      >*/
/* Subroutine */ int ellips_(f1, f2, f3, ripple, atten, samr)
double *f1, *f2, *f3, *ripple, *atten, *samr;
{
    /* System generated locals */
    long i__1;
    double d__1, d__2, d__3, d__4, d__5, d__6;

    /* Builtin functions */
    double tan(), cos(), sin(), sqrt(), pow_dd(), log();

    /* Local variables */
    static double a;
    static long i, n;
    static double k1;
    static long n2;
    static double u0, w2, w3, k1prim, dd, de;
    extern /* Subroutine */ int stuff1_();
    static double kk, pi, nn, tt, kk1;
    extern double kay_();
    static double kkp, eps, kk1p;

/*   designs an elliptic filter. all parameters real*8 . */
/*   f3=0 -> lowpass or highpass. f1=passband cutoff. f2=stopband cutoff. 
*/
/*   f1<f2 -> lowpass. */
/*   f3>0 -> bandpass. f1,f2 are limits of passband. f3 is limit of */
/*   either high or low stopband. we require f1<f2. */
/*   ripple=passband ripple in db. atten=stopband attenuation in db. */
/*   samr=sampling rate in hz. */
/*    after gold+rader; written by bilofsky, revised by steiglitz */
/*    pp.61-65 (elliptic filters), 72,76 (mappings */
/*    from s-plane to z-plane), 87 (approximation */
/*    for u0 and evaluation of elliptic functions). */
/*<       implicit real*8 (a-h,o-z)                                          >*/
/*<       real*8 k,k1,kay,kprime,k1prim ,nn,kk,kkp,kk1,kk1p                  >*/
/*<       common/ellipt/k,kprime,cosp0,w1,hpass                              >*/
/*<       prime(dummy)=dsqrt(1.d0-dummy**2)                                  >*/
/*<       bpt(w)=dabs((cosp0-dcos(w))/dsin(w))                               >*/
/*<       pi=3.14159265358979d0                                              >*/
    pi = 3.14159265358979;
/*<       w1=2.d0*pi*f1/samr                                                 >*/
    ellipt_1.w1 = pi * 2. * *f1 / *samr;
/*<       w2=2.d0*pi*f2/samr                                                 >*/
    w2 = pi * 2. * *f2 / *samr;
/*<       w3=2.d0*pi*f3/samr                                                 >*/
    w3 = pi * 2. * *f3 / *samr;
/*<       hpass=0.d0                                                         >*/
    ellipt_1.hpass = 0.;
/*<       cosp0=0.d0                                                         >*/
    ellipt_1.cosp0 = 0.;
/*<       if(f3.gt.0.d0)goto1                                                >*/
    if (*f3 > 0.) {
	goto L1;
    }
/*<       if(f1.lt.f2)goto2                                                  >*/
    if (*f1 < *f2) {
	goto L2;
    }
/*  modify frequencies for high pass. */
/*<       w1=pi-w1                                                           >*/
    ellipt_1.w1 = pi - ellipt_1.w1;
/*<       w2=pi-w2                                                           >*/
    w2 = pi - w2;
/*<       hpass=1.d0                                                         >*/
    ellipt_1.hpass = 1.;
/*  compute analog frequencies for low/high pass */
/*<     2 w1=dtan(.5d0*w1)                                                   >*/
L2:
    ellipt_1.w1 = tan(ellipt_1.w1 * .5);
/*<       w2=dtan(.5d0*w2)                                                   >*/
    w2 = tan(w2 * .5);
/*<       goto3                                                              >*/
    goto L3;
/*  compute analog frequencies for band pass. */
/*<     1 cosp0=dcos((w1+w2)/2.d0)/dcos((w1-w2)/2.d0)                        >*/
L1:
    ellipt_1.cosp0 = cos((ellipt_1.w1 + w2) / 2.) / cos((ellipt_1.w1 - w2) / 
	    2.);
/*<       w1=bpt(w1)                                                         >*/
    ellipt_1.w1 = (d__1 = (ellipt_1.cosp0 - cos(ellipt_1.w1)) / sin(
	    ellipt_1.w1), abs(d__1));
/*<       de=w3-w2                                                           >*/
    de = w3 - w2;
/*<       if (de.lt.0.d0) de=w1-w3                                           >*/
    if (de < 0.) {
	de = ellipt_1.w1 - w3;
    }
/*<       w2=dmin1(bpt(w1-de),bpt(w2+de))                                    >*/
    d__1 = ellipt_1.w1 - de;
    d__3 = w2 + de;
/* Computing MIN */
    d__5 = (d__2 = (ellipt_1.cosp0 - cos(d__1)) / sin(d__1), abs(d__2)), d__6 
	    = (d__4 = (ellipt_1.cosp0 - cos(d__3)) / sin(d__3), abs(d__4));
    w2 = min(d__5,d__6);
/*  compute params for poles,zeros in lambda plane */
/*< 3     k=w1/w2                                                            >*/
L3:
    ellipt_1.k = ellipt_1.w1 / w2;
/*<       kprime=prime(k)                                                    >*/
/* Computing 2nd power */
    d__1 = ellipt_1.k;
    ellipt_1.kprime = sqrt(1. - d__1 * d__1);
/*<       eps=dsqrt(10.d0**(.1d0*ripple)-1.d0)                               >*/
    d__1 = *ripple * .1;
    eps = sqrt(pow_dd(&c_b11, &d__1) - 1.);
/*<       a=10.d0**(.05d0*atten)                                             >*/
    d__1 = *atten * .05;
    a = pow_dd(&c_b11, &d__1);
/*<       k1=eps/dsqrt(a*a-1.d0)                                             >*/
    k1 = eps / sqrt(a * a - 1.);
/*<       k1prim =prime(k1)                                                  >*/
/* Computing 2nd power */
    d__1 = k1;
    k1prim = sqrt(1. - d__1 * d__1);
/*<       kk=kay(k)                                                          >*/
    kk = kay_(&ellipt_1.k);
/*<       kk1=kay(k1)                                                        >*/
    kk1 = kay_(&k1);
/*<       kkp=kay(kprime)                                                    >*/
    kkp = kay_(&ellipt_1.kprime);
/*<       kk1p=kay(k1prim )                                                  >*/
    kk1p = kay_(&k1prim);
/*<       n=idint(kk1p*kk/(kk1*kkp))+1                                       >*/
    n = (long) (kk1p * kk / (kk1 * kkp)) + 1;
/*<       nn=n                                                               >*/
    nn = (double) n;
/*<     5 u0=-kkp*dlog((1.d0+dsqrt(1.d0+eps*eps))/eps)/kk1p                  >*/
/* L5: */
    u0 = -kkp * log((sqrt(eps * eps + 1.) + 1.) / eps) / kk1p;
/*  now compute poles,zeros in lambda plane, */
/*    transform one by one to z plane. */
/*<       dd=kk/nn                                                           >*/
    dd = kk / nn;
/*<       tt=kk-dd                                                           >*/
    tt = kk - dd;
/*<       dd=dd+dd                                                           >*/
    dd += dd;
/*<       n2=(n+1)/2                                                         >*/
    n2 = (n + 1) / 2;
/*<       do 4 i=1,n2                                                        >*/
    i__1 = n2;
    for (i = 1; i <= i__1; ++i) {
/*<       if (i*2.gt.n) tt=0.d0                                              >*/
	if (i << 1 > n) {
	    tt = 0.;
	}
/*<       call stuff1(-kkp,tt,'zero')                                        >*/
	d__1 = -kkp;
	stuff1_(&d__1, &tt, "zero", 4L);
/*<       call stuff1(u0,tt,'pole')                                          >*/
	stuff1_(&u0, &tt, "pole", 4L);
/*< 4     tt=tt-dd                                                           >*/
/* L4: */
	tt -= dd;
    }
/*<       return                                                             >*/
    return 0;
/*<       end                                                                >*/
} /* ellips_ */

/*<       subroutine stuff1(q,r,whatsi )                                     >*/
/* Subroutine */ int stuff1_(q, r, whatsi, whatsi_len)
double *q, *r;
char *whatsi;
long whatsi_len;
{
    /* System generated locals */
    double d__1, d__2, d__3;
    doublecomplex z__1, z__2, z__3, z__4, z__5, z__6, z__7, z__8;

    /* Builtin functions */
    void z_div();
    double d_imag();
    void d_cnjg();
    long s_cmp();

    /* Local variables */
    static double cnqp, dnqp, snqp;
    static long j;
    static doublecomplex s;
    extern /* Subroutine */ int djelf_();
    extern double dreal_();
    static double omega, x;
    static doublecomplex z;
    static double sigma;
    static double cnr, dnr, snr;

/*    transforms poles and zeros to z-plane; stuffs coeff. array */
/*<       implicit real*8 (a-h,o-z)                                          >*/
/*<       real*8 k,kprime                                                    >*/
/*<       common/b/cn(30),cd(30),mn,md,const                                 >*/
/*<       character*4 whatsi                                                 >*/
/*<       complex*16 dcmplx,cdsqrt,dconjg,z,s                                >*/
/*<       common/ellipt/k,kprime,cosp0,w1,hpass                              >*/
/*<       call djelf(snr,cnr,dnr,r,kprime*kprime)                            >*/
    d__1 = ellipt_1.kprime * ellipt_1.kprime;
    djelf_(&snr, &cnr, &dnr, r, &d__1);
/*<       call djelf(snqp,cnqp,dnqp,q,k*k)                                   >*/
    d__1 = ellipt_1.k * ellipt_1.k;
    djelf_(&snqp, &cnqp, &dnqp, q, &d__1);
/*<       omega=1-snqp*snqp*dnr*dnr                                          >*/
    omega = 1 - snqp * snqp * dnr * dnr;
/*<       if ( omega .eq. 0.d0 ) omega=1.d-30                                >*/
    if (omega == 0.) {
	omega = 1e-30;
    }
/*<       sigma=w1*snqp*cnqp*cnr*dnr/omega                                   >*/
    sigma = ellipt_1.w1 * snqp * cnqp * cnr * dnr / omega;
/*<       omega=w1*snr*dnqp/omega                                            >*/
    omega = ellipt_1.w1 * snr * dnqp / omega;
/*<       s=dcmplx(sigma,omega)                                              >*/
    z__1.r = sigma, z__1.i = omega;
    s.r = z__1.r, s.i = z__1.i;
/*<       j=1                                                                >*/
    j = 1;
/*<       if (cosp0.eq.0.d0) goto 1                                          >*/
    if (ellipt_1.cosp0 == 0.) {
	goto L1;
    }
/*<       j=-1                                                               >*/
    j = -1;
/*<     4 z=(-cosp0+dfloat(j)*cdsqrt(cosp0*cosp0+s*s-1.d0))/(s-1.d0)         >*/
L4:
    d__1 = -ellipt_1.cosp0;
    d__2 = (double) j;
    d__3 = ellipt_1.cosp0 * ellipt_1.cosp0;
    z__7.r = s.r * s.r - s.i * s.i, z__7.i = s.r * s.i + s.i * s.r;
    z__6.r = d__3 + z__7.r, z__6.i = z__7.i;
    z__5.r = z__6.r - 1., z__5.i = z__6.i;
    cdsqrt_(&z__4, &z__5);
    z__3.r = d__2 * z__4.r, z__3.i = d__2 * z__4.i;
    z__2.r = d__1 + z__3.r, z__2.i = z__3.i;
    z__8.r = s.r - 1., z__8.i = s.i;
    z_div(&z__1, &z__2, &z__8);
    z.r = z__1.r, z.i = z__1.i;
/*<       go to 3                                                            >*/
    goto L3;
/*<     1 z=(1.d0+s)/(1.d0-s)                                                >*/
L1:
    z__2.r = s.r + 1., z__2.i = s.i;
    z__3.r = 1. - s.r, z__3.i = -s.i;
    z_div(&z__1, &z__2, &z__3);
    z.r = z__1.r, z.i = z__1.i;
/*<       if(hpass.ne.0.d0)z=-z                                              >*/
    if (ellipt_1.hpass != 0.) {
	z__1.r = -z.r, z__1.i = -z.i;
	z.r = z__1.r, z.i = z__1.i;
    }
/*<     3 if(dabs(dimag(z)).le.10.d-10) goto 2                               >*/
L3:
    if ((d__1 = d_imag(&z), abs(d__1)) <= 1e-9) {
	goto L2;
    }
/*<       if(dimag(z).lt.0.d0) z=dconjg(z)                                   >*/
    if (d_imag(&z) < 0.) {
	d_cnjg(&z__1, &z);
	z.r = z__1.r, z.i = z__1.i;
    }
/*<       if(whatsi.eq.'pole')goto5                                          >*/
    if (s_cmp(whatsi, "pole", 4L, 4L) == 0) {
	goto L5;
    }
/*<       mn=mn+1                                                            >*/
    ++b_1.mn;
/*<       cn(mn)=-2.d0*dreal(z)                                              >*/
    b_1.cn[b_1.mn - 1] = dreal_(&z) * -2.;
/*<       mn=mn+1                                                            >*/
    ++b_1.mn;
/*<       cn(mn)=dreal(z)**2+dimag(z)**2                                     >*/
/* Computing 2nd power */
    d__1 = dreal_(&z);
/* Computing 2nd power */
    d__2 = d_imag(&z);
    b_1.cn[b_1.mn - 1] = d__1 * d__1 + d__2 * d__2;
/*<       goto6                                                              >*/
    goto L6;
/*<     5 md=md+1                                                            >*/
L5:
    ++b_1.md;
/*<       cd(md)=-2.d0*dreal(z)                                              >*/
    b_1.cd[b_1.md - 1] = dreal_(&z) * -2.;
/*<       md=md+1                                                            >*/
    ++b_1.md;
/*<       cd(md)=dreal(z)**2+dimag(z)**2                                     >*/
/* Computing 2nd power */
    d__1 = dreal_(&z);
/* Computing 2nd power */
    d__2 = d_imag(&z);
    b_1.cd[b_1.md - 1] = d__1 * d__1 + d__2 * d__2;
/*<     6 continue >*/
L6:
/*    6 write(6,202)whatsi,z */
/*<   202 format(' complex ',a4,' pair at ',d17.9,' +-j',d17.9)              >*/
/* L202: */
/*<       if(j.gt.0.or.r.eq.0.d0)return                                      >*/
    if (j > 0 || *r == 0.) {
	return 0;
    }
/*<       j=1                                                                >*/
    j = 1;
/*<       go to 4                                                            >*/
    goto L4;
/*<     2 x=dreal(z)                                                         >*/
L2:
    x = dreal_(&z);
/*<       if(whatsi.eq.'pole')goto7                                          >*/
    if (s_cmp(whatsi, "pole", 4L, 4L) == 0) {
	goto L7;
    }
/*<       mn=mn+1                                                            >*/
    ++b_1.mn;
/*<       cn(mn)=-x                                                          >*/
    b_1.cn[b_1.mn - 1] = -x;
/*<       mn=mn+1                                                            >*/
    ++b_1.mn;
/*<       cn(mn)=0.d0                                                        >*/
    b_1.cn[b_1.mn - 1] = 0.;
/*<       goto8                                                              >*/
    goto L8;
/*<     7 md=md+1                                                            >*/
L7:
    ++b_1.md;
/*<       cd(md)=-x                                                          >*/
    b_1.cd[b_1.md - 1] = -x;
/*<       md=md+1                                                            >*/
    ++b_1.md;
/*<       cd(md)=0.d0                                                        >*/
    b_1.cd[b_1.md - 1] = 0.;
/*<     8 continue >*/
L8:
/*    8 write(6,201)whatsi,x */
/*<   201 format(' real ',a4,' at ',d17.9)                                   >*/
/* L201: */
/*<       if(j.gt.0) return                                                  >*/
    if (j > 0) {
	return 0;
    }
/*<       j=1                                                                >*/
    j = 1;
/*<       go to 4                                                            >*/
    goto L4;
/*<       end                                                                >*/
} /* stuff1_ */

/*<       subroutine fresp(k,samr,f1,f2,f3)                                  >*/
/* Subroutine */ int fresp_(k, samr, f1, f2, f3)
long *k;
double *samr, *f1, *f2, *f3;
{
    /* System generated locals */
    long i__1, i__2, i__3, i__4, i__5, i__6;
    double d__1;
    doublecomplex z__1, z__2, z__3, z__4, z__5, z__6, z__7, z__8, z__9, z__10;


    /* Builtin functions */
    void z_div();
    double d_imag(), atan2(), d_lg10();

    /* Local variables */
    static double freq;
    static long i, j;
    static double w, x;
    static double y, phase;
    static long m2;
    static double db, pi;
    static doublecomplex tf, zm, zm2;
    static double amp;

/*    plots k pts. of freq. resp. from f1 to f2, norm. at f3 */
/*<       implicit real*8 (a-h,o-z)                                          >*/
/*<       complex*16 dcmplx,cdexp,tf,zm,zm2                                  >*/
/*<       common/b/cn(30),cd(30),mn,md,const                                 >*/
/*<       pi=3.14159265358979d0                                              >*/
    pi = 3.14159265358979;
/*<       m2=mn/2                                                            >*/
    m2 = b_1.mn / 2;
/*      write(8,200)m2,(cn(i),cd(i),i=1,mn) */
/*<   200 format('elliptic filter with ',i5,' sections'/4(d17.9))            >*/
/* L200: */
/*<       w=pi*f3/(.5d0*samr)                                                >*/
    w = pi * *f3 / (*samr * .5);
/*<       zm=cdexp(dcmplx(0.d0,-1.d0*w))                                     >*/
    d__1 = w * -1.;
    z__2.r = 0., z__2.i = d__1;
    cdexp_(&z__1, &z__2);
    zm.r = z__1.r, zm.i = z__1.i;
/*<       zm2=zm*zm                                                          >*/
    z__1.r = zm.r * zm.r - zm.i * zm.i, z__1.i = zm.r * zm.i + zm.i * zm.r;
    zm2.r = z__1.r, zm2.i = z__1.i;
/*<       tf=(1.d0,0.d0)                                                     >*/
    tf.r = 1., tf.i = 0.;
/*<       do 1 i=1,mn,2                                                      >*/
    i__1 = b_1.mn;
    for (i = 1; i <= i__1; i += 2) {
/*<     1 tf=tf*(1.d0+cn(i)*zm+cn(i+1)*zm2)/(1.d0+cd(i)*zm+cd(i+1)*zm2)      >*/
/* L1: */
	i__2 = i - 1;
	z__5.r = b_1.cn[i__2] * zm.r, z__5.i = b_1.cn[i__2] * zm.i;
	z__4.r = z__5.r + 1., z__4.i = z__5.i;
	i__3 = i;
	z__6.r = b_1.cn[i__3] * zm2.r, z__6.i = b_1.cn[i__3] * zm2.i;
	z__3.r = z__4.r + z__6.r, z__3.i = z__4.i + z__6.i;
	z__2.r = tf.r * z__3.r - tf.i * z__3.i, z__2.i = tf.r * z__3.i + tf.i 
		* z__3.r;
	i__4 = i - 1;
	z__9.r = b_1.cd[i__4] * zm.r, z__9.i = b_1.cd[i__4] * zm.i;
	z__8.r = z__9.r + 1., z__8.i = z__9.i;
	i__5 = i;
	z__10.r = b_1.cd[i__5] * zm2.r, z__10.i = b_1.cd[i__5] * zm2.i;
	z__7.r = z__8.r + z__10.r, z__7.i = z__8.i + z__10.i;
	z_div(&z__1, &z__2, &z__7);
	tf.r = z__1.r, tf.i = z__1.i;
    }
/*<       const=1.d0/cdabs(tf)                                               >*/
    b_1.const_ = 1. / cdabs_(&tf);
/*      write(8,201)const */
/*<   201 format(' const=',d17.9)                                            >*/
/* L201: */
/*      write(8,205) */
/*<   205 format('/   freq     phase',10x,'    amp',10x,'    db.')           >*/
/* L205: */
/*<       do 3 j=1,k                                                         >*/
    i__2 = *k;
    for (j = 1; j <= i__2; ++j) {
/*<       freq=f1+(f2-f1)*dfloat(j-1)/dfloat(k-1)                            >*/
	freq = *f1 + (*f2 - *f1) * (double) (j - 1) / (double) (*k - 
		1);
/*<       w=pi*freq/(.5d0*samr)                                              >*/
	w = pi * freq / (*samr * .5);
/*<       zm=cdexp(dcmplx(0.d0,-1.d0*w))                                     >*/
	d__1 = w * -1.;
	z__2.r = 0., z__2.i = d__1;
	cdexp_(&z__1, &z__2);
	zm.r = z__1.r, zm.i = z__1.i;
/*<       zm2=zm*zm                                                          >*/
	z__1.r = zm.r * zm.r - zm.i * zm.i, z__1.i = zm.r * zm.i + zm.i * 
		zm.r;
	zm2.r = z__1.r, zm2.i = z__1.i;
/*<       tf=dcmplx(const,0.d0)                                              >*/
	z__1.r = b_1.const_, z__1.i = 0.;
	tf.r = z__1.r, tf.i = z__1.i;
/*<       do 2 i=1,mn,2                                                      >*/
	i__3 = b_1.mn;
	for (i = 1; i <= i__3; i += 2) {
/*<     2 tf=tf*(1.d0+cn(i)*zm+cn(i+1)*zm2)/(1.d0+cd(i)*zm+cd(i+1)*zm2)      >*/
/* L2: */
	    i__4 = i - 1;
	    z__5.r = b_1.cn[i__4] * zm.r, z__5.i = b_1.cn[i__4] * zm.i;
	    z__4.r = z__5.r + 1., z__4.i = z__5.i;
	    i__5 = i;
	    z__6.r = b_1.cn[i__5] * zm2.r, z__6.i = b_1.cn[i__5] * zm2.i;
	    z__3.r = z__4.r + z__6.r, z__3.i = z__4.i + z__6.i;
	    z__2.r = tf.r * z__3.r - tf.i * z__3.i, z__2.i = tf.r * z__3.i + 
		    tf.i * z__3.r;
	    i__1 = i - 1;
	    z__9.r = b_1.cd[i__1] * zm.r, z__9.i = b_1.cd[i__1] * zm.i;
	    z__8.r = z__9.r + 1., z__8.i = z__9.i;
	    i__6 = i;
	    z__10.r = b_1.cd[i__6] * zm2.r, z__10.i = b_1.cd[i__6] * zm2.i;
	    z__7.r = z__8.r + z__10.r, z__7.i = z__8.i + z__10.i;
	    z_div(&z__1, &z__2, &z__7);
	    tf.r = z__1.r, tf.i = z__1.i;
	}
/*<       amp=cdabs(tf)                                                      >*/
	amp = cdabs_(&tf);
/*<       if(amp.le.1.d-20)amp=1.d-20                                        >*/
	if (amp <= 1e-20) {
	    amp = 1e-20;
	}
/*<       x=dreal(tf)                                                        >*/
	x = dreal_(&tf);
/*<       y=dimag(tf)                                                        >*/
	y = d_imag(&tf);
/*<       phase=0.d0                                                         >*/
	phase = 0.;
/*<       if(x.eq.0.d0 .and. y.eq.0.d0)goto4                                 >*/
	if (x == 0. && y == 0.) {
	    goto L4;
	}
/*<       phase=(180.d0/pi)*datan2(y,x)                                      >*/
	phase = 180. / pi * atan2(y, x);
/*<     4 db=20.d0*dlog10(dmax1(amp,1.d-40))                                 >*/
L4:
	d__1 = max(amp,1e-40);
	db = d_lg10(&d__1) * 20.;
/*<     3 continue >*/
/* L3: */
    }
/*    3 write(8,202)freq,phase,amp,db */
/*<   202 format(' ',f10.2,2d17.9,f12.4)                                     >*/
/* L202: */
/*<       return                                                             >*/
    return 0;
/*<       end                                                                >*/
} /* fresp_ */

/*<       double precision function kay(k)                                   >*/
double kay_(k)
double *k;
{
    /* Initialized data */

    static double a[5] = { 1.38629436112,.09666344259,.03590092383,
	    .03742563713,.01451196212 };
    static double b[5] = { .5,.12498593597,.06880248576,.03328355346,
	    .00441787012 };

    /* System generated locals */
    double ret_val;

    /* Builtin functions */
    double log();

    /* Local variables */
    static double peta;
    static long i;
    static double kk, eta;

/*    computes kay(k)=inverse sn(1) */
/*    hastings, approx. for dig. comp., p. 172 */
/*<       implicit real*8 (a-h,o-z)                                          >*/
/*<       double precision k,eta,peta,kk                                     >*/
/*<       dimension a(5),b(5)                                                >*/
/*<    >*/
/*<    >*/
/*<       kay=a(1)                                                           >*/
    ret_val = a[0];
/*<       kk=b(1)                                                            >*/
    kk = b[0];
/*<       eta=1.d0-k*k                                                       >*/
    eta = 1. - *k * *k;
/*<       peta=eta                                                           >*/
    peta = eta;
/*<       do 1 i=2,5                                                         >*/
    for (i = 2; i <= 5; ++i) {
/*<       kay=kay+a(i)*peta                                                  >*/
	ret_val += a[i - 1] * peta;
/*<       kk=kk+b(i)*peta                                                    >*/
	kk += b[i - 1] * peta;
/*< 1     peta=peta*eta                                                      >*/
/* L1: */
	peta *= eta;
    }
/*<       kay=kay-kk*dlog(eta)                                               >*/
    ret_val -= kk * log(eta);
/*<       return                                                             >*/
    return ret_val;
/*<       end                                                                >*/
} /* kay_ */

/*<       subroutine djelf(sn, cn, dn, x, sck)                               >*/
/* Subroutine */ int djelf_(sn, cn, dn, x, sck)
double *sn, *cn, *dn, *x, *sck;
{
    /* System generated locals */
    long i__1;
    double d__1;

    /* Builtin functions */
    double exp(), sqrt(), sin(), cos();

    /* Local variables */
    static double a, b, c, d;
    static long i, k, l;
    static double y, cm, geo[12], ari[12];

/*     ssp program: finds jacobian elliptic functions sn,cn,dn. */
/*<       implicit real*8 (a-h,o-z)                                          >*/
/*<       dimension ari(12),geo(12)                                          >*/
/*<    >*/
/*<       cm=sck                                                             >*/
    cm = *sck;
/*<       y=x                                                                >*/
    y = *x;
/*<       if(sck)3,1,4                                                       >*/
    if (*sck < 0.) {
	goto L3;
    } else if (*sck == 0) {
	goto L1;
    } else {
	goto L4;
    }
/*<     1 d=dexp(x)                                                          >*/
L1:
    d = exp(*x);
/*<       a=1.d0/d                                                           >*/
    a = 1. / d;
/*<       b=a+d                                                              >*/
    b = a + d;
/*<       cn=2.d0/b                                                          >*/
    *cn = 2. / b;
/*<       dn=cn                                                              >*/
    *dn = *cn;
/*<       a=(d-a)/2.d0                                                       >*/
    a = (d - a) / 2.;
/*<       sn=a*cn                                                            >*/
    *sn = a * *cn;
/*<     2 return                                                             >*/
L2:
    return 0;
/*<     3 d=1.d0-sck                                                         >*/
L3:
    d = 1. - *sck;
/*<       cm=-sck/d                                                          >*/
    cm = -(*sck) / d;
/*<       d=dsqrt(d)                                                         >*/
    d = sqrt(d);
/*<       y=d*x                                                              >*/
    y = d * *x;
/*<     4 a=1.d0                                                             >*/
L4:
    a = 1.;
/*<       dn=1.d0                                                            >*/
    *dn = 1.;
/*<       do 6 i=1,12                                                        >*/
    for (i = 1; i <= 12; ++i) {
/*<       l=i                                                                >*/
	l = i;
/*<       ari(i)=a                                                           >*/
	ari[i - 1] = a;
/*<       cm=dsqrt(cm)                                                       >*/
	cm = sqrt(cm);
/*<       geo(i)=cm                                                          >*/
	geo[i - 1] = cm;
/*<       c=(a+cm)*.5d0                                                      >*/
	c = (a + cm) * .5;
/*<       if(dabs(a-cm)-1.d-9*a)7,7,5                                        >*/
	if ((d__1 = a - cm, abs(d__1)) - a * 1e-9 <= 0.) {
	    goto L7;
	} else {
	    goto L5;
	}
/*<     5 cm=a*cm                                                            >*/
L5:
	cm = a * cm;
/*<     6 a=c                                                                >*/
/* L6: */
	a = c;
    }
/*<     7 y=c*y                                                              >*/
L7:
    y = c * y;
/*<       sn=dsin(y)                                                         >*/
    *sn = sin(y);
/*<       cn=dcos(y)                                                         >*/
    *cn = cos(y);
/*<       if(sn)8,13,8                                                       >*/
    if (*sn != 0.) {
	goto L8;
    } else {
	goto L13;
    }
/*<     8 a=cn/sn                                                            >*/
L8:
    a = *cn / *sn;
/*<       c=a*c                                                              >*/
    c = a * c;
/*<       do 9 i=1,l                                                         >*/
    i__1 = l;
    for (i = 1; i <= i__1; ++i) {
/*<       k=l-i+1                                                            >*/
	k = l - i + 1;
/*<       b=ari(k)                                                           >*/
	b = ari[k - 1];
/*<       a=c*a                                                              >*/
	a = c * a;
/*<       c=dn*c                                                             >*/
	c = *dn * c;
/*<       dn=(geo(k)+a)/(b+a)                                                >*/
	*dn = (geo[k - 1] + a) / (b + a);
/*<     9 a=c/b                                                              >*/
/* L9: */
	a = c / b;
    }
/*<       a=1.d0/dsqrt(c*c+1.d0)                                             >*/
    a = 1. / sqrt(c * c + 1.);
/*<       if(sn)10,11,11                                                     >*/
    if (*sn >= 0.) {
	goto L11;
    } else {
	goto L10;
    }
/*<    10 sn=-a                                                              >*/
L10:
    *sn = -a;
/*<       goto 12                                                            >*/
    goto L12;
/*<    11 sn=a                                                               >*/
L11:
    *sn = a;
/*<    12 cn=c*sn                                                            >*/
L12:
    *cn = c * *sn;
/*<    13 if(sck)14,2,2                                                      >*/
L13:
    if (*sck >= 0.) {
	goto L2;
    } else {
	goto L14;
    }
/*<    14 a=dn                                                               >*/
L14:
    a = *dn;
/*<       dn=cn                                                              >*/
    *dn = *cn;
/*<       cn=a                                                               >*/
    *cn = a;
/*<       sn=sn/d                                                            >*/
    *sn /= d;
/*<       return                                                             >*/
    return 0;
/*<       end                                                                >*/
} /* djelf_ */

