# $Id: MList.pm,v 1.18 2003/02/17 15:36:57 tsuchiya Exp $
package Juman::MList;
require 5.003_07; # For UNIVERSAL->isa().
use Exporter;
use strict;
use vars qw/ @ISA /;
@ISA = qw/ Exporter /;

=head1 NAME

Juman::MList - 󥪥֥

=head1 SYNOPSIS

  $result = new Juman::MList();

=head1 DESCRIPTION

ݻ륪֥ȡ

=head1 CONSTRUCTOR

=over 4

=item new ( [MRPHS] )

ꤵ줿ݻ륪֥Ȥ롥ά줿ϡ
ͤȤѤ롥

=cut
sub new {
    my $new = bless( {}, shift );
    if( @_ ){
	$new->push_mrph( @_ );
    }
    $new;
}

=back

=head1 METHODS

=over 4

=item mrph

=item mrph_list

ƤηǤΥꥹȤ֤

=cut
sub mrph {
    my( $this ) = @_;
    if( defined $this->{mrph} ){
	@{$this->{mrph}};
    } else {
	wantarray ? () : 0;
    }
}

sub mrph_list {
    shift->mrph( @_ );
}

=item push_mrph ( @MRPH )

ꤵ줿ʸɲä롥

=cut
sub push_mrph {
    my( $this, @mrph ) = @_;
    $this->{MLIST_READONLY} and die;
    grep( ! $_->isa('Juman::Morpheme'), @mrph ) and die;
    push( @{$this->{mrph}}, @mrph );
}

=item set_readonly

Ф񤭹ߤԵĤꤹ롥

=cut
sub set_readonly {
    my( $this ) = @_;
    $this->{MLIST_READONLY} = 1;
}

# ߴݻ뤿̾
sub set_mlist_readonly {
    shift->set_readonly();
}

=item spec

ʸ֤Juman ˤϤƱη̤롥

=cut
sub spec {
    my( $this ) = @_;
    my $str;
    for my $mrph ( $this->mrph() ){
	$str .= $mrph->spec();
	for my $doukei ( $mrph->doukei() ){
	    $str .= '@ ' . $doukei->spec();
	}
    }
    $str;
}

=back

=head1 SEE ALSO

L<Juman::Result>, L<Juman::Morpheme>.

=head1 AUTHORS

=over 4

=item
ڲ ̭ <tsuchiya@pine.kuee.kyoto-u.ac.jp>

=cut

1;
__END__
# Local Variables:
# mode: perl
# coding: euc-japan
# use-kuten-for-period: nil
# use-touten-for-comma: nil
# End:
