use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    'NAME'		=> 'juman-perl',
    'VERSION_FROM'	=> 'lib/Juman.pm',
    'PREREQ_PM'		=> {}, # e.g., Module::Name => 1.1
    ($] >= 5.005 ?    ## Add these new keywords supported since 5.005
      (ABSTRACT		=> 'segment Japanese sentences to morphemes with Juman',
       AUTHOR		=> 'TSUCHIYA Masatoshi <tsuchiya@pine.kuee.kyoto-u.ac.jp>') : ()),
);

package MY;

sub top_targets {
    my $inherited = shift->SUPER::top_targets( @_ );
    $inherited =~ s/(\npure_all\s*::.*)/$1 jumandb_convert/ if( eval { require DB_File; } );
    $inherited;
}

sub install {
    my $inherited = shift->SUPER::install( @_ );
    $inherited =~ s/(\npure_install\s*::.*)/$1 jumandb_install/ if( eval { require DB_File; } );
    $inherited;
}

sub postamble {
    my $file;
    return unless( eval { require DB_File; } );
  detect_dict:
    for my $dir ( split( /:/, $ENV{PATH}.":/share/tool/juman/bin" ) ){
	$dir =~ s!/\Z!!;
	if( -x $dir."/juman" ){
	    $dir =~ s!/bin!!;	# = prefix
	    for my $x ( map( $dir."/".$_, qw( dic share/juman/dic lib/juman/dic ) ) ){
		$x .= "/JUMAN.katuyou";
		if( -f $x ){
		    $file = $x;
		    last detect_dict;
		}
	    }
	}
    }
    unless( $file ){
	$file = "JUMAN.katuyou";
	print STDERR <<'__error__';
==== ERROR ====

Can't find KATUYOU dictionary of Juman.  Specify the path of your
dictionary as follows:

    % make JUMANDIC=/path/to/JUMAN.katuyou
    % make JUMANDIC=/path/to/JUMAN.katuyou test
    # make JUMANDIC=/path/to/JUMAN.katuyou install

==== ERROR ====
__error__
    }
    sprintf( <<'__targets__', $file, ( "@ARGV" =~ m/\bINSTALLDIRS=vendor\b/ ? "INSTALLVENDORLIB" : "INSTALLSITELIB" ) );
JUMANDB=JUMAN.katuyou.db
JUMANDIC=%s

jumandb_install: $(INST_LIB)/Juman/$(JUMANDB)
	@umask 022; cp $? $(%s)/Juman/

jumandb_convert: $(INST_LIB)/Juman/$(JUMANDB)

$(INST_LIB)/Juman/$(JUMANDB): mkkhash $(JUMANDIC)
	perl mkkhash $(JUMANDIC) $@
__targets__
}
