/*
 * This is the deepleap module for Roxen 1.3x.
 * Written Wed Nov 11 1999 by James Tyson
 * Distributed under the GNU GPL (http://www.gnu.org)
 * My personal site: http://fuck.nuckle.net/
 */

#include <module.h>
inherit "module";
inherit "roxenlib";

// Register the module
array register_module() {
	return	({ MODULE_LOCATION, "Deepleap XML Module",
	  "This module allows you to easily integrate your site with "
		"<a href=\"http://www.deepleap.com\">deepleap</a>.<br>\n"
		"once you have filled out the variables below click "
		"<a target=\"_blank\" href=\"http://www.deepleap.com/metainfo/update.html\">here</a> to add your "
		"site to their database.",
		0, 1 });
	}

// Configuration stuff
void create() {
	defvar("siteName","","Site Name",TYPE_STRING,
		"This is the name of the website handled by this virtual server. Probably "
		"defined by the &lt;TITLE&gt;&lt;/TITLE&gt; containers in your webpages.<br><br>"
		"<b>REQUIRED</b>"
		);
	defvar("url","","Site URL",TYPE_STRING,
		"This is the URL of this virtual server, it has been auto-magically whisked "
		"out of the server configuration - however, you can change it here if you want.<br><br>"
		"<b>REQUIRED</b>"
		);
	defvar("contactUri","","Contact URI",TYPE_STRING,
		"This is the URI to your contact page (eg. /contacts.html)<br><br>"
		"<b>OPTIONAL</b>: leave me blank and I will not appear in the metainfo box."
		);
	defvar("siteMapUri",(""),"Site Map URI",TYPE_STRING,
		"This is the URI to your site-map (eg. /sitemap.html)<br><br>"
		"<b>OPTIONAL</b>: leave me blank and I will not appear in the metainfo box."
		);
	defvar("whatsNewUri","","What's new URI",TYPE_STRING,
		"This is the URI to your &quot;What's New&quot; or latest news page.<br><br>"
		"<b>OPTIONAL</b>: leave me blank and I will not appear in the metainfo box."
		);
	defvar("searchUri","","Search Engine URI",TYPE_STRING,
		"This is the URL to your search engine script. (eg. /cgi-bin/search.pl or "
		"even http://search.amazon.com/search)<br>"
		"Do NOT add any arguments to the URI, they come later.<br><br>"
		"<b>OPTIONAL</b>: leave me blank and I will not appear in the metainfo box."
		);
	defvar("searchMethod","POST","HTTP Method" ,TYPE_MULTIPLE_STRING,
		"Your search engine may specifically require you to submit things as POST or "
		"GET. Please select which you require.<br><br>"
		"<b>Only required if you have entered a &quot;Search Engine URI&quot;</b>",
		({ "POST", "GET" }));
	defvar("searchParam","","Search Parameteres", TYPE_STRING,
		"This is the form variable name of the input box used to find the search "
		"keywords. ie the &quot;name=&quot; element of the &quot;input&quot; tag "
		"on your search page.<br><br>"
		"<b>Only required if you have entered a &quot;Search Engine URI&quot;</b>",
		);
	}

string query_location() {
	return ("/deepleap.xml");
	}

mixed find_file(string path, object id) {
	string deepleap;
	deepleap = "<?xml version=\"1.0\"?>\n" +
		"<sitenav>\n";
	if (query("siteName") != "") {
		deepleap += "\t<sitename>" + query("siteName") + "</sitename>\n";
		}
	if (query("url") != "") {
		deepleap +="\t<url>" + query("url") + "</url>\n";
		}
	if (query("contactUri") != "") {
		deepleap += "\t<contactinfo>" + query("contactUri") + "</contactinfo>\n";
		}
	if (query("siteMapUri") != "") {
		deepleap += "\t<sitemap>" + query("siteMapUri") + "</sitemap>\n";
		}
	if (query("whatsNewUri") != "") {
		deepleap += "\t<whatsnew>" + query("whatsNewUri") + "</whatsnew>\n";
		}
	if (query("searchUri") != "") {
		deepleap += "\t<search>\n" +
			"\t\t<engine>" + query("searchUri") + "</engine>\n" +
			"\t\t<type>" + query("searchMethod") + "</type>\n" +
			"\t\t<parameter>" + query("searchParam") + "</parameter>\n" +
			"\t</search>\n";
		}
	deepleap += "\t<version>1.0</version>\n" +
		"</sitenav>\n";
	return http_string_answer(deepleap);
	}
