# $Id: Katuyou.pm,v 1.2 2002/12/13 03:23:55 tsuchiya Exp $
package Juman::Katuyou;
require 5.000;
use Exporter;
use POSIX qw/ O_RDONLY /;
use strict;
use vars qw/ @ISA @EXPORT @EXPORT_OK /;
@ISA = qw/ Exporter /;

=head1 NAME

Juman::Katuyou - ǥ֥Ȥγѷ

=head1 DESCRIPTION

ǥ֥ L<Juman::Morpheme> γѷ᥽åɤɲ
롥

=head1 FILE

ѷ F<JUMAN.katuyou.db> 򻲾Ȥ롥μϡJuman Τ
°Ƥ뼭 F<JUMAN.katuyou> 鵡Ū졤F<Katuyou.pm> 
Ʊǥ쥯ȥ˥󥹥ȡ뤵ƤϤǤ롥

ʤѷ BerkeleyDB Ǻ졤L<DB_File> ⥸塼
̤ƥ롥juman-perl Υ󥹥ȡ L<DB_File> ⥸塼
뤬¸ߤʤȡκϹԤʤΤǡܥ⥸塼󶡤
᥽åɤѤǤʤ

=cut

my %TABLE;
my $FILE = $INC{'Juman/Katuyou.pm'} || undef;
$FILE =~ s!/Katuyou\.pm$!/JUMAN.katuyou.db!
    or die "Can't detect the directory of Juman/Katuyou.pm.\n";

=head1 METHODS

=over 4

=item kihonkei

Ǥδܷ֤

=cut
sub kihonkei {
    my( $this ) = @_;
    $this->change_katuyou2( 'ܷ' );
}

=item change_katuyou2 ( FORM )

ꤵ줿ѷ I<FORM> (ܷ̿ʤ)Ŀʷǥ֥
Ȥ֤ꤵ줿ѷ¸ߤʤ̤֤ͤ

=cut
sub change_katuyou2 {
    my( $this, $new_form ) = @_;

    my $type = $this->katuyou1;
    my $form = $this->katuyou2;

    unless( %TABLE ){
	require DB_File;
	tie( %TABLE, 'DB_File', $FILE, O_RDONLY ) or die "Can't open file($FILE): $!\n";
    }

    unless( $TABLE{"$type:$new_form"} ){
	# ѹѷ¸ߤʤ
	undef;
    } else {
	# ѹѷ¸ߤ
	my $new = &_dup( $this );
	my @gobi = split( /\t/, $TABLE{"$type:$form"} );
	my @newgobi = split( /\t/, $TABLE{"$type:$new_form"} );
	$new->{midasi} = &_change_gobi( $this->midasi, $gobi[1], $newgobi[1] );
	$new->{yomi}   = &_change_gobi( $this->yomi,
					( $gobi[2] || $gobi[1] ),
					( $newgobi[2] || $newgobi[1] ) );
	$new->{katuyou2} = $new_form;
	$new->{katuyou2_id} = $newgobi[0];
	$new;
    }
}

# Ѳؿ
sub _change_gobi {
    my( $str, $cut, $add ) = @_;

    if ($cut eq '*') { ; }
    else {
	$str =~ s/$cut$//;
    }
    if ($add eq '*') { ; }
    else {
	$str .= $add;
    }
    $str;
}

# ǥ֥Ȥʣؿ
sub _dup {
    my( $this ) = @_;
    my $new = {};
    while( my( $key, $value ) = each %$this ){
	$new->{$key} = $value;
    }
    bless $new, ref $this;
}

1;

=back

=head1 SEE ALSO

L<Juman::Morpheme>.

=head1 HISTORY

Υ⥸塼ϡL<KULM::Juman::Katuyou> ⥸塼򸶷Ȥƺ
줿

=head1 AUTHORS

=over 4

=item
ƣ  <sato@i.kyoto-u.ac.jp>

=item
ڲ ̭ <tsuchiya@pine.kuee.kyoto-u.ac.jp>

=cut

__END__
# Local Variables:
# mode: perl
# coding: euc-japan
# use-kuten-for-period: nil
# use-touten-for-comma: nil
# End:
