/*
 * jaZip for Linux.	Copyright 1996	Jarrod A. Smith
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations are made about the suitability of this
 * software for any purpose.  It is provided "as is" without express or 
 * implied warranty.
 */

#include <forms.h>
#include <stdlib.h>
#include "jazip.h"
#include "help.h"
#include "about.h"
#include "pixmaps.h"

void	show_zip_icons(), show_jaz_icons();
void	show_zip_help_icons(), show_jaz_help_icons();

FD_jazip *create_form_jazip(void)
{
	FL_OBJECT *obj;
	FD_jazip *fdui = (FD_jazip *) fl_calloc(1, sizeof(*fdui));
	char	str[256];

	fdui->jazip = fl_bgn_form(FL_NO_BOX, 485, 190);
	obj = fl_add_box(FL_FLAT_BOX,0,0,485,190,"");
	obj = fl_add_frame(FL_ENGRAVED_FRAME,10,45,465,60,"");
	obj = fl_add_box(FL_UP_BOX,0,0,485,35,"");
		fl_set_object_bw( obj, -2 );
	fdui->msg_browser = obj = fl_add_browser(FL_NORMAL_BROWSER,10,115,465,65,"");
		fl_set_object_bw( obj, -2 );
		fl_set_browser_fontsize (obj, 12);
	fdui->info = obj = fl_add_pixmapbutton(FL_NORMAL_BUTTON,20,55,40,40,"");
		fl_set_object_bw( obj, -2 );
		fl_set_object_callback(obj,iomega_info,0);
		fl_set_pixmap_data( obj, bigi_xpm);
	fdui->mount_z = obj = fl_add_pixmapbutton(FL_NORMAL_BUTTON,70,55,40,40,"");
		fl_set_object_bw( obj, -2 );
		fl_set_object_callback(obj,mount_it,0);
	fdui->umount_z = obj = fl_add_pixmapbutton(FL_NORMAL_BUTTON,120,55,40,40,"");
		fl_set_object_bw( obj, -2 );
		fl_set_object_callback(obj,umount_it,0);
	fdui->eject_z = obj = fl_add_pixmapbutton(FL_NORMAL_BUTTON,170,55,40,40,"");
		fl_set_object_bw( obj, -2 );
		fl_set_object_callback(obj,eject_it,0);
	fdui->quit = obj = fl_add_pixmapbutton(FL_NORMAL_BUTTON,425,55,40,40,"");
		fl_set_object_bw( obj, -2 );
		fl_set_object_callback(obj,quit_it,0);
		fl_set_pixmap_data( obj, exit_xpm );
	fdui->ro_z = obj = fl_add_pixmapbutton(FL_NORMAL_BUTTON,220,55,40,40,"");
		fl_set_object_bw( obj, -2 );
		fl_set_object_callback(obj,ro_it,0);
	fdui->rw_z = obj = fl_add_pixmapbutton(FL_NORMAL_BUTTON,270,55,40,40,"");
		fl_set_object_bw( obj, -2 );
		fl_set_object_callback(obj,rw_it,0);
	fdui->jazip_xpm = obj = fl_add_pixmap(FL_NORMAL_PIXMAP,333,60,70,30,"");
		fl_set_pixmap_data( obj, jazip_xpm );
	fdui->little_i_xpm = obj = fl_add_pixmap(FL_NORMAL_PIXMAP,457,4,20,25,"");
		fl_set_pixmap_data( obj, little_i_xpm );
	fdui->help_menu = obj = fl_add_menu(FL_PULLDOWN_MENU,423,6,35,24,"H\010elp");
		fl_setpup_fontstyle( 1 );
		fl_set_menu(fdui->help_menu,"About jaZip...|jaZip Help...");
		fl_set_object_callback(obj,help,0);
	 	fl_set_object_boxtype(obj,FL_FLAT_BOX);
	 	fl_set_object_lsize(obj,FL_NORMAL_SIZE);
	 	fl_set_object_lstyle(obj,FL_BOLD_STYLE);
	fdui->file_menu = obj = fl_add_menu(FL_PULLDOWN_MENU,15,6,35,24,"F\010ile");
	strcpy (str, "Exit");
	fl_set_menu(fdui->file_menu, str);
	fl_set_object_callback(obj,file,0);
	 fl_set_object_boxtype(obj,FL_FLAT_BOX);
	 fl_set_object_lsize(obj,FL_NORMAL_SIZE);
	 fl_set_object_lstyle(obj,FL_BOLD_STYLE);
	fdui->tools_menu = obj = fl_add_menu(FL_PULLDOWN_MENU,62,6,44,24,"T\010ools");
	fl_set_menu(fdui->tools_menu, "Disk Status|Mount|Umount|Eject|Lock|Unlock");
	fl_set_object_callback(obj,tools,0);
	 fl_set_object_boxtype(obj,FL_FLAT_BOX);
	 fl_set_object_lsize(obj,FL_NORMAL_SIZE);
	 fl_set_object_lstyle(obj,FL_BOLD_STYLE);
	fl_end_form();

	return fdui;
}
/*---------------------------------------*/

FD_jazip_help *create_form_jazip_help(void)
{
	FL_OBJECT *obj;
	FD_jazip_help *fdui = (FD_jazip_help *) fl_calloc(1, sizeof(*fdui));

	fdui->jazip_help = fl_bgn_form(FL_NO_BOX,485,400);
	obj = fl_add_box(FL_FLAT_BOX,0,0,485,400,"");
	fdui->help_info = obj = fl_add_pixmapbutton(FL_RADIO_BUTTON,127,350,40,40,"Info");
		fl_set_object_lalign(obj,FL_ALIGN_TOP);
		fl_set_pixmap_data (obj, bigi_xpm);
		fl_set_object_bw( obj, -2 );
	fdui->help_mount = obj = fl_add_pixmapbutton(FL_RADIO_BUTTON,167,350,40,40,"Mount");
		fl_set_object_lalign(obj,FL_ALIGN_TOP);
		fl_set_object_bw( obj, -2 );
	fdui->help_umount = obj = fl_add_pixmapbutton(FL_RADIO_BUTTON,207,350,40,40,"Umount");
		fl_set_object_lalign(obj,FL_ALIGN_TOP);
		fl_set_object_bw( obj, -2 );
	fdui->help_eject = obj = fl_add_pixmapbutton(FL_RADIO_BUTTON,247,350,40,40,"Eject");
		fl_set_object_lalign(obj,FL_ALIGN_TOP);
		fl_set_object_bw( obj, -2 );
	fdui->help_ro = obj = fl_add_pixmapbutton(FL_RADIO_BUTTON,287,350,40,40,"Lock");
		fl_set_object_lalign(obj,FL_ALIGN_TOP);
		fl_set_object_bw( obj, -2 );
	fdui->help_rw = obj = fl_add_pixmapbutton(FL_RADIO_BUTTON,327,350,40,40,"Unlock");
		fl_set_object_lalign(obj,FL_ALIGN_TOP);
		fl_set_object_bw( obj, -2 );
	fdui->help_exit = obj = fl_add_pixmapbutton(FL_RADIO_BUTTON,367,350,40,40,"Exit");
		fl_set_object_lalign(obj,FL_ALIGN_TOP);
		fl_set_pixmap_data (obj, exit_xpm);
		fl_set_object_bw( obj, -2 );
	fdui->help_browser = obj = fl_add_browser(FL_NORMAL_BROWSER,10,10,465,320,"");
		fl_set_object_bw( obj, -2 );
	fdui->help_menus = obj = fl_add_button(FL_RADIO_BUTTON,60,340,50,50,"Menus");
		fl_set_object_bw( obj, -2 );
	fdui->help_overview = obj = fl_add_button(FL_RADIO_BUTTON,10,340,50,50,"Overview");
		fl_set_object_bw( obj, -2 );
	fdui->dismiss = obj = fl_add_pixmapbutton(FL_NORMAL_BUTTON,425,340,50,50,"");
		fl_set_object_bw( obj, -2 );
	fl_end_form();

	if( dtype == ZIP ) show_zip_help_icons( fdui );
	else if( dtype == JAZ ) show_jaz_help_icons( fdui );

	return fdui;
}
/*---------------------------------------*/


FD_about *create_form_about(void)
{
	FL_OBJECT *obj;
	FD_about *fdui = (FD_about *) fl_calloc(1, sizeof(*fdui));

	fdui->about = fl_bgn_form(FL_NO_BOX, 370, 230);
	obj = fl_add_box(FL_FLAT_BOX,0,0,370,230,"");
		fl_set_object_lcol(obj,FL_DARKCYAN);
	obj = fl_add_text(FL_NORMAL_TEXT,10,10,350,160, "(c) 1998 Jarrod A. Smith\n\nThis program is freeware.	If you find it useful,\nplease drop me a line.	I'm certain it will make my day.\n\nSend bug reports and suggestions to jsmith@scripps.edu\n");
		fl_set_object_boxtype(obj,FL_EMBOSSED_BOX);
		fl_set_object_lsize(obj,FL_NORMAL_SIZE);
		fl_set_object_lalign(obj,FL_ALIGN_BOTTOM|FL_ALIGN_INSIDE);
		fl_set_object_lstyle(obj,FL_NORMAL_STYLE+FL_EMBOSSED_STYLE);
	fdui->dismiss = obj = fl_add_pixmapbutton(FL_NORMAL_BUTTON,160,175,50,50,"");
		fl_set_object_bw( obj, -2 );
		if( dtype == ZIP )
			fl_set_pixmap_data( obj, zipicon_xpm);
		else if( dtype == JAZ )
			fl_set_pixmap_data( obj, jazicon_xpm);
	obj = fl_add_text(FL_NORMAL_TEXT,20,15,330,35,"jaZip for Linux Version 0.34");
		fl_set_object_lcol(obj,FL_DARKCYAN);
		fl_set_object_lsize(obj,FL_HUGE_SIZE);
		fl_set_object_lalign(obj,FL_ALIGN_CENTER|FL_ALIGN_INSIDE);
		fl_set_object_lstyle(obj,FL_BOLD_STYLE+FL_EMBOSSED_STYLE);
	fl_end_form();

	return fdui;
}
/*---------------------------------------*/

void show_jaz_icons (FD_jazip *fd_jazip)
{
	Pixmap		p, mask;
	unsigned		w, h;

	fl_set_pixmap_data( fd_jazip->mount_z, jazmount_xpm );
	fl_set_pixmap_data( fd_jazip->umount_z, jazumount_xpm );
	fl_set_pixmap_data( fd_jazip->eject_z, jazeject_xpm );
	fl_set_pixmap_data( fd_jazip->ro_z, lock_xpm );
	fl_set_pixmap_data( fd_jazip->rw_z, unlock_xpm );
	p = fl_create_from_pixmapdata (fl_root, jazicon_xpm, &w, &h, &mask, 0, 0, 0);
	fl_set_form_icon( fd_jazip->jazip, p, mask );
}

void show_zip_icons (FD_jazip *fd_jazip)
{
	Pixmap		p, mask;
	unsigned		w, h;

	fl_set_pixmap_data( fd_jazip->mount_z, zipmount_xpm );
	fl_set_pixmap_data( fd_jazip->umount_z, zipumount_xpm );
	fl_set_pixmap_data( fd_jazip->eject_z, zipeject_xpm );
	fl_set_pixmap_data( fd_jazip->ro_z, lock_xpm );
	fl_set_pixmap_data( fd_jazip->rw_z, unlock_xpm );
	p = fl_create_from_pixmapdata (fl_root, zipicon_xpm, &w, &h, &mask, 0, 0, 0);
	fl_set_form_icon( fd_jazip->jazip, p, mask );

}

void show_jaz_help_icons (FD_jazip_help *fd_jazip_help)
{
	fl_set_pixmap_data( fd_jazip_help->help_mount, jazmount_xpm );
	fl_set_pixmap_data( fd_jazip_help->help_umount, jazumount_xpm );
	fl_set_pixmap_data( fd_jazip_help->help_eject, jazeject_xpm );
	fl_set_pixmap_data( fd_jazip_help->help_ro, lock_xpm );
	fl_set_pixmap_data( fd_jazip_help->help_rw, unlock_xpm );
	fl_set_pixmap_data( fd_jazip_help->dismiss, jazicon_xpm );
}

void show_zip_help_icons (FD_jazip_help *fd_jazip_help)
{
	fl_set_pixmap_data( fd_jazip_help->help_mount, zipmount_xpm );
	fl_set_pixmap_data( fd_jazip_help->help_umount, zipumount_xpm );
	fl_set_pixmap_data( fd_jazip_help->help_eject, zipeject_xpm );
	fl_set_pixmap_data( fd_jazip_help->help_ro, lock_xpm );
	fl_set_pixmap_data( fd_jazip_help->help_rw, unlock_xpm );
	fl_set_pixmap_data( fd_jazip_help->dismiss, zipicon_xpm );
}
