/*  Inti-GL: Integrated Foundation Classes
 *  Copyright (C) 2003 The Inti Development Team.
 *
 *  query.cc - C++ wrapper implementation for the Open-GL query functions.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "query.h"
#include <inti/gdk/display.h>

using namespace Inti;

/*  Gdk::GL::query_extension
 */

bool
Gdk::GL::query_extension(const Gdk::Display *display)
{
	GdkDisplay *tmp_display = display ? display->gdk_display() : gdk_display_get_default();
	return gdk_gl_query_extension_for_display(tmp_display);
}

/*  Gdk::GL::query_version
 */

bool
Gdk::GL::query_version(int *major, int *minor, const Gdk::Display *display)
{
	GdkDisplay *tmp_display = display ? display->gdk_display() : gdk_display_get_default();
	return gdk_gl_query_version_for_display(tmp_display, major, minor);
}

/*  Gdk::GL::query_gl_extension
 */

bool
Gdk::GL::query_gl_extension(const char *extension)
{
	return gdk_gl_query_gl_extension(extension);
}

/*  Gdk::GL::get_proc_address
 */

GdkGLProc
Gdk::GL::get_proc_address(const char *proc_name)
{
	return gdk_gl_get_proc_address(proc_name);
}

