/* vim:tabstop=4:expandtab:shiftwidth=4
 * 
 * Idesk -- XPngImage.h
 *
 * Copyright (c) 2002, Chris (nikon) (nikon@sc.rr.com)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *      Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *      
 *      Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *      
 *      Neither the name of the <ORGANIZATION> nor the names of its
 *      contributors may be used to endorse or promote products derived from
 *      this software without specific prior written permission.
 *
 * (See the included file COPYING / BSD )
 */

#ifndef X_PNG_IMAGE
#define X_PNG_IMAGE

#include "XIdeskImage.h"
#include <Imlib.h>
#include "XShadowImage.h"

class XPngImage : public virtual XIdeskImage
{
    protected:


    public:
        XPngImage(AbstractContainer * c, AbstractIcon * iParent,
                    AbstractConfig * con, AbstractIconConfig * iConfig);
        ~XPngImage();

        virtual void configure();
        virtual void createPicture();
        virtual bool loadPng(const string & filename);
};

class XPngImageShadow : public XShadowImage, public XPngImage
{
    protected:

    public:
        XPngImageShadow(AbstractContainer * c, AbstractIcon * iParent,
                       AbstractConfig * con, AbstractIconConfig * iConfig);

        void configure();

        void refreshIcon();

};
#endif
