module Hat.Foreign.StablePtr
  (StablePtr(),gnewStablePtr,anewStablePtr,hnewStablePtr,gdeRefStablePtr
    ,adeRefStablePtr,hdeRefStablePtr,gfreeStablePtr,afreeStablePtr
    ,hfreeStablePtr,gcastStablePtrToPtr,acastStablePtrToPtr,hcastStablePtrToPtr
    ,gcastPtrToStablePtr,acastPtrToStablePtr,hcastPtrToStablePtr) where

import qualified Prelude 
import qualified Hat.Hat as T 
import qualified Hat.PreludeBasic 
import Hat.Prelude 
import Hat.PreludeBuiltinTypes 
import Hat.Foreign.BuiltinTypes 
import qualified Foreign.StablePtr 

gnewStablePtr :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (IO (StablePtr a)))

gnewStablePtr pnewStablePtr p =
  T.ufun1 anewStablePtr pnewStablePtr p hnewStablePtr

hnewStablePtr z1newStablePtr knewStablePtr =
  (T.fromIO (fromStablePtr T.fromId)) knewStablePtr
    (Foreign.StablePtr.newStablePtr (T.toId knewStablePtr z1newStablePtr))

gdeRefStablePtr :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (StablePtr a) (IO a))

gdeRefStablePtr pdeRefStablePtr p =
  T.ufun1 adeRefStablePtr pdeRefStablePtr p hdeRefStablePtr

hdeRefStablePtr z1deRefStablePtr kdeRefStablePtr =
  (T.fromIO T.fromId) kdeRefStablePtr
    (Foreign.StablePtr.deRefStablePtr
      ((toStablePtr T.toId) kdeRefStablePtr z1deRefStablePtr))

gfreeStablePtr ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (StablePtr a) (IO T.Tuple0))

gfreeStablePtr pfreeStablePtr p =
  T.ufun1 afreeStablePtr pfreeStablePtr p hfreeStablePtr

hfreeStablePtr z1freeStablePtr kfreeStablePtr =
  (T.fromIO T.fromTuple0) kfreeStablePtr
    (Foreign.StablePtr.freeStablePtr
      ((toStablePtr T.toId) kfreeStablePtr z1freeStablePtr))

gcastStablePtrToPtr ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (StablePtr a) (Ptr T.Tuple0))

gcastStablePtrToPtr pcastStablePtrToPtr p =
  T.ufun1 acastStablePtrToPtr pcastStablePtrToPtr p hcastStablePtrToPtr

hcastStablePtrToPtr z1castStablePtrToPtr kcastStablePtrToPtr =
  (fromPtr T.fromTuple0) kcastStablePtrToPtr
    (Foreign.StablePtr.castStablePtrToPtr
      ((toStablePtr T.toId) kcastStablePtrToPtr z1castStablePtrToPtr))

gcastPtrToStablePtr ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (Ptr T.Tuple0) (StablePtr a))

gcastPtrToStablePtr pcastPtrToStablePtr p =
  T.ufun1 acastPtrToStablePtr pcastPtrToStablePtr p hcastPtrToStablePtr

hcastPtrToStablePtr z1castPtrToStablePtr kcastPtrToStablePtr =
  (fromStablePtr T.fromId) kcastPtrToStablePtr
    (Foreign.StablePtr.castPtrToStablePtr
      ((toPtr T.toTuple0) kcastPtrToStablePtr z1castPtrToStablePtr))

tForeign_StablePtr =
  T.mkModule "Foreign.StablePtr" "Foreign/StablePtr.hs" Prelude.False

anewStablePtr =
  T.mkVariable tForeign_StablePtr 150003 3 1 "newStablePtr" Prelude.False

adeRefStablePtr =
  T.mkVariable tForeign_StablePtr 170003 3 1 "deRefStablePtr" Prelude.False

afreeStablePtr =
  T.mkVariable tForeign_StablePtr 190003 3 1 "freeStablePtr" Prelude.False

acastStablePtrToPtr =
  T.mkVariable tForeign_StablePtr 210003 3 1 "castStablePtrToPtr" Prelude.False

acastPtrToStablePtr =
  T.mkVariable tForeign_StablePtr 230003 3 1 "castPtrToStablePtr" Prelude.False
