// -*- c++ -*-

//  Gnomoradio - roboradio/song-local.h
//  Copyright (C) 2003  Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version)
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __ROBORADIO_SONG_LOCAL_H
#define __ROBORADIO_SONG_LOCAL_H

#include <glibmm.h>

#include "roboradio/song.h"

namespace Roboradio
{
	namespace Audio
	{
		class Audio;
	}

	class SongLocal : public Song
	{
	public:
		SongLocal (const Glib::ustring &loc);
		virtual ~SongLocal ();

		virtual void obtain_available_info ();

		Playback get_playback () const;
		void set_playback (Playback pb);
		void seek (Time pos);
		Time get_position ();

	protected:
		virtual Glib::ustring get_filename () const;

	private:
		bool create_audio ();

		Playback playback;
		Audio::Audio *audio;
	};
}

#endif
