// -*- c++ -*-

//  Gnomoradio - gnomoradio/song-paths.h
//  Copyright (C) 2004  Matt Gerginski, Jim Garrison
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef __SONG_PATHS_H
#define __SONG_PATHS_H

#include <gtkmm.h>
#include "wraporadio/wraporadio.h"

namespace Gnomoradio
{
	class SongPaths : public Gtk::Table
	{
	public:
		SongPaths ();

	protected:
		
		class SongPathsModelColumns : public Gtk::TreeModel::ColumnRecord
		{
		public:

			SongPathsModelColumns() { add(path_col); }

			Gtk::TreeModelColumn<Glib::ustring> path_col;
		};

		SongPathsModelColumns m_columns;

		Wraporadio::Init wr;

		Gtk::TreeView song_path_treeview;
		Glib::RefPtr<Gtk::ListStore> ref_tree_model;
		Gtk::Button add_path_button;
		Gtk::Button remove_path_button;
		
		void add_path_button_clicked ();
		void remove_path_button_clicked ();
	};
}

#endif
