//  Gnomoradio - gnomoradio/playlist-chooser-store.cc
//  Copyright (C) 2003  Jim Garrison, Matt Gerginski
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "playlist-chooser-store.h"
#include "wraporadio/wraporadio.h"

using namespace std;
using namespace sigc;
using namespace Glib;
using namespace Gtk;
using namespace Wraporadio;
using namespace Gnomoradio;

Gnomoradio::PlaylistChooserStore::PlaylistChooserStore ()
{
	TreeModelColumnRecord record;
	record.add(icon_col);
	record.add(playing_col);
	record.add(name_col);
	record.add(song_list_col);

	store = ListStore::create(record);

	fill_with_playlists();

	SongList::signal_new_named_song_list()
		.connect(mem_fun(*this, &PlaylistChooserStore::redo));
	SongList::signal_named_song_list_destroyed()
		.connect(mem_fun(*this, &PlaylistChooserStore::redo));
	SongList::signal_global_name_changed()
		.connect(mem_fun(*this, &PlaylistChooserStore::redo));
}

void Gnomoradio::PlaylistChooserStore::fill_with_playlists ()
{
	TreeIter iter;
	vector<SongList> lists = SongList::get_named_song_lists();
	vector<SongList>::const_iterator pos;
	for (pos = lists.begin(); pos != lists.end(); ++pos) {
		iter = store->append();
		iter->set_value(name_col, pos->get_name());
		iter->set_value(song_list_col, *pos);
	}
}

void Gnomoradio::PlaylistChooserStore::redo (ref_ptr<Roboradio::SongList> sl)
{
	store->clear();
	fill_with_playlists();
}
