#ifndef _FTVT_VTBLC_H
#define _FTVT_VTBLC_H
/*
 *      Copyright (C) 1997-1999 Claus-Justus Heine

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; see the file COPYING.  If not, write to
 the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *
 * $RCSfile: vtblc.h,v $
 * $Revision: 1.6 $
 * $Date: 1999/03/05 13:13:05 $
 *
 *     This file is a mere wrapper header file which exists for the
 *     sake of compatibility with the libvtblc of Albrecht Gebhardt
 *     <albrecht.gebhardt@uni-klu.ac.at>.
 *
 *     Moreover, as this is only needed for amanda, and amanda uses
 *     this only to update the volume label and time stamps of the
 *     header segments, I restrict this wrapper to the functions
 *     needed for this purpose.
 */

#include <ftvt.h> /* the new header file */

/*  We do not define this in the new header file.
 */
#define MAX_VOLUMES FTVT_MAX_VOLUMES
typedef ftvt vtbl;

static vtbl volumes[FTVT_MAX_VOLUMES];
static u_int8_t vtbl_buffer[FT_SEGMENT_SIZE];
static int num_volumes;

/*  This is ugly. Rather should change amanda. This is defined so that
 *  op_mode == trunc is always false.
 */
#define op_mode 1
#define trunc   0

/* So, shall we use inline or #define ? :-)
 */
#define raw_tape_open(name, mode) ftvt_open(name, mode)
#define raw_tape_close(tape_fd)   ftvt_close(tape_fd)
#define read_vtbl(tape_fd, volumes, buffer, fds, lds) \
	ftvt_read(tape_fd, volumes, buffer)
#define write_vtbl(tape_fd, volumes, buffer, vtbl_cnt, fds, force_write) \
	ftvt_write(tape_fd, volumes, buffer, vtbl_cnt, force_write)
#define set_date(date, volumes, maxnum, vtbl_no) \
	ftvt_set_date(volumes, maxnum, date, vtbl_no)
#define set_label(desc, volumes, maxnum, vtbl_no) \
	ftvt_set_label(volumes, maxnum, desc, vtbl_no)

/* So, this should have done the trick
 */

#endif
