/*
 *
 * swapout.c  -- Dirty 5Meg of memory, trying to force the machine to
 * swap out processes.
 *
 * Written by Kai Harrekilde-Petersen, Jan 22, 1996.
 * Freely distributable under the GNU General Public License; see the
 * file COPYING for details.
 *
 * Modified by Claus-Justus Heine to accept a command line argument that
 * specifies the number of megabytes to allocate.
 *
 *      $Log: swapout.c,v $
 *      Revision 1.4  1999/03/04 09:26:33  cvs
 *      Include <locale.h>
 *
 *      Revision 1.3  1998/12/18 22:46:56  cvs
 *      Replaced the $Source: /usr/local/cvs/linux/ftape/ftape-tools/src/swapout/swapout.c,v $ keyword substitution by the $RCSfile: swapout.c,v $ substitution.
 *
 *      Revision 1.2  1998/07/30 20:39:34  claus
 *      Fixed my broken command line parsing :-(
 *
 *
 */

 char swp_src[] = "$RCSfile: swapout.c,v $";
 char swp_rev[] = "$Revision: 1.4 $";
 char swp_dat[] = "$Date: 1999/03/04 09:26:33 $";

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <stdio.h>
#include <getopt.h>
#include <asm/page.h>
#include <errno.h>
#include <locale.h>
#include <libintl.h>
#define _(String) gettext (String)

#include "version.h"

static const char *short_options = "Vh";
static const struct option long_options[] =
{
	{"version", 0, 0, 'V'},
	{"help", 0, 0, 'h'},
};

#define MEM_SIZE (5 * 1024 * 1024)

void usage(char *prog_name, int retval, FILE *fp) 
{
	fprintf(fp, version_string);
	fprintf(fp, _("Usage: %s [-V] [--version] [megabytes]\n"), prog_name);
	fprintf(fp, _("The optional parameter \"megabytes\" defaults to %d\n"), MEM_SIZE/1024/1024);	
	exit(retval);
}

int main(int argc, char **argv)
{
	char *ptr = NULL;
	int i;
	int mem_size = MEM_SIZE;

	setlocale (LC_ALL, "");
	bindtextdomain (PACKAGE, LOCALEDIR);
	textdomain (PACKAGE);

	while (1) {
		int option_index = 0;
		int c;

		c = getopt_long(argc, argv, short_options,
				long_options, &option_index);
		if (c == -1) {
			break;
		}
		
		switch (c) {
		case '?':
		case 'h':
			usage(argv[0], 0, stdout);
			break;
		case 'V':
			printf(version_string);
			exit(0);
			break;
		default:
			usage(argv[0], 1, stderr);
			break;
		}
	}
	if (optind + 1 == argc) {
		mem_size = 1024*1024*atoi(argv[optind]);
	} else if (argc != 1) {
		usage(argv[0], 1, stderr);
	}
	printf(_("Trying to allocate %d Meg\n"), mem_size/1024/1024);
	ptr = malloc(mem_size);
	if (!ptr) {
		fprintf( stderr, _("Couldn't allocate %d Meg. "
			 "You need kill off a few programs.\n"), mem_size/1024/1024 );
		exit(-ENOMEM);
	}
	for (i = 0; i < mem_size / PAGE_SIZE; i++) {
		ptr[i * PAGE_SIZE] = i;
	}
	free(ptr);
	exit(0);
}
