//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: PenalizedFictitousDomain.cpp,v 1.8 2004/01/30 17:34:12 delpinux Exp $

#include <PenalizedFictitousDomain.hpp>
#include <BoundaryConditionDiscretizationPenalty.hpp>

template <typename MeshType>
ReferenceCounting<BoundaryConditionDiscretization>
PenalizedFictitousDomain::__discretizeBoundaryConditions()
{
  BoundaryConditionDiscretizationPenalty<MeshType>* bcDiscretization
    = new BoundaryConditionDiscretizationPenalty<MeshType>(problem(),
							   dynamic_cast<MeshType&>(mesh()),
							   (*__degreeOfFreedomSet),
							   __epsilon);
  (*bcDiscretization).associatesMeshesToBoundaryConditions();
  return bcDiscretization;
}

ReferenceCounting<BoundaryConditionDiscretization>
PenalizedFictitousDomain::discretizeBoundaryConditions()
{
  switch (mesh().type()) {
  case Mesh::cartesianHexahedraMesh: {
    return this->__discretizeBoundaryConditions<Structured3DMesh>();
    break;
  }
  default: {
    fferr(0) << __FILE__ << ':' << __LINE__ << ": Not implemented\n";
    fferr(0) << "this mesh type is not supported by FDM penalty\n";
    std::exit(1);
    return 0;
  }
  }
}
