#ifndef DEGREE_OF_FREEDOM_FDM_SET_HPP
#define DEGREE_OF_FREEDOM_FDM_SET_HPP

#include <DegreeOfFreedomSet.hpp>
#include <Vector.hpp>
#include <ReferenceCounting.hpp>

class DegreeOfFreedomFDMSet
  : public DegreeOfFreedomSet
{
public:
  typedef Vector<int> Correspondance;

private:
  ReferenceCounting<Correspondance> __correspondance;

public:
  size_t operator()(const size_t& variableNumber,
		    const size_t& vertexNumber) const
  {
    assert((*__correspondance)[vertexNumber] != -1);
    return ((*__correspondance)[vertexNumber]*__numberOfVariables+variableNumber);
  }

  bool isDOFVertex(const size_t& vertexNumber) const
  {
    return ((*__correspondance)[vertexNumber] != -1);
  }

  DegreeOfFreedomFDMSet(const size_t& numberOfVariables,
			const size_t& numberOfVertices,
			ReferenceCounting<Correspondance> correspondance)
    : DegreeOfFreedomSet(numberOfVariables,
			 numberOfVertices),
      __correspondance(correspondance)
  {
    ;
  }

  ~DegreeOfFreedomFDMSet()
  {
    ;
  }
};

#endif // DEGREE_OF_FREEDOM_FDM_SET_HPP
