//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: Rotation.hpp,v 1.2 2003/05/04 18:09:01 delpinux Exp $


#ifndef ROTATION
#define ROTATION

#include <Transform.hpp>
#include <TinyVector.hpp>
#include <TinyMatrix.hpp>

/*!
  \class Rotation
  This class defines rotations using the same description that \p POV-Ray.
  It means that rotations are performed using:
  \li an angle of \a angles[0] around the X axis;
  \li an angle of \a angles[1] around the Y axis;
  \li an angle of \a angles[2] around the Z axis.

  \author Stphane Del Pino
 */

class Rotation
  : public Transform
{
private:
  //! Rotation angles as given in POV-Ray.
  TinyVector<3> __angles;

  /*! The inverse of the rotation is stored in the matrix. This way one can
    know if a vertex is the image of a vertex contained in a base shape ; so,
    if a vertex is in the image of shape!
  */
  TinyMatrix<3,3> __matrix;

public:

  //! Applies the Rotation to a vector \a v.
  TinyVector<3>& operator()(TinyVector<3>& v) const;

  //! Applies the inverse Rotation to a vector \a v.
  TinyVector<3>& inverse(TinyVector<3>& v) const;

  //! Prints Rotation informations to a std::string.
  std::string povWrite() const;

  //! Default constructor.
  Rotation();

  //! Constructs a Rotation for a set of given angles passed by \a r.
  Rotation(const TinyVector<3>& r);

  //! Copy constructor.
  Rotation(const Rotation& r);

  //! Destrutor
  ~Rotation()
  {
    ;
  }
};

#endif // ROTATION

