/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: mount.h
 */

typedef enum {
	MOUNT = 0,
	UNMOUNT,
	REMOUNT
} mount_op_t;

typedef int (*mount_can_function) (object_handle_t volume);

char *get_volume_device_node(object_handle_t volume);

char *get_current_mount_point(object_handle_t volume);

void populate_clist_for_mount_operation(GtkCList * clist, mount_op_t oper);

void on_browse_mount_dir_button_clicked(GtkButton * button, GtkWidget * entry);

GtkWidget *create_mount_window(void);
