/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: fsutils.h
 */

typedef enum {
	FSCK = 0,
	MKFS,
	UNMKFS
} filesys_op_t;

void on_filesys_operation_clist_realize(GtkCList * clist, gpointer user_data);

void on_fsim_clist_realize(GtkWidget * widget, gpointer user_data);

void on_initiate_filesys_operation_button_clicked(GtkButton * button, gpointer user_data);

void on_remove_filesys_button_clicked(GtkButton * button, gpointer user_data);

void on_fsck_popup_menu_item_activate(GtkMenuItem * menuitem, gpointer user_data);

void on_mkfs_popup_menu_item_activate(GtkMenuItem * menuitem, gpointer user_data);

void on_unmkfs_popup_menu_item_activate(GtkMenuItem * menuitem, gpointer user_data);

gboolean volume_has_fsim(object_handle_t volume);

gboolean can_volume_be_formatted(object_handle_t volume);
