/*
 *
 *   (C) Copyright IBM Corp. 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: libmac.so
 *
 *   File: mac_plugin.h
 */

#ifndef   _MAC_HEADERS_
#define   _MAC_HEADERS_ 1

//
// MAC Disk Private Data Area
//
#define  MAC_DISK_PDATA_SIGNATURE          0x4D41432D  /* MAC- */

#define  DISK_HAS_CHANGES_PENDING          0x00000001
#define  DISK_HAS_MOVE_PENDING             0x00000002

#include "mac_disklabel.h"

typedef struct disk_private_data_s {

        u_int32_t          signature;           /* used to validate disk private data area           */
        
        u_int32_t          flags;               /* see DISK_HAS_xxxx flags above                     */

        u_int32_t          vsectors_per_block;  /* disk hardsector size >> EVMS_VSECTOR_SIZE         */
        
        u_int32_t          pcount;              /* number of partition map entries                   */

        copy_job_t        *copy_job;            /* ptr to valid copy job if a segment move is in     */
                                                /* progress ... DISK_HAS_MOVE_PENDING should be      */
                                                /* set if this is the case.                          */
        
        mac_partition_t    pmap;                /* copy of the pmap partition record                 */

} disk_private_data_t; 


//
// MAC Segment Private Data Area
//
#define  MAC_SEGMENT_PDATA_SIGNATURE       0x4D5A4547   /* MSEG */
#define  SEG_CFLAG_TOP_SEGMENT             0x00000001

typedef struct seg_private_data_s {

        u_int32_t          signature;           /* used to validate our private data area            */

        u_int32_t          cflags;              /* common flag definitions                           */

        //----------------- end of segment manager common area  -----------------------

        storage_object_t  *logical_disk;        /* storage object we found the mac partitions on     */

        mac_partition_t    p_record;            /* mac partition record we read off the disk label   */                                         

        u_int32_t          minor;               /* minor number assigned to this segment             */
        
        u_int32_t          pmap_index;          /* location of record in the PMAP                    */

        DISKSEG           *move_target;         /* used when moving segments on the disk             */
    
} seg_private_data_t;


extern struct engine_functions_s       *EngFncs;
extern plugin_record_t                 *mac_plugin;

#define my_plugin_record               mac_plugin

#include "disks.h"
#include "helpers.h"
#include "commit.h"
#include "options.h"
#include "discovery.h"
#include "segments.h"
#include "dm.h"

#endif

