/*
 *   (C) Copyright IBM Corp. 2004
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: LVM2 Plugin
 * File: evms2/engine/plugins/lvm2/containers.h
 */

/* Routines exported from containers.c. */

extern void vg_name_to_container_name(char *vg_name,
				      char *container_name,
				      storage_container_t *disk_group);
extern int container_name_to_vg_name(char *container_name, char *vg_name);
extern void add_object_to_container(storage_object_t *object,
				    storage_container_t *container);
extern void remove_object_from_container(storage_object_t *object,
					 storage_container_t *container);
extern void deallocate_container(storage_container_t *container);
extern storage_container_t *create_new_container(u_int64_t extent_size,
						 char *vg_name,
						 storage_container_t *disk_group);
extern int discover_containers(list_anchor_t pv_list);
extern int check_containers(boolean final_call);
extern int cleanup_containers(void);
extern int commit_container_metadata(storage_container_t *container,
				     boolean backup);

extern int can_add_object(storage_object_t *object,
			  storage_container_t *container);
extern int can_remove_object(storage_object_t *object);
extern int can_shrink_object(storage_object_t *object, u_int64_t *shrink_limit);
extern int add_object(storage_object_t *object,
		      storage_container_t *container,
		      option_array_t *options);
extern int remove_object(storage_object_t *object);
extern int expand_object_in_container(storage_container_t *container,
				      storage_object_t *consumed_object,
				      storage_object_t *expand_object,
				      list_anchor_t input_objects,
				      option_array_t *options);
extern int shrink_object_in_container(storage_container_t *container,
				      storage_object_t *consumed_object,
				      storage_object_t *shrink_object,
				      list_anchor_t input_objects,
				      option_array_t *options);
extern u_int64_t max_consecutive_extents_in_container(storage_container_t *container);

