/*
 *
 *   (C) Copyright IBM Corp. 2002, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: eceinternal.h
 */


/* contains all the defination used internally by ece */

#ifndef __ECEINTERNAL_H__
#define __ECEINTERNAL_H__ 1

#include <pthread.h>
#include <clplumbing/ipc.h>
#include <clplumbing/GSource.h>
#include <clplumbing/Gmain_timeout.h>
#include <clplumbing/base64.h>
#include <clplumbing/realtime.h>
#include <heartbeat/ha_msg.h>
#include <heartbeat/hb_api.h>
#include <heartbeat/heartbeat.h>
#include <ocf/oc_event.h>
#include <errno.h>
#include <string.h>
#include <strings.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <assert.h>
#include <sys/wait.h>

#undef LOG_WARNING
#undef LOG_DEBUG

#include <plugin.h>
#include "ecellm.h"
#include "ecemisc.h"
#include "ecemainloop.h"
#include "ecefrag.h"


#define ECE_MSG 	"ecemsgv"
#define ECE_ACKMSG 	"eceackv"
#define ECE_CLIENTDEAD 	"ececdv"

#define ECE_ACK 	"eceackn"
#define ECE_CMD 	"ececmdn"
#define ECE_CORRELATOR 	"ececorrn"
#define ECE_FIRSTNODE 	"ecefrstndn"
#define ECE_TRANSID 	"ecetransn"
#define ECE_DATA   	"ecedatan"
#define ECE_CRC   	"ececrcn"
#define ECE_SEQNO   	"eceseqnn"
#define ECE_CNTL   	"ececntln"

#define ECEi_TOWHOM 	"ecetowhomn"
#define ECEi_LLM    	"ecellmn"
#define ECEi_NODECOUNT 	"ecenodcntn"
#define ECEi_MYNODEID 	"ecemyndn"
#define ECEi_NODES  	"ecenodesn"
#define ECEi_MEMBERSHIP "ecemembn"
#define ECEi_QUORUM 	"eceqrmn"
#define ECEi_MEM 	"ecememn"
#define ECEi_ECESTAT 	"ecestatn"


#define ECE_WHO   	"ecewhon"
#define ECE_SLAVE 	"eceslvv"
#define ECE_MASTER 	"ecemstv"
#define ECE_JOINSTATUS 	"ecejstv"

#define ECE_RET   	"eceretn"

#define ECEFIFO 	"/var/run/evms"
#define DEACTIVATE_PATH  HA_RESOURCEDIR "/evms_failover"

extern plugin_record_t ece_plugin_record;
extern engine_functions_t *gl_ece_engine_funcs;

#define my_plugin_record &ece_plugin_record
#define EngFncs gl_ece_engine_funcs

#define ENGINE_ALLOC(size)   ((gl_ece_engine_funcs && \
		gl_ece_engine_funcs->engine_alloc) ?\
		gl_ece_engine_funcs->engine_alloc(size):\
		NULL)
#define CALC_CRC(crc, buf, bufsize) ((gl_ece_engine_funcs && \
		gl_ece_engine_funcs->calculate_CRC)?\
		gl_ece_engine_funcs->calculate_CRC(\
		crc, (buf), bufsize):0)

#define ECE_ASSERT(cond) \
	if (!(cond)) {\
		LOG_CRITICAL("ASSERTION FAILURE\n"); \
	}
	


typedef enum {
	MASTER,
        SLAVE
} ece_mode_t;


#define ECE_TIMEOUT  1 /* 1 millisecond, this is the timeout value used
			  by the mainloop thread to notice if any work
			  is pending to be done */

extern inline ece_mode_t ece_get_mode();
extern inline IPC_Channel * ece_get_peer();
extern void hb_send_to_node(struct ha_msg *, const char *);
extern void hb_send_to_cluster(struct ha_msg *);

#endif /* __ECEINTERNAL_H__ */
