/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: libdos.so
 *
 *   File: embedded.h
 */

#ifndef EMBEDDED_HEADER
#define EMBEDDED_HEADER 1

DISKSEG * alloc_diskseg_object( LOGICALDISK *ld );

DISKSEG * build_segment_for_embedded_partition( LOGICALDISK       *ld,
                                                DISKSEG           *msdos_seg,
                                                u_int32_t          start,
                                                u_int32_t          size,
                                                u_int32_t          sys_id,
                                                u_int32_t          ptable_index,
                                                u_int32_t          minor );


DISKSEG * get_matching_segment( list_anchor_t seglist, lba_t start, sector_count_t size );

int       remove_embedded_partitions_from_disk( LOGICALDISK *ld, list_anchor_t recovery_list );

int       read_embedded_geometry( LOGICALDISK *ld, geometry_t *geometry );

#endif
