/* BTP library - Banana Tree Protocol
 * Copyright (C) 1999-2001  The Regents of the University of Michigan
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */


#ifndef _BTP_PROTO_H
#define _BTP_PROTO_H

#include <glib.h>
#include <gnet/gnet.h>

#include "b_conn.h"
#include "b_peer.h"
#include "btp_tree.h"


#define FIND_NEW_PARENT_TIME		5000
#define FIND_NEW_PARENT_RANGE		1000

#define REQUEST_NEIGHBORS_TIME		10
#define REQUEST_NEIGHBORS_RANGE 	2000

#define NEXT_REQUEST_NEIGHBORS_TIME	20000	/* TODO This should be exponential */
#define NEXT_REQUEST_NEIGHBORS_RANGE 	2000

#define SWITCH_TIMEOUT_TIME		15000
#define SWITCH_TIMEOUT_RANGE		 3000

#define FIND_NEW_SHORTCUT_TIME		20000	/* FIX: Adjust */
#define FIND_NEW_SHORTCUT_RANGE		 2000

#define SEND_NODE_INFO_TIME		10000
#define SEND_NODE_INFO_RANGE		 2000

#define SHORTCUT_RDP_THRESHHOLD		    0

#define SHORTCUT_PING_TIMEOUT_TIME	((2 * BTP_PING_SEND_TIME) + 3000)
#define SHORTCUT_PING_TIMEOUT_RANGE	BTP_PING_SEND_RANGE

#define SHORTCUT_ADD_TIMEOUT_TIME	15000
#define SHORTCUT_ADD_TIMEOUT_RANGE	 3000


gboolean btp_peer_handler (BConn* bconn, gpointer user_data);

extern BConnFuncs btp_proto_funcs;

void btp_proto_init (BtpTree* tree);


#endif /* _BTP_PROTO_H */
