// mac-file.c

// Egoboo, Copyright (C) 2000 Aaron Bishop

#include "egoboo.h"
#include <Files.h>		/* MacOS specific file stuff */
#include <TextUtils.h>	/* C to Pascal string conversion stuff */



/**> GLOBAL VARIABLES <**/
FSSpec			gFileSpec;
char			gFileType[32];
HFileInfo		gFileInfo;
short			gIndex;
char			gFileName[256];


//---------------------------------------------------------------------------------------------
//File Routines-------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------
void make_directory(char *dirname)
{
    // ZZ> This function makes a new directory
    
    FSSpec	fileSpec;
    long	dirID;
    
    // Convert the directory name from a c string to a pascal string for use with the FSSpec
    c2pstr( dirname );
    
    // Create the file spec
    FSMakeFSSpec( 0, 0, ( unsigned char * )dirname, &fileSpec );
    
    // Convert the filename back to a pascal string
    p2cstr( ( unsigned char * )dirname );
    
    FSpDirCreate( &fileSpec, /*ScriptCode scriptTag*/0, &dirID );
    
}

//---------------------------------------------------------------------------------------------
void remove_directory(char *dirname)
{
    // ZZ> This function removes a directory
    
	FSSpec	fileSpec;
    
    // Convert the directory name from a c string to a pascal string for use with the FSSpec
    c2pstr( dirname );
    
    // Create the file spec
    FSMakeFSSpec( 0, 0, ( unsigned char * )dirname, &fileSpec );
    
    // Convert the directory name back to a pascal string
    p2cstr( ( unsigned char * )dirname );
    
    // Delete the file
    FSpDelete( &fileSpec );
    
}

//---------------------------------------------------------------------------------------------
void delete_file(char *filename)
{
    // ZZ> This function deletes a file
    
    FSSpec	fileSpec;
    
    // Convert the filename from a c string to a pascal string for use with the FSSpec
    c2pstr( filename );
    
    // Create the file spec
    FSMakeFSSpec( 0, 0, ( unsigned char * )filename, &fileSpec );
    
    // Convert the filename back to a pascal string
    p2cstr( ( unsigned char * )filename );
    
    // Delete the file
    FSpDelete( &fileSpec );
    
}

//---------------------------------------------------------------------------------------------
void copy_file(char *source, char *dest)
{
    // ZZ> This function copies a file on the local machine
    
    
    
}

//---------------------------------------------------------------------------------------------
void delete_directory(char *dirname)
{
    // ZZ> This function deletes all files in a directory,
    //     and the directory itself
    
    FSSpec	fileSpec;
    
    // Convert the directory name from a c string to a pascal string for use with the FSSpec
    c2pstr( dirname );
    
    // Create the file spec
    FSMakeFSSpec( 0, 0, ( unsigned char * )dirname, &fileSpec );
    
    // Convert the directory name back to a pascal string
    p2cstr( ( unsigned char * )dirname );
    
    // Delete the file
    FSpDelete( &fileSpec );
    
}

//---------------------------------------------------------------------------------------------
void copy_directory(char *dirname, char *todirname)
{
    // ZZ> This function copies all files in a directory
    
    
    
}

//---------------------------------------------------------------------------------------------
void empty_import_directory(void)
{
    // ZZ> This function deletes all the TEMP????.OBJ subdirectories in the IMPORT directory
    
    
    
}

//---------------------------------------------------------------------------------------------
//Directory Functions--------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------

//---------------------------------------------------------------------------------------------
// Read the first directory entry
char *DirGetFirst(char *search)
{
	
	char	tempStr[256];
	char	*beginTypePos;
	
	/* Set the index */
	gIndex = 1;
	
	/* Set up the HFileInfo */
	gFileInfo.ioNamePtr = ( unsigned char * )gFileName;
	gFileInfo.ioVRefNum = 0;
	
	/* get the file type (file extension) */
	beginTypePos = strstr( search, "*" );
	beginTypePos += 1;
	strncpy( gFileType, beginTypePos, strlen( beginTypePos ) );
	
	/* copy the directory name into a new string for some slight modifications */
	strcpy( tempStr, search );
	//strcat( tempStr, "qz" );	/* we need a real or fake file in the directory for this to work */
	
	/* Convert directory from a c string to a pascal string */
	c2pstr( tempStr );
	
	/* Make a filespec to get the directory ID */
	FSMakeFSSpec( 0, 0, ( unsigned char * )tempStr, &gFileSpec );
	
	/* Convert the directory from a pascal string to a c string */
	p2cstr( ( unsigned char * )tempStr );
	
	/* do the search */
	return DirGetNext();
  
}

//---------------------------------------------------------------------------------------------
// Read the next directory entry (NULL if done)
char *DirGetNext(void)
{
	
	OSErr	error = noErr;
	
	/* set up more HFileInfo stuff */
	gFileInfo.ioFDirIndex = gIndex;
	gFileInfo.ioDirID = gFileSpec.parID;
	
	/* do the actual search */
	error = PBGetCatInfo( ( union CInfoPBRec * )&gFileInfo, false );
	if ( error == noErr )
	{
		p2cstr( ( unsigned char * )gFileName );
		gIndex++;
		
		if ( strlen( gFileName ) > 0 )
		{
			if ( strstr( gFileName, gFileType ) != NULL )
				return gFileName;
			else
				return DirGetNext();
		}
	}
	else
		return NULL;
	
	//return gFileName;
	
}

//---------------------------------------------------------------------------------------------
// Close anything left open
void DirClose()
{
	
	/* Not sure if anything is needed here */
	
}

int ClockGetTick()
{
  return(clock());
}

int DirGetAttrib(char *fromdir)
{
	
	/* Not sure on this one yet */
	
	return(0);
}
