#! /bin/sh

echo 'dude, assuming you are running this script from the packages/net/snmp/agent/current/doc/ directory'

MANPAGE_LIST=`find manpages -type f -name '*.?'`

echo "MANPAGE_LIST is $MANPAGE_LIST"

echo 'removing the previous file snmp-manpages.sgml'
/bin/rm -f snmp-manpages.sgml
touch snmp-manpages.sgml
echo '<!-- HEY YOU!!!!!!!!! -->' >> snmp-manpages.sgml
echo '<!-- this file is automatically generated by the script -->' >> snmp-manpages.sgml
echo '<!-- ' "     $0    " ' -->' >> snmp-manpages.sgml
echo '<!-- so PLEASE do not modify it: your changes will be lost -->' >> snmp-manpages.sgml
echo >> snmp-manpages.sgml
echo >> snmp-manpages.sgml

for manpage in $MANPAGE_LIST
do
    echo "processing $manpage"
    # get the title for this section
    manpage_title=`egrep '^\.TH' $manpage | awk '{print $2}' | tr 'A-Z' 'a-z'`
    # note that _ is illegal in an id, so we canonicalize it to -
    docbook_section_id=`echo $manpage_title | sed 's/_/-/g'`
    # now prepare out a section and title
    echo "  <sect1 id=\"net-snmp-agent-manpages-$docbook_section_id\">" >> snmp-manpages.sgml
    echo "    <title>$manpage_title</title>" >> snmp-manpages.sgml
    # we make it <screen> so that it is a monospaced font
    echo "    <screen>" >> snmp-manpages.sgml

    # now put the contents into this section
    cat $manpage | groff -Tascii -mandoc | sed 's/\_\(.\)/\1/g' \
      | sed 's/\(.\)\(.\)/\1/g' \
      | sed 's/\&/\&amp;/g' \
      | sed 's/</\&lt;/g' \
      | sed 's/+o/o/g' >> snmp-manpages.sgml

    # now close out the section
    echo "    </screen>" >> snmp-manpages.sgml
    echo "  </sect1>" >> snmp-manpages.sgml
    echo >> snmp-manpages.sgml
done

cat <<EOF >> snmp-manpages.sgml

<!-- Keep this comment at the end of the file
Local variables:
mode: sgml
sgml-omittag:nil
sgml-shorttag:t
sgml-namecase-general:t
sgml-general-insert-case:lower
sgml-minimize-attributes:nil
sgml-always-quote-attributes:t
sgml-indent-step:2
sgml-indent-data:t
sgml-parent-document:("tcpip.sgml" "book" "chapter")
sgml-exposed-tags:nil
sgml-local-catalogs:nil
sgml-local-ecat-files:nil
sgml-doctype:"book"
End:
-->

EOF


