/*
 * This file is licensed under the terms of the GNU General Public License,
 * version 2. See the file COPYING in the main directory for details.
 * 
 *  Copyright (C) 2000-2002  Florian Lohoff <flo@rfc822.org>
 *  Copyright (C) 2002,2003  Thiemo Seufer <seufer@csv.ica.uni-stuttgart.de>
 */

#include "delo.h"
#include "stringops.h"

static char *carray[PARM_LIMIT + 2];

char **getconfig(char *partition, char *file, char *config)
{
	char *t;
	char *start;
	char *end;
	int i;
	void *buf;
	char *buffer;

	if (!readfile(&buf, partition, file, 0)) {
		printf("Couldn't fetch config file %s\n", file);
		return NULL;
	}
	buffer = (char *)buf;

	/* Loop over lines */
	while(*buffer != 0x0) {

		start=buffer;

		while(*buffer != 0xa && *buffer != 0x0) {
			/* Delete comments */
			if (*buffer == '#') 
				*buffer=0x0;
			buffer++;
		}

		/* Did we stop at the end of a line ? */
		if (*buffer == 0xa) {
			/* Terminate Line */
			*buffer=0x0;
			buffer++;
		}		

		/* Skip leading spaces and tabs */
		while(*start == ' ' || *start == '\t') 
			start++;

		/* If the start of a line is the end - Next line */
		if (*start == 0x0)
			continue;

		/* get the end pointer */
		end=&start[strlen(start)-1];

		/* Delete spaces and tabs at the end of a line */
		while(*end == ' ' || *end == '\t')
			*end--=0x0;

		if (strncasecmp("label=",start,6) == 0) {
			/* If we found the right profile or want the first */
			if (carray[0])
				if ((config[0] == 0x0) ||
					(strcasecmp(carray[0], config) == 0))
					return carray;
			/* Reset image & append */
			carray[1]=carray[2]=0;
			carray[0]=&start[6];
		} else if (strncasecmp("image=",start,6) == 0) {
			carray[1]=&start[6]; 
		} else if (strncasecmp("append=",start,7) == 0) {
			t=&start[7];
			/* Does append start with " */
			if (*t == '"') {
				t++;
				/* If so - append starts +1 */
				carray[2]=t;
				/* Search ending quote */
				while(*t != '"' && *t != 0x0)
					t++;
				/* And delete */
				if (*t == '"') 
					*t=0x0;
			} else 
				carray[2]=&start[7];

			t=carray[2];
			i=3;
			while(i < PARM_LIMIT && *t != 0x0) {
				t++;
					
				if (*t == ' ' || *t == '\t') {
					*t++=0x0;
					if (*t != 0x0)
						carray[i++]=t;
				}
			}
		}
	}
	/* If we found the profile or want the first */
	if (carray[0]
	    && (config[0] == 0x0 || strcasecmp(carray[0], config) == 0))
		return carray;

	printf("Couldn't find config %s\n", config);
	return NULL;
}
