#include	"config.h"
#include	"courier.h"
#include	"cdfilters.h"
#include        "filtersocketdir.h"
#include	<fstream>
#include        <sys/socket.h>
#include        <sys/un.h>
#include	<sys/time.h>
#if	HAVE_FCNTL_H
#include	<fcntl.h>
#endif
#if HAVE_UNISTD_H
#include	<unistd.h>
#endif
#include	<errno.h>
#include	<ctype.h>
#include	"mydirent.h"
#include	"localstatedir.h"

using namespace std;

static int dofilter(CString,
	const char *,
	unsigned,
	CString (*)(unsigned, void *),
	void *);

int run_filter(const char *filename,
	unsigned nmsgids,
	int iswhitelisted,
	CString (*msgidfunc)(unsigned, void *),
	void *funcarg)
{
	if (nmsgids == 0)	return (0);

DIR	*dirp;
struct dirent *de;
CString	sockname;

	if (!iswhitelisted)
	{
		dirp=opendir(FILTERSOCKETDIR);
		while (dirp && (de=readdir(dirp)) != 0)
		{
			if (de->d_name[0] == '.')	continue;

			sockname = FILTERSOCKETDIR "/";
			sockname += de->d_name;
			if (dofilter( sockname,
					filename, nmsgids,
					msgidfunc,
					funcarg))
			{
				closedir(dirp);
				return (1);
			}
		}
		if (dirp)	closedir(dirp);
	}

	dirp=opendir(ALLFILTERSOCKETDIR);
	while (dirp && (de=readdir(dirp)) != 0)
	{
		if (de->d_name[0] == '.')	continue;

		sockname = ALLFILTERSOCKETDIR "/";
		sockname += de->d_name;
		if (dofilter( sockname,
				filename, nmsgids,
				msgidfunc,
				funcarg))
		{
			closedir(dirp);
			return (1);
		}
	}
	if (dirp)	closedir(dirp);
	return (0);
}

static int dofilter(CString sockname,
	const char *filename,
	unsigned nmsgids,
	CString (*msgidfunc)(unsigned, void *),
	void *funcarg)
{
int	s;
struct  sockaddr_un ssun;
int	triedagain=0;
int	rc;

	if ((s=socket(PF_UNIX, SOCK_STREAM, 0)) < 0)
		clog_msg_errno();

	if (fcntl(s, F_SETFL, O_NDELAY) < 0)
		clog_msg_errno();

	ssun.sun_family=AF_UNIX;
	strcpy(ssun.sun_path, sockname);

	while ((rc=connect(s, (struct sockaddr *)&ssun, sizeof(ssun)) < 0)
	       && errno == EAGAIN)
	{
		if (++triedagain > 5)
			break;
		sleep(1);
		ssun.sun_family=AF_UNIX;
		strcpy(ssun.sun_path, sockname);
	}

	if (rc < 0)
	{
	struct	timeval	tv;
	fd_set	fds;

		if (errno != EINPROGRESS)
		{
			clog_msg_prerrno();
			cout << "432 Mail filters temporarily unavailable.\n"
				<< flush;
			close(s);
			return (1);
		}

		tv.tv_sec=10;
		tv.tv_usec=0;
		FD_ZERO(&fds);
		FD_SET(s, &fds);
		if (select(s+1, &fds, 0, 0, &tv) <= 0)
		{
			cout << "432 Mail filters temporarily unavailable.\n"
				<< flush;
			close(s);
			return (1);
		}
		if (connect(s, (struct sockaddr *)&ssun, sizeof(ssun)) &&
			errno != EISCONN)
		{
			clog_msg_prerrno();
			cout << "432 Mail filters temporarily unavailable.\n"
				<< flush;
			close(s);
			return (1);
		}
	}
	if (fcntl(s, F_SETFL, 0) < 0)
		clog_msg_errno();

afxiopipestream	sockstream(s);

	sockstream << TMPDIR "/" << filename << '\n';

unsigned i;

	for (i=0; i<nmsgids; i++)
	{
		sockname=  (*msgidfunc)(i, funcarg);
		if (sockname.GetLength() == 0)
			sockname=" ";

		sockstream << sockname << '\n';
	}
	sockstream << '\n';
	sockstream << flush;

	if (sockstream.bad())
	{
		sockstream.close();
		clog_msg_prerrno();
		cout << "432 Mail filters temporarily unavailable.\n"
			<< flush;
		close(s);
		return (1);
	}

	if ( (sockname << sockstream) != 0)
	{
		sockstream.close();
		clog_msg_prerrno();
		cout << "432 Mail filters temporarily unavailable.\n"
			<< flush;
		close(s);
		return (1);
	}

int	d=sockname[0];

	if (isdigit(d))
	{
		if (d != '4' && d != '5')
		{
			while (isdigit(sockname[0]) &&
				isdigit(sockname[1]) &&
				isdigit(sockname[2]) &&
				sockname[3] == '-')
			{
				if ( (sockname << sockstream) != 0)
					break;
			}
			sockstream.close();
			close(s);
			return (0);
		}
	}

	cout << sockname << "\n";

	while (isdigit(sockname[0]) && isdigit(sockname[1]) &&
			isdigit(sockname[2]) && sockname[3] == '-')
	{
		if ( (sockname << sockstream) != 0)
			break;
		cout << sockname << "\n";
	}
	cout << flush;
	sockstream.close();
	close(s);
	return (1);
}
