#!/usr/bin/perl -w

# Not a separate package

package Bloksi ;

=head2 C<$g = load( "file.lev" )>

Loads the file "file.lev", and returns a Bloksi. That's a constructor.

=cut

sub load  {

    my $file = shift if @_ ;

    my @lines ;			# 
    my $done = 0 ;
				# Slurp in whole file ################
    if( defined($file) && $file ){

	sayif 0,  "Gonna load( $file )\n";
	if ( !open AA,"<$file" ) {
	    warn "Can't open file '$file'\n" ;
	    return undef;
	}
	@lines = <AA> ;
	close AA ;
    } else {
	$file = "noname.lev" ;
	@lines = $splash_puzzle =~ /(.*\n)/g ;
    }

    local ($comments, $size, $initial, $target, $step, $color, $fgimg,
	   $bgimg, $img, $step, $unmake, $remake) ;

    local (@unmake, @remake);

    local $nmoves = 0 ;

    while ( @lines ) {
	$_ = shift @lines ;
	# Comments are lines starting w/ ';' ###########################
	if( $_ =~ /^;\s*(.*?)\s*$/ ){
	    
	    if( length($1) ){
		$comments = "" unless defined $comments ;
		$comments .= $comments ;
	    }
	    # Define size ############################################
	} elsif ( /^\s*size\s*(\d+)\s+(\d+)/ ) {

	    $size = [$1,$2] ;

	    # Define "initial" or "target" ###########################
	} elsif ( /^\s*(initial|target)/ ) { 
	    
	    my $varname = $1 ;
	    $$varname = join("",splice(@lines,0,$size->[1])) ;
	    $$varname =~ s/\./ /g; 
	    
	    # Define piece's color ###################################
	} elsif ( /^\s*color\s*(\w)\s+(\d+)\s+(\d+)\s+(\d+)/ ) {

	    $color->{$1} = [$2,$3,$4] ;

	    # Define image for fore/background  ######################
	} elsif ( /^\s*((?:fg|bg)img)\s+([\w\.\/]+)/ ) {

	    $$1 = $2 ;
	    print "$1 image is '$2'\n";

	    # Define image for piece decoration  #####################
	} elsif ( /^\s*img\s+(\w)\s+([\w\.]+)/ ) {

	    $img->{$1} = $2 ;

	    # Define step number ######################################
	} elsif ( /^\s*step\s+(\d+)/ ) {

	    $step = $1 ;

	    # History #################################################
	} elsif ( /^(remake|unmake)\b/ ) {
	  
	    my $what = $1 ;
	    ## print "Defining $what\n";
	    push @$what, load_move(\@lines) ;
	    $$what = \@$what ;
	    # HERE must check that nmoves is increasing (remake) or
	    # decreasing (unmake)
	    sayif 0, "Loaded a '$what' at \$nmoves=$what->[$#$what]->{nmoves}\n";
	    
	    # End at end ##############################################
	} elsif ( /^\s*end/ ) {

	    $done = 1 ;

	} else {
	    last if $done ;	# Don't gripe after 'end' has been found

	    warn "Bloksi::load : Don't know what to do with this line :\n$_";
	}
    }
    sayif 0,  "\$initial = \n--$initial--\n\$target = \n--$target--\n";
    unless( defined($initial) ){
	return undef ;
    }
    $g = new Bloksi $initial ;
    
    foreach (qw(file size initial target step nmoves
		color img bgimg fgimg comments
		unmake remake
		)){
	$g->{$_} = $$_ if defined( $$_ ) ;
	## sayif 1,  defined( $$_ ) ? "Adding" : "skipping", " field '$_'\n" ;
    }
    ## if( 0 ){print  
    ##		"remake : ",0+@{$g->{remake}},", ",0+@$remake,"\n",
    ##		"unmake : ",0+@{$g->{unmake}},", ",0+@$unmake,"\n"};

    @{$g}{qw{nmoves s shape}} = 
      @{$g->{unmake}->[0]}{qw{nmoves s shape}} ;

    ## sayif 1,  join ",",%{$g->{color}},"\n";
    
    # Elementary checks ##############################################
				# width 
    warn("Incoherent .lev file : ".
	 "announced width is $size->[1], found $g->{w}.\n".
	 "That should not be a problem") if
	     defined($size) && $size->[0] != $g->{w}  ;

    my $height = $g->{s} =~ s|(.)$|$1|mg ; 
    warn("Incoherent .lev file : ".
	 "announced height is $size->[1], found $height.\n".
	 "That should not be a problem") if 
	     defined($size) && $size->[1] != $height  ;
    
    
    return $g ;
}

# $move = load_move(\@lines)
# Parse a unmake/remake entry in a .lev file
sub load_move 
{ 
    my $a = shift ;

    my $m = { } ;
    my ($addto,$width) ;
    my $done = 0 ;
		       
    while (@$a)
    {
      $_ = shift(@$a) ;
      if( /^;/ ){
	undef $addto; 
	undef $width;
	
      } elsif( /^(moved|dir)\s+/ ){
	
	my $what = $1 ;
	@{$m->{$what}} = /\s(\w+)/g ;
	
      } elsif( /^nmoves\s+(\d+)/ ){
	
	$m->{nmoves} = $1 ;
       
      } elsif( /^(shape|s)/ ) {
	$addto = $1 ;
	$m->{$addto} = "" ;
	
      } elsif( defined $addto ){ # add to $s or $shape
	$m->{$addto} .= $_ ;
	$width = length($_) unless defined $width ;
	warn "load_move : length of row is ",length($_),"!=$width" 
	  unless $width == length($_);
      } else {
	# print "load_move : Don't know what to do with :\n--$_";
	unshift @$a, $_ ;	# Put back last read line
	last;
      }
    } 
    $m->{s}     =~ s/\./ /g if defined $m->{s} ;
    $m->{shape} =~ s/\./ /g if defined $m->{shape} ;

    $m ;
}

## HERE : Don't guess default. require file.
## 
## HERE : Suppress the "file" key in a Bloksi object?
sub save 
{
    my $g = shift ;
    my $file = @_ ? shift :
	exists($g->{file}) && $g->{file} ? $g->{file} : "noname.lev" ;

    sayif 0, "Gonna save to '$file'; '$g->{file}'\n" ;
    if( ! open AA, ">$file" ){
	warn "Can't open '$file' for writing\n" ;
	return 0 ;
    }
    
    print AA defined($g->{comments}) && $g->{comments} ? 
	$g->{comments}  : "; '$file' Created by 'bloksi'\n" ;

    print AA "size $g->{size}->[0] $g->{size}->[1]\n;\n" ;

    my $tmp = $g->{s} ; 
    $tmp =~ s/ /./g ;

    print AA ";\ninitial\n$tmp;\n" ;
    
    if( defined $g->{target} ){
	( $tmp = $g->{target} ) =~ s/ /./g  ;
	print AA "target\n$tmp;\n" ;
    }
				# Foreground Images
    foreach (qw/fgimg bgimg/){
	next unless defined $g->{$_} ;
	print AA "$_ $g->{$_}\n" ;
    }
    
				# Individual images
    if( defined $g->{img} ) {
	while( ($p,$img) = each(%{$g->{img}}) ){
	    print AA "img $p $img\n" ;
	}
    }
				# color color color color color #####
    if( defined( $g->{color} ) &&  keys( %{$g->{color}} ) ){
	while( ($p,$c) = each %{$g->{color}} ){
	    print AA "color $p $c->[0] $c->[1] $c->[2]\n" ;
	}
	print AA ";\n" ;
    }
    print AA "end\n" ;

				# unmake remake unmake remake unmake #
    foreach $ur ("unmake","remake"){
	if( defined( $g->{$ur} ) && @{$g->{$ur}} ){
	    foreach $m (@{$g->{$ur}}){
		# print "$m\n" ; next;
		my $s = $m->{s}     ; $s =~ s/ /./g ; chomp($s) ;
		my $t = $m->{shape} ; $t =~ s/ /./g ; chomp($t) ;
		print AA
		    "$ur\n",
		    "s\n$s\n;\n" ,
		    "shape\n$t\n;\n" ,
		    "nmoves $m->{nmoves}\n" ,
		    "moved ",join(" ",@{$m->{moved}}),"\n" ,
		    "dir ",join(" ",@{$m->{dir}}),"\n;\n" ;
		# For later use ?
		# print AA map {"$_\n$g->{$ur}->{$_}\n;\n"} 
		# qw(s nmoves shape) ;
	    }
	}
    }

    close AA ;
    1 ;
}				# End of save

				# Default puzzle
$splash_puzzle = <<EOF
; D23 from _Sliding Piece Puzzles_
; Move big red block to lower right
size 6 5
step 223
;
initial
.11233
.12237
89AA67
abAA64
cd5544
;
target
......
......
......
....AA
....AA
;
color A 127 0 0
; img A lyx.xpm
color 8 0 0 127
color 9 0 0 127
color a 0 0 127
color b 0 0 127
color c 0 0 127
color d 0 0 127
color 1 0 127 127
color 2 0 127 127
color 3 0 127 127
; img 3 danger.jpg
color 4 0 127 127
;
end
EOF
    ;
1;
