/* Makemail.h - Declarations for generating outgoing headers.
   Copyright (C) 1994 - 2002 Malc Arnold.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


/****************************************************************************/
/* RCS info */

#ifndef lint
static char *MakemailId = "$Id: makemail.h,v 2.3 2002/08/21 23:54:48 malc Exp $";
#endif /* lint */

/****************************************************************************/
/* Functions used to check headers */

extern char *alias(), *alias_mailboxes(), *references();
extern char *contype(), *encoding(), *disposition();

/****************************************************************************/
/* The structure for storing the default headers */

typedef struct {
	char *name;		/* The name of the header */
	unsigned edit : 1;	/* Can we edit this header? */
	unsigned show : 1;	/* Show this header in edits? */
	unsigned reqd : 1;	/* Is this header required? */
	unsigned uniq : 1;	/* Must header appear only once? */
	char *(*chk_func)();	/* Function to check header */
} DEF_HDR;

/****************************************************************************/
/* The list of default outgoing headers */

static DEF_HDR def_headers[] = {
	{ RETURN_PATH, FALSE, FALSE, FALSE, FALSE, NULL },
	{ ENVELOPE_TO, FALSE, FALSE, FALSE, FALSE, NULL },
	{ RECEIVED, FALSE, FALSE, FALSE, FALSE, NULL },
	{ MESSAGE_ID, FALSE, FALSE, FALSE, TRUE, NULL },
	{ DATE, FALSE, FALSE, TRUE, TRUE, NULL },
	{ FROM, TRUE, TRUE, TRUE, TRUE, alias_mailboxes },
	{ SENDER, FALSE, FALSE, FALSE, TRUE, alias },
	{ ORG, TRUE, TRUE, FALSE, FALSE, NULL },
	{ REPLY_TO, TRUE, TRUE, FALSE, TRUE, alias },
	{ SUBJECT, TRUE, TRUE, FALSE, TRUE, NULL },
	{ TO, TRUE, TRUE, FALSE, TRUE, alias },
	{ CC, TRUE, TRUE, FALSE, TRUE, alias },
	{ BCC, TRUE, TRUE, FALSE, TRUE, alias },
	{ MIME_VERSION, FALSE, FALSE, FALSE, TRUE, NULL },
	{ CONTENT_TYPE, TRUE, TRUE, FALSE, TRUE, contype },
	{ C_T_ENCODING, TRUE, TRUE, FALSE, TRUE, encoding },
	{ CONTENT_DISP, TRUE, TRUE, FALSE, TRUE, disposition },
	{ CONTENT_DESC, TRUE, TRUE, FALSE, TRUE, NULL },
	{ IN_REPLY_TO, TRUE, TRUE, FALSE, TRUE, NULL },
	{ REFERENCES, TRUE, FALSE, FALSE, TRUE, references },
	{ CONTENT_LENGTH, FALSE, FALSE, FALSE, TRUE, NULL },
	{ X_MAILER, FALSE, FALSE, FALSE, FALSE, NULL },
	{ STATUS, FALSE, FALSE, FALSE, FALSE, NULL },
	{ X_STATUS, FALSE, FALSE, FALSE, FALSE, NULL },
	{ X_AFSTATUS, FALSE, FALSE, FALSE, FALSE, NULL },
	{ X_AFTAGS, FALSE, FALSE, FALSE, FALSE, NULL },
	{ NULL, FALSE, FALSE, FALSE, FALSE, NULL }
};

/****************************************************************************/
/* The list of default resent headers */

static DEF_HDR def_resent[] = {
	{ RESENT_ID, FALSE, FALSE, FALSE, TRUE, NULL },
	{ RESENT_DATE, FALSE, FALSE, FALSE, TRUE, NULL },
	{ RESENT_FROM, FALSE, TRUE, TRUE, TRUE, alias },
	{ RESENT_SENDER, FALSE, FALSE, FALSE, TRUE, alias },
	{ RESENT_ORG, TRUE, TRUE, FALSE, TRUE, NULL },
	{ RESENT_REPLY_TO, TRUE, TRUE, FALSE, TRUE, alias },
	{ RESENT_TO, TRUE, TRUE, TRUE, TRUE, alias },
	{ RESENT_CC, TRUE, TRUE, FALSE, TRUE, alias },
	{ RESENT_BCC, TRUE, TRUE, FALSE, TRUE, alias },
	{ NULL, FALSE, FALSE, FALSE, FALSE, NULL }
};

/****************************************************************************/
/* The list of default body-part headers */

static DEF_HDR def_body_part[] = {
	{ RETURN_PATH, FALSE, FALSE, FALSE, FALSE, NULL },
	{ RECEIVED, FALSE, FALSE, FALSE, FALSE, NULL },
	{ MESSAGE_ID, FALSE, FALSE, FALSE, TRUE, NULL },
	{ DATE, FALSE, FALSE, FALSE, TRUE, NULL },
	{ FROM, FALSE, FALSE, FALSE, TRUE, alias },
	{ SENDER, FALSE, FALSE, FALSE, TRUE, alias },
	{ ORG, FALSE, FALSE, FALSE, TRUE, NULL },
	{ REPLY_TO, FALSE, FALSE, FALSE, TRUE, alias },
	{ SUBJECT, FALSE, FALSE, FALSE, TRUE, NULL },
	{ TO, FALSE, FALSE, FALSE, TRUE, alias },
	{ CC, FALSE, FALSE, FALSE, TRUE, alias },
	{ BCC, FALSE, FALSE, FALSE, TRUE, alias },
	{ MIME_VERSION, FALSE, FALSE, FALSE, TRUE, NULL },
	{ CONTENT_TYPE, TRUE, TRUE, FALSE, TRUE, contype },
	{ C_T_ENCODING, TRUE, TRUE, FALSE, TRUE, encoding },
	{ CONTENT_DISP, TRUE, TRUE, FALSE, TRUE, disposition },
	{ CONTENT_DESC, TRUE, TRUE, FALSE, TRUE, NULL },
	{ IN_REPLY_TO, FALSE, FALSE, FALSE, TRUE, NULL },
	{ REFERENCES, FALSE, FALSE, FALSE, TRUE, references },
	{ CONTENT_LENGTH, FALSE, FALSE, FALSE, TRUE, NULL },
	{ RESENT_ID, FALSE, FALSE, FALSE, TRUE, NULL },
	{ RESENT_DATE, FALSE, FALSE, FALSE, TRUE, NULL },
	{ RESENT_FROM, FALSE, FALSE, FALSE, TRUE, alias },
	{ RESENT_SENDER, FALSE, FALSE, FALSE, TRUE, alias },
	{ RESENT_ORG, FALSE, FALSE, FALSE, TRUE, NULL },
	{ RESENT_REPLY_TO, FALSE, FALSE, FALSE, TRUE, alias },
	{ RESENT_TO, FALSE, FALSE, FALSE, TRUE, alias },
	{ RESENT_CC, FALSE, FALSE, FALSE, TRUE, alias },
	{ RESENT_BCC, FALSE, FALSE, FALSE, TRUE, alias },
	{ STATUS, FALSE, FALSE, FALSE, FALSE, NULL },
	{ X_STATUS, FALSE, FALSE, FALSE, FALSE, NULL },
	{ X_AFSTATUS, FALSE, FALSE, FALSE, FALSE, NULL },
	{ X_AFTAGS, FALSE, FALSE, FALSE, FALSE, NULL },
	{ X_MAILER, FALSE, FALSE, FALSE, FALSE, NULL },
	{ NULL, FALSE, FALSE, FALSE, FALSE, NULL }
};

/****************************************************************************/
/* The list of headers to include when attaching a message */

static char *headers_to_attach = "Date:From:Sender:Subject:Organization:To:\
Cc:Mime-Version:Content-Type:Content-Transfer-Encoding:Content-Disposition:\
In-Reply-To:References";

/****************************************************************************/
