/* Afack.c - Main module for the af alias file checker.
   Copyright (C) 1990 - 2003 Malc Arnold.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <stdio.h>
#include "af.h"
#include STRING_HDR

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif /* HAVE_UNISTD_H */

#ifdef __STDC__
#include <stdarg.h>
#else /* ! __STDC__ */
#include <varargs.h>
#endif /* ! __STDC__ */

/****************************************************************************/
/* RCS info. */

#ifndef lint
static char *RcsId = "$Id: afack.c,v 2.3 2003/10/27 23:16:20 malc Exp $";
static char *HeaderId = HEADERID;
#endif /* ! lint */

/****************************************************************************/
/* The command line switches valid for afack */

#define AFACKOPTS	"v"

/****************************************************************************/
/* Global function declarations */

extern char *xstrdup();
extern int getopt();
extern void exit(), read_afile();
extern void list_aliases();

/* Local function declarations */

static int getargs();
static void usage();

/****************************************************************************/
/* This flag indicates whether the user has quit or not */

int user_quit = FALSE;

/****************************************************************************/
/* Import the index and error values for getopt() */

extern int optind, opterr;

/****************************************************************************/
/* A couple of definitions from variable.h */

#define V_CHARSET	"default-charset"
#define V_ENCODING	"default-text-encoding"

/****************************************************************************/
int main(argc, argv)
int argc;
char **argv;
{
	/* Process and handle the arguments */

	int i, first_file, verbose;

	/* Process the command line */

	first_file = getargs(argc, argv, &verbose);

	/* Now check each file */

	for (i = first_file; i < argc; i++) {
		if (access(argv[i], 00) != 0) {
			(void) fprintf(stderr, "%s: Can't open %s.\n",
				       argv[0], argv[i]);
		} else {
			read_afile(argv[i], FALSE);
		}
	}

	if (verbose) {
		list_aliases();
	}

	return(0);
}
/****************************************************************************/
static int getargs(argc, argv, verbose)
int argc, *verbose;
char *argv[];
{
	/*
	 * Process the command line.  Set the verbose flag, and
	 * return the position of the first file name in argv.
	 */

	int opt;

	/* Turn off getopt() messages */

	opterr = 0;

	/* Initialize the user options */

	*verbose = FALSE;

	/* Now parse the command line */

	while ((opt = getopt(argc, argv, AFACKOPTS)) != EOF) {
		switch (opt) {
		case 'v':
			*verbose = TRUE;
			break;
		case '?':
			usage(argv[0]);		/* Print usage and quit */
		}

	}

	/* Check that files have been specified */

	if (optind == argc) {
		usage(argv[0]);
	}

	return(optind);
}
/****************************************************************************/
void panic(text)
char *text;
{
	/* Internal panic - shut down and exit, displaying text */

	(void) fprintf(stderr, "%s\n", text);
	exit(2);
}
/****************************************************************************/
/*VARARGS*/
#ifdef __STDC__
void emsgl(char *arg, ...)
#else /* ! __STDC__ */
void emsgl(va_alist)
va_dcl
#endif /* ! __STDC__ */
{
	/*
	 * Display a list of strings to the standard error.
	 * The calling sequence is :
	 * 	emsgl(arg1, arg2, ... , NULL)
	 *
	 * All arguments must be strings.  This could be replaced
	 * by a function calling vsprintf, but there is little
	 * need, and vsprintf is not universally available.
	 */

	va_list arglist;

#ifndef __STDC__
	char *arg;
#endif /* ! __STDC__ */

	/* Initialise the varargs handling */

#ifdef __STDC__
		va_start(arglist, arg);
#else /* ! __STDC__ */
		va_start(arglist);
		arg = va_arg(arglist, char *);
#endif /* ! __STDC__ */

	/* Now loop through the arguments, printing them */

	while (arg != NULL) {
		/* Print this argument and move to the next */

		(void) fputs(arg, stderr);
		arg = va_arg(arglist, char *);
	}

	/* End the line and clean up varargs handling */

	(void) putc('\n', stderr);
	va_end(arglist);

	return;
}
/****************************************************************************/
void typeout(text)
char *text;
{
	/* For afack, this writes the text to stdout */

	(void) fputs(text, stdout);
	return;
}
/****************************************************************************/
void typebin(text, len)
char *text;
size_t len;
{
	/* For afack, this writes the text to stdout */

	(void) fwrite(text, 1, len, stdout);
	return;
}
/****************************************************************************/
void table(name, entry)
char *name, *entry;
{
	/* For afack, this tabulates the entry to stdout */

	char *spaces = "                                ";	/* Indent */

	(void) fputs(name, stdout);

	/* Ignore entry if it is NULL */

	if (entry != NULL) {
		if (strlen(name) < strlen(spaces)) {
			(void) fputs(spaces + strlen(name), stdout);
		}
		(void) fputs(entry, stdout);
	}

	(void) putchar('\n');
	return;
}
/****************************************************************************/
char *get_vtext(name)
char *name;
{
	/*
	 * Return the value of the named variable.  We "know", that
	 * only a couple of variables are called from the code that
	 * afack uses, so we can return the defaults in those cases,
	 * or a NULL pointer otherwise.
	 */

	static char *charset = DEFCHARSET;
	static char *encoding = DEFENCODING;

	/* Now return the right value for the variable */

	return((!strcmp(name, V_CHARSET)) ? charset :
	       (!strcmp(name, V_ENCODING)) ? encoding : NULL);
}
/****************************************************************************/
int viewable_charset(cset)
char *cset;
{
	/* Return TRUE if cset can be viewed on this terminal */

	static char *viewed = DEFVIEWABLE;
	char *cs, *end;
	unsigned len;

	/* Loop through checking charset against viewed */

	cs = viewed;
	while (cs != NULL && *cs != '\0') {
		/* Find the end of the viewable charset */

		end = strchr(cs, ':');

		/* How long is the current charset? */

		len = (end != NULL) ? end - cs : strlen(cs);

		/* Does this charset match the current one? */

		if (len == strlen(cset) && !strncasecmp(cset, cs, len)) {
			return(TRUE);
		}

		/* Update the loop counters */

		cs = (end != NULL) ? end + 1 : NULL;
	}

	/* The character set is not viewable */

	return(FALSE);
}
/****************************************************************************/
/*ARGSUSED*/
char *fold_header(name, text, refold, break_at_commas)
char *name, *text;
int refold, break_at_commas;
{
	/* For afack, this writes the text unchanged */

	return(xstrdup(text));
}
/****************************************************************************/
int ttabspace()
{
	/* For afack this always returns the default */

	return(TAB_WIDTH);
}
/****************************************************************************/
static void usage(prognam)
char *prognam;
{
	/* Print a usage message and exit abnormally */

	(void) fprintf(stderr, "Usage : %s file ...\n", prognam);
	exit(1);
}
/****************************************************************************/
